/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbs.business;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ServiceFactory {
    private static final Log LOGGER = LogFactory.getLog(ServiceFactory.class);
    private static final Map<String, String> SERVICE_MAP = new HashMap<String, String>(16);

    public static <T> T getService(Class<T> clazz) {
        return (T)ServiceFactory.getService(clazz.getSimpleName());
    }

    public static Object getService(String serviceName) {
        String className = SERVICE_MAP.get(serviceName);
        if (className == null) {
            throw new RuntimeException(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u5bf9\u5e94\u7684\u670d\u52a1\u5b9e\u73b0\u672a\u627e\u5230", (String)"ServiceFactory_0", (String)"tsc-tsrbs-business", (Object[])new Object[0]), serviceName));
        }
        try {
            Class<?> cla = Class.forName(className);
            return cla.newInstance();
        }
        catch (Exception exception) {
            LOGGER.error("tsrbs.ServiceFactory.getService error ", (Throwable)exception);
            throw new RuntimeException(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u5bf9\u5e94\u7684\u670d\u52a1\u5b9e\u73b0\u672a\u627e\u5230", (String)"ServiceFactory_0", (String)"tsc-tsrbs-business", (Object[])new Object[0]), serviceName), exception);
        }
    }

    static {
        SERVICE_MAP.put("CoordinationMsgDomainService", "kd.tsc.tsrbs.business.domain.service.CoordinationMsgDomainService");
        SERVICE_MAP.put("CoordinationTaskDomainService", "kd.tsc.tsrbs.business.domain.service.CoordinationTaskDomainService");
        SERVICE_MAP.put("CoordSubscriberDomainService", "kd.tsc.tsrbs.business.domain.service.CoordSubscriberDomainService");
        SERVICE_MAP.put("CoordTaskLogDomainService", "kd.tsc.tsrbs.business.domain.service.CoordTaskLogDomainService");
        SERVICE_MAP.put("CoordinationValidatorDomainService", "kd.tsc.tsrbs.business.domain.service.CoordinationValidatorDomainService");
        SERVICE_MAP.put("CoordPublisherDomainService", "kd.tsc.tsrbs.business.domain.service.CoordPublisherDomainService");
        SERVICE_MAP.put("CoordinationApplicationService", "kd.tsc.tsrbs.business.application.CoordinationApplicationService");
    }
}

