/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbs.business.application;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbs.business.ServiceFactory;
import kd.tsc.tsrbs.business.domain.service.CoordPublisherDomainService;
import kd.tsc.tsrbs.business.domain.service.CoordSubscriberDomainService;
import kd.tsc.tsrbs.business.domain.service.CoordinationMsgDomainService;
import kd.tsc.tsrbs.business.domain.service.CoordinationTaskDomainService;

public class CoordinationApplicationService {
    private static final Log LOGGER = LogFactory.getLog(CoordinationApplicationService.class);
    private final CoordinationMsgDomainService coordinationMsgDomainService = ServiceFactory.getService(CoordinationMsgDomainService.class);
    private final CoordPublisherDomainService coordPublisherDomainService = ServiceFactory.getService(CoordPublisherDomainService.class);
    private final CoordinationTaskDomainService coordinationTaskDomainService = ServiceFactory.getService(CoordinationTaskDomainService.class);
    private final CoordSubscriberDomainService coordSubscriberDomainService = ServiceFactory.getService(CoordSubscriberDomainService.class);

    public boolean isCoordinationMsgExists(Long msgCenterBoId) {
        return this.coordinationMsgDomainService.isMsgExists(msgCenterBoId);
    }

    public DynamicObject queryCoordPublisher(String msgNo) {
        return this.coordPublisherDomainService.queryOneCoordPublisher(msgNo);
    }

    public DynamicObject saveHRBizCoordinationMsg(DynamicObject coordinationLog) {
        DynamicObject newCoordinationMsg = this.coordinationMsgDomainService.newCrossDomainCoordinationMsg();
        HRDynamicObjectUtils.copy((DynamicObject)coordinationLog, (DynamicObject)newCoordinationMsg);
        newCoordinationMsg.set("msgstatus", (Object)"B");
        this.coordinationMsgDomainService.saveCoordinationMsg(newCoordinationMsg);
        return newCoordinationMsg;
    }

    public DynamicObject saveTDCBizCoordinationMsg(Map<String, Object> messageInfo) {
        DynamicObject newCoordinationMsg = this.coordinationMsgDomainService.saveInDomainCoordinationMsg(messageInfo);
        return newCoordinationMsg;
    }

    public void createCoordinationTasks(DynamicObject coordinationMsg) {
        if (HRObjectUtils.isEmpty((Object)coordinationMsg)) {
            return;
        }
        String msgSubNo = coordinationMsg.getString("msgsubno");
        if (HRStringUtils.isEmpty((String)msgSubNo)) {
            return;
        }
        DynamicObject[] coordSubscriberList = this.coordSubscriberDomainService.getCoordSubscriberList(Collections.singletonList(msgSubNo));
        if (coordSubscriberList == null || coordSubscriberList.length < 1) {
            return;
        }
        this.coordinationTaskDomainService.batchCreateTask(coordinationMsg, coordSubscriberList);
    }

    public void subscribeInDomainCoordMsg(List<String> msgSubNoList) {
        this.coordPublisherDomainService.subscribePublisher(msgSubNoList);
    }

    public void unsubscribeInDomainCoordMsg(List<String> msgSubNoList) {
        DynamicObject[] coordSubscriberList = this.coordSubscriberDomainService.getCoordSubscriberList(msgSubNoList);
        Map<String, List<DynamicObject>> coordSubscriberMap = Arrays.stream(coordSubscriberList).collect(Collectors.groupingBy(coordSubscriber -> coordSubscriber.getString("msgsubno")));
        ArrayList unSubscribeNumber = Lists.newArrayList();
        coordSubscriberMap.forEach((key, value) -> {
            if (value.size() == 1) {
                unSubscribeNumber.add(key);
            }
        });
        this.coordPublisherDomainService.unSubscribePublisher(unSubscribeNumber);
    }

    public void callBackResult(DynamicObject coordinationMsg, Map<String, Object> resultMap) {
        this.coordinationTaskDomainService.callBackResult(coordinationMsg, resultMap);
    }
}

