/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbs.business.domain.base;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

public class BaseHelper {
    public static final int ZERO = 0;
    private static HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("");

    public static void delete(Object[] pks, String entityName) {
        if (StringUtils.isEmpty((CharSequence)entityName)) {
            return;
        }
        hrBaseServiceHelper.setEntityName(entityName);
        hrBaseServiceHelper.delete(pks);
    }

    public static void deleteByFilter(QFilter[] qFilters, String entityName) {
        if (StringUtils.isEmpty((CharSequence)entityName)) {
            return;
        }
        hrBaseServiceHelper.setEntityName(entityName);
        hrBaseServiceHelper.deleteByFilter(qFilters);
    }

    public static int count(QFilter[] qFilters, String entityName) {
        if (StringUtils.isEmpty((CharSequence)entityName) || ArrayUtils.isEmpty((Object[])qFilters)) {
            return 0;
        }
        return hrBaseServiceHelper.count(entityName, qFilters);
    }

    public static DynamicObject createDynamicObject(String entityName) {
        if (StringUtils.isEmpty((CharSequence)entityName)) {
            return null;
        }
        hrBaseServiceHelper.setEntityName(entityName);
        return hrBaseServiceHelper.generateEmptyDynamicObject();
    }

    public static Object insert(DynamicObject object, String entityName) {
        if (StringUtils.isEmpty((CharSequence)entityName)) {
            return null;
        }
        hrBaseServiceHelper.setEntityName(entityName);
        return hrBaseServiceHelper.saveOne(object);
    }

    public static Object insert(DynamicObject[] object, String entityName) {
        if (StringUtils.isEmpty((CharSequence)entityName)) {
            return null;
        }
        hrBaseServiceHelper.setEntityName(entityName);
        return hrBaseServiceHelper.save(object);
    }

    public static List<DynamicObject> selectByFilter(QFilter[] qFilters, String entityName) {
        if (StringUtils.isEmpty((CharSequence)entityName) || ArrayUtils.isEmpty((Object[])qFilters)) {
            return Collections.emptyList();
        }
        hrBaseServiceHelper.setEntityName(entityName);
        Object[] dynamicObjects = hrBaseServiceHelper.loadDynamicObjectArray(qFilters);
        if (ArrayUtils.isEmpty((Object[])dynamicObjects)) {
            return Collections.emptyList();
        }
        ArrayList list = new ArrayList(dynamicObjects.length);
        return Collections.addAll(list, dynamicObjects) ? list : Collections.emptyList();
    }

    public static List<DynamicObject> selectWithoutFilter(String queryColumn, String entityName) {
        return BaseHelper.selectByFilter(Arrays.asList(queryColumn.split(",")), null, entityName);
    }

    public static List<DynamicObject> selectByFilter(String queryColumn, QFilter[] qFilters, String entityName) {
        return BaseHelper.selectByFilter(Arrays.asList(queryColumn.split(",")), qFilters, entityName);
    }

    public static List<DynamicObject> selectByFilter(List<String> queryColumnList, QFilter[] qFilters, String entityName) {
        if (CollectionUtils.isEmpty(queryColumnList) || StringUtils.isEmpty((CharSequence)entityName)) {
            return Collections.emptyList();
        }
        String queryColumnStr = StringEscapeUtils.unescapeJava((String)StringUtils.join(queryColumnList, (String)","));
        hrBaseServiceHelper.setEntityName(entityName);
        Object[] dynamicObjects = hrBaseServiceHelper.query(queryColumnStr, qFilters);
        if (ArrayUtils.isEmpty((Object[])dynamicObjects)) {
            return Collections.emptyList();
        }
        ArrayList list = new ArrayList(dynamicObjects.length);
        return Collections.addAll(list, dynamicObjects) ? list : Collections.emptyList();
    }

    public static DynamicObject selectById(Long id, String entityName) {
        if (Objects.isNull(id) || StringUtils.isEmpty((CharSequence)entityName)) {
            return null;
        }
        hrBaseServiceHelper.setEntityName(entityName);
        return hrBaseServiceHelper.queryOne((Object)id);
    }

    public static List<DynamicObject> selectByIdList(List<Long> idList, String entityName) {
        if (CollectionUtils.isEmpty(idList) || StringUtils.isEmpty((CharSequence)entityName)) {
            return Collections.emptyList();
        }
        hrBaseServiceHelper.setEntityName(entityName);
        Object[] dynamicObjects = hrBaseServiceHelper.loadDynamicObjectArray((Object[])idList.toArray(new Long[idList.size()]));
        if (ArrayUtils.isEmpty((Object[])dynamicObjects)) {
            return Collections.emptyList();
        }
        ArrayList list = new ArrayList(dynamicObjects.length);
        return Collections.addAll(list, dynamicObjects) ? list : Collections.emptyList();
    }

    public static List<DynamicObject> selectByIdList(List<Long> idList, List<String> queryColumnList, String entityName) {
        if (CollectionUtils.isEmpty(idList) || CollectionUtils.isEmpty(queryColumnList) || StringUtils.isEmpty((CharSequence)entityName)) {
            return Collections.emptyList();
        }
        String queryColumnStr = StringEscapeUtils.unescapeJava((String)StringUtils.join(queryColumnList, (String)","));
        hrBaseServiceHelper.setEntityName(entityName);
        QFilter qFilter = new QFilter("id", "in", idList);
        Object[] dynamicObjects = hrBaseServiceHelper.query(queryColumnStr, qFilter.toArray());
        if (ArrayUtils.isEmpty((Object[])dynamicObjects)) {
            return Collections.emptyList();
        }
        ArrayList list = new ArrayList(dynamicObjects.length);
        return Collections.addAll(list, dynamicObjects) ? list : Collections.emptyList();
    }

    public static Object[] update(DynamicObject[] objects, String entityName) {
        if (ArrayUtils.isEmpty((Object[])objects) || StringUtils.isEmpty((CharSequence)entityName)) {
            return ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        hrBaseServiceHelper.setEntityName(entityName);
        return hrBaseServiceHelper.update(objects);
    }

    public static Object update(DynamicObject object, String entityName) {
        if (Objects.isNull(object) || StringUtils.isEmpty((CharSequence)entityName)) {
            return null;
        }
        DynamicObject[] objects = new DynamicObject[]{object};
        return hrBaseServiceHelper.update(objects)[0];
    }
}

