/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbs.business.domain.common.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.basedata.IBaseDataCtrlPlugin;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class AdminAndOrgHelper {
    private static final String QUERY_PERM = "47150e89000000ac";
    public static final String ISCTRLUNIT = "isctrlunit";
    public static final String VIEWID = "view.id";
    public static final String ENTITYID_ORG_STRUCTURE = "bos_org_structure";
    private static final String ORG_ENTITY = "bos_org";

    @Deprecated
    public static List<Long> getCurrentUserAdminOrg() {
        return AdminAndOrgHelper.getUserAdminOrg(TSCRequestContext.getUserId());
    }

    @Deprecated
    public static List<Long> getUserAdminOrg(Long userId) {
        return (List)HRMServiceHelper.invokeHRMPService((String)"hbss", (String)"IHBSSService", (String)"getOrgListFromPermFiles", (Object[])new Object[]{userId});
    }

    public static List<Long> getCurrentUserAdminOrg(String appId, String entityNumber) {
        return AdminAndOrgHelper.getUserAdminOrg(TSCRequestContext.getUserId(), appId, entityNumber, QUERY_PERM);
    }

    @Deprecated
    public static List<Long> getUserAdminOrg(Long userId, String appId, String entityNumber, String permId) {
        AuthorizedOrgResult authorizedAdminOrgs = AdminAndOrgHelper.getAuthorizedAdminOrgs(userId, appId, entityNumber, permId, false);
        if (authorizedAdminOrgs.isHasAllOrgPerm()) {
            return AdminAndOrgHelper.getAllAdminOrgs(false);
        }
        return authorizedAdminOrgs.getHasPermOrgs();
    }

    @Deprecated
    public static AuthorizedOrgResult getAuthorizedAdminOrgs(Long userId, String appId, String entityNumber, String permId, boolean isEnable) {
        return (AuthorizedOrgResult)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getAuthorizedAdminOrgs", (Object[])new Object[]{userId, appId, entityNumber, permId, isEnable});
    }

    public static List<Long> getUserAdminOrgsF7(String appId, String entityNumber, String propKey) {
        AuthorizedOrgResult authorizedAdminOrgs = AdminAndOrgHelper.getAuthorizedAdminOrgsF7(appId, entityNumber, propKey);
        if (authorizedAdminOrgs.isHasAllOrgPerm()) {
            return AdminAndOrgHelper.getAllAdminOrgs(false);
        }
        return authorizedAdminOrgs.getHasPermOrgs();
    }

    public static AuthorizedOrgResult getAuthorizedAdminOrgsF7(String appId, String entityNumber, String propKey) {
        return AdminAndOrgHelper.getAuthorizedAdminOrgsF7(TSCRequestContext.getUserId(), appId, entityNumber, QUERY_PERM, propKey);
    }

    public static AuthorizedOrgResult getAuthorizedAdminOrgsF7(Long userId, String appId, String entityNumber, String permItemId, String propKey) {
        return (AuthorizedOrgResult)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getAuthorizedAdminOrgsF7", (Object[])new Object[]{userId, appId, entityNumber, permItemId, propKey});
    }

    public static List<Long> getAllAdminOrgs(boolean isEnable) {
        return (List)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getAllAdminOrgs", (Object[])new Object[]{isEnable});
    }

    public static List<Long> getPositionCurrentOrgIds() {
        DynamicObjectCollection orgCollect = AdminAndOrgHelper.getAllUseOrgForPosition("tssrm_position_add", AppMetadataCache.getAppInfo((String)"tssrm").getId());
        if (orgCollect == null || orgCollect.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList orgResult = Lists.newArrayListWithExpectedSize((int)orgCollect.size());
        for (DynamicObject org : orgCollect) {
            Long id = org.getLong("id");
            if (id.equals(0L)) continue;
            orgResult.add(id);
        }
        return orgResult;
    }

    public static List<Long> getPositionCurrentOrgIds(String entityType, String appid) {
        DynamicObjectCollection orgCollect = AdminAndOrgHelper.getAllUseOrgForPosition(entityType, AppMetadataCache.getAppInfo((String)appid).getId());
        if (orgCollect == null || orgCollect.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList orgResult = Lists.newArrayListWithExpectedSize((int)orgCollect.size());
        for (DynamicObject org : orgCollect) {
            Long id = org.getLong("id");
            if (id.equals(0L)) continue;
            orgResult.add(id);
        }
        return orgResult;
    }

    public static DynamicObjectCollection getAllUseOrgForPosition(String entityType, String appid) {
        QFilter[] filters = AdminAndOrgHelper.getAllUseOrgQFilters(entityType, appid);
        QFilter qFilter = new QFilter("id", "=", (Object)TSCRequestContext.getOrgId());
        DynamicObjectCollection positionPermDyn = QueryServiceHelper.query((String)ORG_ENTITY, (String)"id,name", (QFilter[])filters, (String)"number");
        DynamicObjectCollection currentDyn = QueryServiceHelper.query((String)ORG_ENTITY, (String)"id,name", (QFilter[])new QFilter[]{qFilter}, (String)"number");
        if (positionPermDyn == null || positionPermDyn.isEmpty()) {
            return currentDyn;
        }
        List collect = positionPermDyn.stream().map(permDyn -> permDyn.getString("id")).collect(Collectors.toList());
        if (!collect.contains(((DynamicObject)currentDyn.get(0)).getString("id"))) {
            positionPermDyn.add(0, (DynamicObject)currentDyn.get(0));
        } else {
            int index = positionPermDyn.stream().map(position -> position.getString("id")).collect(Collectors.toList()).indexOf(((DynamicObject)currentDyn.get(0)).getString("id"));
            if (index > 0) {
                positionPermDyn.add(0, positionPermDyn.remove(index));
            }
        }
        return positionPermDyn;
    }

    private static QFilter[] getAllUseOrgQFilters(String entityType, String appid) {
        String orgFuncPro;
        long userId = TSCRequestContext.getUserId();
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appid, (String)entityType, (String)QUERY_PERM);
        if (result == null) {
            return new QFilter[0];
        }
        String useOrgFunc = BaseDataServiceHelper.getUseOrgFunc((String)entityType);
        QFilter idsFilter = new QFilter("org", "in", (Object)result.getHasPermOrgs());
        ArrayList filterList = Lists.newArrayListWithExpectedSize((int)10);
        if (!StringUtils.isEmpty((CharSequence)useOrgFunc) && StringUtils.isNotEmpty((CharSequence)(orgFuncPro = OrgServiceHelper.getOrgBizPro((String)useOrgFunc)))) {
            QFilter orgFuncFilter = new QFilter(orgFuncPro, "=", (Object)Boolean.TRUE);
            filterList.add(orgFuncFilter);
        }
        DynamicObject ctrlview = BaseDataServiceHelper.getCtrlview((String)entityType);
        ArrayList<Long> viewOrgIds = new ArrayList<Long>();
        Long view = null == ctrlview ? Long.valueOf(16L) : Long.valueOf(ctrlview.getLong("id"));
        QFilter f2 = new QFilter(VIEWID, "=", (Object)view);
        QFilter f3 = new QFilter(ISCTRLUNIT, "=", (Object)Boolean.TRUE);
        QFilter[] qfilters = result.hasAllOrgPerm() ? new QFilter[]{f2, f3} : new QFilter[]{f2, f3, idsFilter};
        AdminAndOrgHelper.getAllUseOrg_1(filterList, entityType);
        DynamicObject[] viewOrgs = BusinessDataServiceHelper.load((String)ENTITYID_ORG_STRUCTURE, (String)"org", (QFilter[])qfilters);
        if (null == viewOrgs) {
            return new QFilter[0];
        }
        for (DynamicObject viewOrg : viewOrgs) {
            if (viewOrg.getDynamicObject("org") == null) continue;
            viewOrgIds.add((Long)viewOrg.getDynamicObject("org").getPkValue());
        }
        idsFilter = new QFilter("id", "in", viewOrgIds);
        filterList.add(idsFilter);
        QFilter[] filters = filterList.toArray(new QFilter[0]);
        return filters;
    }

    private static void getAllUseOrg_1(List<QFilter> filterList, String entityType) {
        QFilter extendOrgQFilter;
        IBaseDataCtrlPlugin baseDataCtrlPlugin = BaseDataServiceHelper.getBaseDataCtrlPlugin((String)entityType);
        if (baseDataCtrlPlugin != null && (extendOrgQFilter = baseDataCtrlPlugin.getExtendOrgQFilter()) != null) {
            filterList.add(extendOrgQFilter);
        }
    }
}

