/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbs.business.domain.common.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.IFormView;
import kd.bos.form.field.FieldEdit;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import org.apache.commons.lang3.SerializationUtils;

public class CommonHelper {
    private static Map<String, HRBaseServiceHelper> SERVICE_HELPER_MAP = new WeakHashMap<String, HRBaseServiceHelper>(4);

    private CommonHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HRBaseServiceHelper getServiceHelper(String pageKey) {
        String tempObj = pageKey;
        HRBaseServiceHelper serviceHelper = SERVICE_HELPER_MAP.get(pageKey);
        if (serviceHelper == null) {
            String string = tempObj;
            synchronized (string) {
                serviceHelper = new HRBaseServiceHelper(pageKey);
                SERVICE_HELPER_MAP.put(pageKey, serviceHelper);
            }
        }
        return serviceHelper;
    }

    public static List<DynamicObject> sortById(DynamicObject[] dyns, List<Long> sortOrder) {
        ArrayList resultSort = Lists.newArrayListWithExpectedSize((int)dyns.length);
        ArrayList sort = Lists.newArrayList();
        ArrayList unSort = Lists.newArrayList();
        for (Long sortId : sortOrder) {
            for (DynamicObject dynamicObject : dyns) {
                if (!sortId.equals(dynamicObject.getLong("id"))) continue;
                sort.add(dynamicObject);
            }
        }
        for (DynamicObject dynamicObject : dyns) {
            boolean needAdd = true;
            for (DynamicObject afterSort : sort) {
                if (afterSort.getLong("id") != dynamicObject.getLong("id")) continue;
                needAdd = false;
                break;
            }
            if (!needAdd) continue;
            unSort.add(dynamicObject);
        }
        resultSort.addAll(sort);
        resultSort.addAll(unSort);
        return resultSort;
    }

    public static QFilter changePropertyName(QFilter qFilter, String afterChangeProperty) {
        if (qFilter == null) {
            return null;
        }
        QFilter copyQFilter = (QFilter)SerializationUtils.clone((Serializable)qFilter);
        copyQFilter.__setProperty(afterChangeProperty);
        List nests = copyQFilter.getNests(true);
        nests.forEach(net -> net.getFilter().__setProperty(afterChangeProperty));
        return copyQFilter;
    }

    public static void sortListByDate(List<Date> sortDateList) {
        if (sortDateList == null) {
            return;
        }
        sortDateList.sort((o1, o2) -> {
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            if (o1.after((Date)o2)) {
                return -1;
            }
            if (o1.before((Date)o2)) {
                return 1;
            }
            return 0;
        });
    }

    public static void setMustInput(IFormView view, String propName, boolean mustInput) {
        FieldEdit fieldEdit = (FieldEdit)view.getControl(propName);
        fieldEdit.setMustInput(mustInput);
        MainEntityType mainEntityType = view.getModel().getDataEntityType();
        IDataEntityProperty dataEntityProperty = mainEntityType.findProperty(propName);
        if (dataEntityProperty instanceof BasedataProp) {
            ((BasedataProp)dataEntityProperty).setMustInput(mustInput);
        } else if (dataEntityProperty instanceof FieldProp) {
            ((FieldProp)dataEntityProperty).setMustInput(mustInput);
        } else if (dataEntityProperty instanceof EntryProp) {
            ((EntryProp)dataEntityProperty).setEntryMustInput(mustInput);
        } else if (dataEntityProperty instanceof MulBasedataProp) {
            ((MulBasedataProp)dataEntityProperty).setMustInput(mustInput);
        }
    }

    public static void ignoreFieldUpdate(IFormView view, String propName) {
        DataEntityState dataEntityState = view.getModel().getDataEntity().getDataEntityState();
        IDataEntityProperty dataEntityProperty = view.getModel().getDataEntityType().findProperty(propName);
        int propOrdinal = dataEntityProperty.getOrdinal();
        dataEntityState.setBizChanged(propOrdinal, false);
        if (dataEntityProperty instanceof BasedataProp) {
            int refIdPropOrdinal = ((BasedataProp)dataEntityProperty).getRefIdProp().getOrdinal();
            dataEntityState.setBizChanged(refIdPropOrdinal, false);
        }
    }

    public static void copyObj(DynamicObject fromObj, DynamicObject toObj, Set<String> ignoreKeys) {
        if (null == fromObj || null == toObj || null == ignoreKeys) {
            return;
        }
        HashSet dirtyIgnoreKeys = Sets.newHashSet(ignoreKeys);
        DataEntityPropertyCollection fromProp = fromObj.getDataEntityType().getProperties();
        DataEntityPropertyCollection toProp = toObj.getDataEntityType().getProperties();
        ignoreKeys.forEach(key -> {
            IDataEntityProperty prop = (IDataEntityProperty)fromProp.get(key);
            if (null == prop) {
                prop = (IDataEntityProperty)toProp.get(key);
            }
            if (null != prop && prop instanceof DynamicComplexProperty) {
                dirtyIgnoreKeys.add(key + "_id");
            }
        });
        HRDynamicObjectUtils.copy((DynamicObject)fromObj, (DynamicObject)toObj, (Set)dirtyIgnoreKeys);
    }
}

