/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbs.business.domain.common.service;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.permission.api.HasPermOrgResultImpl;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class HRStructureTreeOrgHelper {
    private static final Log LOGGER = LogFactory.getLog(HRStructureTreeOrgHelper.class);
    private static final String HR_TR = "24";

    public static Pair<Boolean, List<Long>> getIntHROrgStrucViewAndUserPermOrg(String appNumber, String pageNumber, String permissionItem) {
        LOGGER.info("appNumber:{},pageNumber:{},permissionItem:{}", new Object[]{appNumber, pageNumber, permissionItem});
        HasPermOrgResult hasPermOrgResult = HRStructureTreeOrgHelper.getHasPermOrgResult(appNumber, pageNumber, permissionItem);
        List<Long> orgList = HRStructureTreeOrgHelper.queryHRStructureOrgByAppID();
        return HRStructureTreeOrgHelper.takeOrgIntersection(hasPermOrgResult, orgList);
    }

    public static Pair<Boolean, List<Long>> getIntHROrgStrucViewAndUserAllOrg(Long userId) {
        LOGGER.info("userId:{}", (Object)userId);
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getUserHasPermOrgs((long)userId);
        List<Long> orgList = HRStructureTreeOrgHelper.queryHRStructureOrgByAppID();
        return HRStructureTreeOrgHelper.takeOrgIntersection(hasPermOrgResult, orgList);
    }

    public static Pair<Boolean, List<Long>> takeOrgIntersection(HasPermOrgResult hasPermOrgResult, List<Long> orgList) {
        MutablePair pair = new MutablePair((Object)Boolean.TRUE, orgList);
        if (!hasPermOrgResult.hasAllOrgPerm()) {
            List result = orgList.stream().filter(item -> hasPermOrgResult.getHasPermOrgs().contains(item)).collect(Collectors.toList());
            pair.setLeft((Object)Boolean.FALSE);
            pair.setRight(result);
        }
        LOGGER.info("HRStructureTreeOrgHelper.takeOrgIntersection.Pair : {}", (Object)SerializationUtils.toJsonString((Object)pair));
        return pair;
    }

    public static Pair<Boolean, List<Long>> getIntHROrgStrucViewAndUserPermOrg(String appNumber, String pageNumber, Long viewID, String permissionItem) {
        LOGGER.info("appNumber:{},pageNumber:{},viewID:{},permissionItem:{}", new Object[]{appNumber, pageNumber, viewID, permissionItem});
        HasPermOrgResult hasPermOrgResult = HRStructureTreeOrgHelper.getHasPermOrgResult(appNumber, pageNumber, permissionItem);
        List<Long> orgList = HRStructureTreeOrgHelper.queryHRStructureOrg(viewID);
        return HRStructureTreeOrgHelper.takeOrgIntersection(hasPermOrgResult, orgList);
    }

    public static List<Long> queryHRStructureOrgByAppID() {
        return HRStructureTreeOrgHelper.queryDefaultHRStructureOrg();
    }

    public static List<Long> queryHRStructureOrg(long viewId) {
        return OrgUnitServiceHelper.getAllOrgByViewId((long)viewId, (boolean)false);
    }

    public static List<Long> queryDefaultHRStructureOrg() {
        DynamicObject dynamicObject = HRStructureTreeOrgHelper.queryDefaultHRStructureDynamicObject();
        return HRStructureTreeOrgHelper.queryHRStructureOrg(dynamicObject.getLong("id"));
    }

    public static DynamicObject queryDefaultHRStructureDynamicObject() {
        long defaultHRViewSchemaID = HRStructureTreeOrgHelper.getDefaultHRViewSchemaID();
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("bos_org_viewschema");
        return hrBaseServiceHelper.queryOne((Object)defaultHRViewSchemaID);
    }

    public static HasPermOrgResult getHasPermOrgResult(String appNumber, String pageNumber, String permissionItem) {
        HasPermOrgResult result;
        LOGGER.info("appNumber:{},pageNumber:{},permissionItem:{}", new Object[]{appNumber, pageNumber, permissionItem});
        long userId = TSCRequestContext.getUserId();
        String appId = HRStructureTreeOrgHelper.getAppIdByAppNumber(appNumber);
        String entityNum = HRStructureTreeOrgHelper.getEntityNumber(pageNumber);
        if (permissionItem == null || HRStringUtils.equals((String)permissionItem, (String)"47150e89000000ac")) {
            result = HRStructureTreeOrgHelper.getAllPermOrg(userId, appId, entityNum, "47150e89000000ac");
        } else {
            Set<String> entityPermSetByNumber = HRStructureTreeOrgHelper.getEntityPermSetByNumber(entityNum);
            result = HRStructureTreeOrgHelper.getAllPermOrg(userId, appId, entityNum, permissionItem);
            if (entityPermSetByNumber.contains("47150e89000000ac")) {
                HasPermOrgResult viewPerm = HRStructureTreeOrgHelper.getAllPermOrg(userId, appId, entityNum, "47150e89000000ac");
                List hasPermOrgs = result.getHasPermOrgs().stream().filter(org -> viewPerm.getHasPermOrgs().contains(org)).collect(Collectors.toList());
                result = new HasPermOrgResultImpl(viewPerm.hasAllOrgPerm(), hasPermOrgs);
            }
        }
        return result;
    }

    public static HasPermOrgResult getAllPermOrg(long userId, String appId, String entityNum, String permissionItem) {
        return PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appId, (String)entityNum, (String)permissionItem);
    }

    public static String getEntityNumber(String pageNumber) {
        return FormMetadataCache.getFormConfig((String)pageNumber).getEntityTypeId();
    }

    public static Set<String> getEntityPermSetByNumber(String pageNumber) {
        return EntityMetadataCache.getPermissionItems((String)pageNumber);
    }

    public static String getAppIdByAppNumberOrPageNumber(String appNumber, String pageNumber) {
        String appid;
        MainEntityType met = EntityMetadataCache.getDataEntityType((String)HRStructureTreeOrgHelper.getEntityNumber(pageNumber));
        try {
            appid = AppMetadataCache.getAppInfo((String)appNumber).getId();
        }
        catch (Exception ex) {
            LOGGER.info("HRStructureTreeOrgHelper.getAppIdByAppNumberOrPageNumber.Exception : {}", (Object)ex.getMessage());
            appid = met.getAppId();
        }
        return appid;
    }

    public static String getAppIdByAppNumber(String appNumber) {
        return AppMetadataCache.getAppInfo((String)appNumber).getId();
    }

    public static List<Map<String, Object>> getHRViewSchemaByType() {
        return OrgUnitServiceHelper.getViewSchemaByType((String)HR_TR);
    }

    public static long getDefaultHRViewSchemaID() {
        return OrgUnitServiceHelper.getViewIdByType((String)HR_TR);
    }

    public static Pair<Boolean, List<Long>> getIntHROrgStrucViewAndUserPermOrg() {
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getUserHasPermOrgs((long)RequestContext.get().getCurrUserId(), (boolean)Boolean.TRUE);
        List<Long> orgList = HRStructureTreeOrgHelper.queryHRStructureOrgByAppID();
        return HRStructureTreeOrgHelper.takeOrgIntersection(hasPermOrgResult, orgList);
    }
}

