/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbs.business.domain.common.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class ListFilterCommonHelper {
    private static final String KEY_CUSTOM_FILTER = "customfilter";
    private static final String KEY_FIELD_NAME = "FieldName";
    private static final String KEY_VALUE = "Value";

    public static void clearCustomFilterOnSearchClick(FilterContainerSearchClickArgs args, String fieldName) {
        if (args == null || args.getSearchClickEvent() == null || args.getSearchClickEvent().getFilterValues() == null) {
            return;
        }
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        List customFilters = (List)filterValues.get(KEY_CUSTOM_FILTER);
        if (customFilters == null) {
            return;
        }
        for (Map customFilter : customFilters) {
            List values;
            List keys = (List)customFilter.get(KEY_FIELD_NAME);
            if (keys == null || keys.size() == 0) {
                return;
            }
            String key = (String)keys.get(0);
            if (!HRStringUtils.equals((String)fieldName, (String)key) || (values = (List)customFilter.get(KEY_VALUE)) == null) continue;
            values.clear();
        }
    }

    public static void initColumnToDefaultVal(FilterContainerInitArgs args, String key) {
        FilterColumn filterColumn = args.getFilterColumn(key);
        filterColumn.setDefaultValue("");
    }

    public static void generalCommonColumnInit(CommonFilterColumn commonColumn, QFilter[] qFilters, String pageName, String orderBys) {
        commonColumn.setDefaultValue("");
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(pageName);
        DynamicObject[] col = hrBaseServiceHelper.query("id,name", qFilters, orderBys);
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(col.length);
        for (DynamicObject dynamicObject : col) {
            ComboItem item = new ComboItem();
            item.setId(String.valueOf(dynamicObject.getPkValue()));
            item.setCaption(new LocaleString(dynamicObject.getString("name")));
            item.setValue(String.valueOf(dynamicObject.getPkValue()));
            combos.add(item);
        }
        commonColumn.setComboItems(combos);
    }
}

