/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbs.business.domain.common.service;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TscHrPersonHelper {
    private static final Logger logger = LoggerFactory.getLogger(TscHrPersonHelper.class);

    public Map<Long, DynamicObject> getSysPerByPerId(Set<Long> hrPersonId) {
        String msg = ResManager.loadKDString((String)"hr\u4eba\u5458\u65e0\u6cd5\u5339\u914d\u7cfb\u7edf\u7528\u6237", (String)"TscHrPersonHelper_0", (String)"tsc-tsrbs-business", (Object[])new Object[0]);
        HashMap<Long, DynamicObject> personMap = new HashMap<Long, DynamicObject>(16);
        if (hrPersonId == null || hrPersonId.isEmpty()) {
            return personMap;
        }
        HRBaseServiceHelper poolHelper = new HRBaseServiceHelper("hrpi_personuserrel");
        String queryField = "user,person";
        QFilter personFilter = new QFilter("person", "in", hrPersonId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter[] filters = new QFilter[]{personFilter, enableFilter};
        DynamicObject[] personArray = poolHelper.query(queryField, filters);
        if (personArray == null || personArray.length == 0) {
            logger.error("TscHrPersonHelper.GetSysPerByPerId hr\u4eba\u5458\u65e0\u6cd5\u5339\u914d\u7cfb\u7edf\u7528\u6237");
            throw new KDException(new ErrorCode("", msg), new Object[]{msg});
        }
        Object[] bosUserIds = new Long[personArray.length];
        for (int i = 0; i < personArray.length; ++i) {
            DynamicObject dy = personArray[i];
            bosUserIds[i] = dy.getLong("user");
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_user");
        DynamicObject[] bosUserDys = serviceHelper.loadDynamicObjectArray(bosUserIds);
        HashMap bosUserIdAndDys = Maps.newHashMapWithExpectedSize((int)personArray.length);
        for (DynamicObject bosUserDy : bosUserDys) {
            bosUserIdAndDys.put((Long)bosUserDy.getPkValue(), bosUserDy);
        }
        for (DynamicObject obj : personArray) {
            Long bosUserId = obj.getLong("user");
            personMap.put(obj.getLong("person"), (DynamicObject)bosUserIdAndDys.get(bosUserId));
        }
        if (personMap.size() != hrPersonId.size()) {
            logger.error("TscHrPersonHelper.GetSysPerByPerId hr\u4eba\u5458\u65e0\u6cd5\u5339\u914d\u7cfb\u7edf\u7528\u6237");
            throw new KDException(new ErrorCode("", msg), new Object[]{msg});
        }
        return personMap;
    }
}

