/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbs.business.domain.commrec.service;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsrbs.common.entity.commrec.CommthemeEntity;
import kd.tsc.tsrbs.common.utils.TSCBaseUtils;

public class CommrecBaseHelper {
    private static final String TENANTID = "tenantid";
    private static final String RECRUSTG = "recrustg";
    private static final String COMMCONID = "commconid";
    private static final String FBASEDATAID = "FBASEDATAID";
    private static final String CONCLUSION = "conclusion";
    private static final String ONLYTHEMEAUT = "onlythemeaut";
    private static final String ISONLYTHEME = "isonlytheme";
    private static final String COMMTHEME = "commtheme";
    private static final String ROBJ = "robj";
    private static final String ISDELETE = "isdelete";
    private static final String COMMSRCOBJ = "commsrc.obj";
    private static final String NOTICE = "notice";
    private static final String SYSNOTICE = "sysnotice";
    private static final String SHOWTYPE = "showType";
    private static final String SYSTEMNOTICE = "systemNotice";

    private CommrecBaseHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static DynamicObject[] getCommthemeByFrcvcontent(long frecrustgtypid) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tsrbd_commtheme");
        QFilter qFilter = new QFilter(TSCBaseUtils.getSelPropDot((String[])new String[]{RECRUSTG, FBASEDATAID}), "in", (Object)frecrustgtypid);
        DynamicObject[] commcon = hrBaseServiceHelper.query(qFilter.toArray());
        return commcon;
    }

    public static boolean getOnlyThemeautBytenantId(String tenantId) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tsrbd_comrepeatable");
        QFilter[] commconFilters = new QFilter[]{new QFilter(TENANTID, "=", (Object)tenantId)};
        DynamicObject comrepeatable = hrBaseServiceHelper.loadDynamicObject(commconFilters);
        if (comrepeatable == null) {
            return false;
        }
        return comrepeatable.getBoolean(ONLYTHEMEAUT);
    }

    public static boolean getOnlyThemeaut(long commthemeId, long appfileId) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tsrbs_commrec");
        QFilter commconFilters = new QFilter(COMMTHEME, "=", (Object)commthemeId);
        QFilter robjFilters = new QFilter(COMMSRCOBJ, "=", (Object)appfileId);
        QFilter isdeleteFilters = new QFilter(ISDELETE, "=", (Object)"0");
        commconFilters.and(robjFilters);
        commconFilters.and(isdeleteFilters);
        DynamicObject[] comrepeatable = hrBaseServiceHelper.loadDynamicObjectArray(commconFilters.toArray());
        return comrepeatable == null || comrepeatable.length == 0;
    }

    public static boolean getOnlythemeautByCommthemeId(long commthemeId) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tsrbd_commtheme");
        QFilter[] commconFilters = new QFilter[]{new QFilter("id", "=", (Object)commthemeId)};
        DynamicObject comrepeatable = hrBaseServiceHelper.loadDynamicObject(commconFilters);
        if (comrepeatable == null) {
            return false;
        }
        return comrepeatable.getBoolean(ISONLYTHEME);
    }

    public static String getConoptentryNameByconoptentryId(long conoptentryId, String conoptenId) {
        HRBaseServiceHelper commconHelper = new HRBaseServiceHelper("tsrbd_commcon");
        QFilter[] commconFilters = new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(conoptenId))};
        DynamicObject commcon = commconHelper.loadDynamicObject(commconFilters);
        if (commcon == null) {
            return null;
        }
        DynamicObjectCollection conoptentrys = commcon.getDynamicObjectCollection("tsrbd_conoptentry");
        if (conoptentrys.isEmpty()) {
            return null;
        }
        for (int index = 0; index < conoptentrys.size(); ++index) {
            if (((DynamicObject)conoptentrys.get(index)).getLong("id") != conoptentryId) continue;
            return ((DynamicObject)conoptentrys.get(index)).get(CONCLUSION).toString();
        }
        return null;
    }

    public static CommthemeEntity getCommconByCommtheme(long fId) {
        CommthemeEntity commthemeEntity = new CommthemeEntity();
        HRBaseServiceHelper commthemeHelper = new HRBaseServiceHelper("tsrbd_commtheme");
        QFilter[] commthemeFilters = new QFilter[]{new QFilter("id", "=", (Object)fId)};
        DynamicObject commtheme = commthemeHelper.loadDynamicObject(commthemeFilters);
        if (commtheme == null || commtheme.getDynamicObject(COMMCONID) == null) {
            return null;
        }
        HRBaseServiceHelper commconHelper = new HRBaseServiceHelper("tsrbd_commcon");
        long commconId = commtheme.getDynamicObject(COMMCONID).getLong("id");
        QFilter[] commconFilters = new QFilter[]{new QFilter("id", "=", (Object)commconId)};
        DynamicObject commcon = commconHelper.loadDynamicObject(commconFilters);
        if (commcon == null) {
            return commthemeEntity;
        }
        String commconName = commcon.getString("name");
        commthemeEntity.setCommconId(commconId);
        commthemeEntity.setCommconName(commconName);
        DynamicObjectCollection conoptentrys = commcon.getDynamicObjectCollection("tsrbd_conoptentry");
        commthemeEntity.setConoptentry((DynamicObject[])conoptentrys.toArray((Object[])new DynamicObject[0]));
        return commthemeEntity;
    }

    public static void sendMessage(String title, String content, List<Long> interviewids, long senderId, String senderName, String url, String tag) {
        MessageInfo message = new MessageInfo();
        message.setType(NOTICE);
        message.setNotifyType(SYSNOTICE);
        message.setTitle(title);
        message.setUserIds(interviewids);
        if (senderId == 0L) {
            message.setSenderId(Long.valueOf(0L));
        } else {
            message.setSenderId(Long.valueOf(senderId));
            message.setSenderName(senderName);
        }
        message.setTag(title);
        message.setContent(content);
        message.setContentUrl(url);
        message.setTag(tag);
        HashMap param = Maps.newHashMapWithExpectedSize((int)4);
        HashMap systemNotice = Maps.newHashMapWithExpectedSize((int)4);
        systemNotice.put(SHOWTYPE, 2);
        param.put(SYSTEMNOTICE, systemNotice);
        message.setParams((Map)param);
        MessageCenterServiceHelper.sendMessage((MessageInfo)message);
    }

    public static void sendMessageNotice(List<Long> receiverId, long senderId, String tag, String content, String url, String senderName) {
        MessageInfo message = new MessageInfo();
        message.setType(NOTICE);
        message.setTitle(tag);
        message.setUserIds(receiverId);
        if (senderId == 0L) {
            message.setSenderId(Long.valueOf(0L));
        } else {
            message.setSenderId(Long.valueOf(senderId));
            message.setSenderName(senderName);
        }
        message.setTag(tag);
        message.setContent(content);
        message.setContentUrl(url);
        MessageCenterServiceHelper.sendMessage((MessageInfo)message);
    }
}

