/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbs.business.domain.commrec.service;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.StringUtils;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.tsc.tsrbs.business.domain.base.BaseHelper;
import kd.tsc.tsrbs.business.domain.commrec.service.CommrecBaseHelper;
import kd.tsc.tsrbs.business.domain.commrec.service.CommrecCheckHelper;
import kd.tsc.tsrbs.business.domain.commrec.service.CommrecDBHelper;
import kd.tsc.tsrbs.business.domain.commrec.service.FollowTaskHelper;
import kd.tsc.tsrbs.common.entity.commrec.CommRecPageParam;
import kd.tsc.tsrbs.common.entity.commrec.CommRecRcvDeleteEntity;
import kd.tsc.tsrbs.common.entity.commrec.CommTopicEntity;
import kd.tsc.tsrbs.common.entity.commrec.CommrcvEntity;
import kd.tsc.tsrbs.common.entity.commrec.CommrcvParam;
import kd.tsc.tsrbs.common.entity.commrec.CommrecEntity;
import kd.tsc.tsrbs.common.entity.commrec.CommrecParam;
import kd.tsc.tsrbs.common.entity.commrec.CommrecResultEntity;
import kd.tsc.tsrbs.common.entity.commrec.FollowTaskHandleDTO;
import kd.tsc.tsrbs.common.entity.commrec.SelectUserEntity;
import kd.tsc.tsrbs.common.entity.commrec.UpdateCommRecDTO;
import org.apache.commons.collections.CollectionUtils;

public class CommrecHelper {
    private static final Log logger = LogFactory.getLog(CommrecHelper.class);
    public static final String DEFAULT_DATE_PATTERN_TIME = "yyyy-MM-dd HH:mm:ss";

    public static String queryUserJson(String userInfoStr) {
        return JSON.toJSONString(CommrecHelper.queryUser(userInfoStr));
    }

    public static List<SelectUserEntity> queryUser(String userInfoStr) {
        DynamicObject[] selectUserDOs = CommrecDBHelper.queryBosUserByQFilter(userInfoStr);
        ArrayList<SelectUserEntity> selectUsers = new ArrayList<SelectUserEntity>(selectUserDOs.length);
        for (int i = 0; i < selectUserDOs.length; ++i) {
            SelectUserEntity selectUser = new SelectUserEntity();
            selectUser.setId(selectUserDOs[i].getString("id"));
            selectUser.setName(selectUserDOs[i].getString("name"));
            selectUser.setNumber(selectUserDOs[i].getString("number"));
            selectUser.setEmail(selectUserDOs[i].getString("email"));
            selectUsers.add(selectUser);
        }
        return selectUsers;
    }

    public static List<SelectUserEntity> queryUserByTopNum(String userInfoStr, int topNnm) {
        DynamicObject[] selectUserDOs = CommrecDBHelper.queryBosUserByQFilter(userInfoStr, topNnm);
        ArrayList<SelectUserEntity> selectUserByTopNums = new ArrayList<SelectUserEntity>(selectUserDOs.length);
        for (int i = 0; i < selectUserDOs.length; ++i) {
            SelectUserEntity selectUser = new SelectUserEntity();
            selectUser.setName(selectUserDOs[i].getString("name"));
            selectUser.setNumber(selectUserDOs[i].getString("number"));
            selectUser.setEmail(selectUserDOs[i].getString("email"));
            selectUserByTopNums.add(selectUser);
        }
        return selectUserByTopNums;
    }

    private static DynamicObject[] getCommrcvDOs(DynamicObject[] commrecDOs) {
        ArrayList<Long> commrecsIds = new ArrayList<Long>(commrecDOs.length);
        for (int i = 0; i < commrecDOs.length; ++i) {
            commrecsIds.add(commrecDOs[i].getLong("id"));
        }
        DynamicObject[] commrcvDOs = CommrecDBHelper.queryCommrcvDOs(commrecsIds);
        return commrcvDOs;
    }

    private static List<Long> getAtUserIds(DynamicObjectCollection atDoc) {
        ArrayList<Long> atUserIds = new ArrayList<Long>(atDoc.size());
        for (int i = 0; i < atDoc.size(); ++i) {
            if (((DynamicObject)atDoc.get(i)).getDynamicObject("rcvmsgper") == null) continue;
            atUserIds.add(((DynamicObject)atDoc.get(i)).getDynamicObject("rcvmsgper").getLong("id"));
        }
        return atUserIds;
    }

    private static List<CommrecEntity> getAboutMeCommRecRcv(List<CommrecEntity> commrecs) {
        ArrayList<CommrecEntity> commrecList = new ArrayList<CommrecEntity>();
        for (int i = 0; i < commrecs.size(); ++i) {
            boolean checkCommrecAboutMe = CommrecCheckHelper.checkCommrecAboutMe(commrecs.get(i));
            boolean checkCommrcvAboutMe = CommrecCheckHelper.checkCommrcvAboutMe(commrecs.get(i).getCommrcvs());
            if (!checkCommrecAboutMe && !checkCommrcvAboutMe) continue;
            commrecList.add(commrecs.get(i));
        }
        return commrecList;
    }

    private static List<CommrecEntity> getCommrecEntityList(DynamicObject[] commrecDOs, DynamicObject[] commrcvDOs) {
        ArrayList<CommrecEntity> commrecList = new ArrayList<CommrecEntity>(commrecDOs.length);
        for (int i = 0; i < commrecDOs.length; ++i) {
            CommrecEntity commrec = new CommrecEntity();
            commrec.setCommrecId(commrecDOs[i].getString("id"));
            DynamicObject creater = commrecDOs[i].getDynamicObject("creator");
            commrec.setCreateUserName(creater.getString("name"));
            commrec.setCreateUserId(creater.getString("id"));
            commrec.setUpdateTimeDate(commrecDOs[i].getDate("updatetime"));
            commrec.setHeadImg(HRImageUrlUtil.getImageFullUrl((String)creater.getString("picturefield")));
            commrec.setVisiblerange(commrecDOs[i].getString("visiblerange"));
            commrec.setCommthemeName(commrecDOs[i].getDynamicObject("commtheme").getString("name"));
            commrec.setCommthemeId(commrecDOs[i].getDynamicObject("commtheme").getString("id"));
            if (commrecDOs[i].getBoolean("isdelete")) {
                String commthemeContent = ResManager.loadKDString((String)"\u5f53\u6c9f\u901a\u8bb0\u5f55\u5df2\u88ab\u5220\u9664", (String)"CommrecHelper_0", (String)"tsc-tsrbs-business", (Object[])new Object[0]);
                commrec.setCommthemeContent(commthemeContent);
            } else {
                commrec.setCommthemeContent(commrecDOs[i].getString("content"));
            }
            String conoptid = commrecDOs[i].getString("conoptid");
            if (StringUtils.isNotEmpty((String)conoptid)) {
                DynamicObject commcom = commrecDOs[i].getDynamicObject("commcon");
                commrec.setCommconName(commcom.getString("name"));
                String commconId = commcom.getString("id");
                String conoptName = CommrecBaseHelper.getConoptentryNameByconoptentryId(Long.parseLong(conoptid), commconId);
                commrec.setConopt(conoptName);
                commrec.setConoptId(conoptid);
            } else {
                commrec.setCommconName(null);
                commrec.setConopt(null);
            }
            commrec.setRecrustg(commrecDOs[i].getString("recrustgname"));
            commrec.setRecrustat(commrecDOs[i].getString("recrustatname"));
            commrec.setCreateTime(commrecDOs[i].getString("createtime"));
            commrec.setUpdateTime(commrecDOs[i].getString("updatetime"));
            commrec.setFromObjType(commrecDOs[i].getString("robjsrc"));
            String positionName = commrecDOs[i].getString("positionname");
            if (StringUtils.isNotEmpty((String)positionName)) {
                commrec.setPositionname(positionName);
                commrec.setPositionnumber(commrecDOs[i].getString("positionnumber"));
            }
            CommrecHelper.getCommrecTopicInfo(commrecDOs[i], commrec);
            boolean isShowFollow = FollowTaskHelper.isFolTaskExistsByCommRecId(commrecDOs[i].getLong("id"));
            if (isShowFollow) {
                commrec.setIsShowFollowBtn(1);
            } else {
                commrec.setIsShowFollowBtn(0);
            }
            commrec.setIsShowDeleteBtn(CommrecCheckHelper.deleteCommrecCheck(creater.getLong("id"), commrecDOs[i].getBoolean("isdelete")));
            DynamicObject commconDO = commrecDOs[i].getDynamicObject("commcon");
            commrec.setIsShowEditConopBtn(CommrecCheckHelper.checkLoginUserIsCreator(commconDO, creater.getLong("id")));
            commrec.setDeleteState(CommrecCheckHelper.checkCommrecDeleteState(commrecDOs[i].getBoolean("isdelete")));
            commrec.setIndex(i);
            commrec.setAtUsers(CommrecHelper.getAtUserIds(commrecDOs[i].getDynamicObjectCollection("rcvmsgperentry")));
            List<CommrcvEntity> commrcvs = CommrecHelper.getCommrcvEntityList(commrecDOs[i].getLong("id"), commrcvDOs);
            commrec.setCommrcvs(commrcvs);
            commrecList.add(commrec);
        }
        Collections.sort(commrecList, new Comparator<CommrecEntity>(){

            @Override
            public int compare(CommrecEntity o1, CommrecEntity o2) {
                return o1.getUpdateTimeDate().compareTo(o2.getUpdateTimeDate());
            }
        });
        return commrecList;
    }

    private static void getCommrecTopicInfo(DynamicObject commrecDOs, CommrecEntity commrec) {
        DynamicObjectCollection toppicDOs = commrecDOs.getDynamicObjectCollection("commtopicentry");
        ArrayList<CommTopicEntity> topicObjs = new ArrayList<CommTopicEntity>(toppicDOs.size());
        for (int index = 0; index < toppicDOs.size(); ++index) {
            CommTopicEntity topic = new CommTopicEntity();
            topic.setId(((DynamicObject)toppicDOs.get(index)).getString("topicid"));
            topic.setValue(((DynamicObject)toppicDOs.get(index)).getString("topicname"));
            topic.setSelectedId(((DynamicObject)toppicDOs.get(index)).getString("topicinfoid"));
            topic.setSelectedValue(((DynamicObject)toppicDOs.get(index)).getString("topicinfo"));
            topic.setType(((DynamicObject)toppicDOs.get(index)).getString("topictype"));
            topicObjs.add(topic);
        }
        commrec.setTopicObj(topicObjs);
    }

    private static List<CommrcvEntity> getCommrcvEntityList(Long commrecId, DynamicObject[] commrcvDOs) {
        ArrayList<CommrcvEntity> commrcvs = new ArrayList<CommrcvEntity>();
        for (int i = 0; i < commrcvDOs.length; ++i) {
            if (commrcvDOs[i].getDynamicObject("commrec").getLong("id") != commrecId.longValue()) continue;
            CommrcvEntity commrcv = new CommrcvEntity();
            commrcv.setCommrcvId(commrcvDOs[i].getString("id"));
            DynamicObject creater = commrcvDOs[i].getDynamicObject("creator");
            commrcv.setCreateUserName(creater.getString("name"));
            commrcv.setCreateUserId(creater.getString("id"));
            commrcv.setCreateTime(commrcvDOs[i].getDate("createtime"));
            commrcv.setHeadImg(HRImageUrlUtil.getImageFullUrl((String)creater.getString("picturefield")));
            commrcv.setRcvcontent(commrcvDOs[i].getString("rcvcontent"));
            commrcv.setRecrustg(commrcvDOs[i].getString("recrustgname"));
            commrcv.setRecrustat(commrcvDOs[i].getString("recrustatname"));
            commrcv.setRcvtime(commrcvDOs[i].getString("rcvtime"));
            commrcv.setIsShowDeleteBtn(CommrecCheckHelper.deleteCommrecCheck(creater.getLong("id"), commrcvDOs[i].getBoolean("isdelete")));
            commrcv.setDeleteState(CommrecCheckHelper.checkCommrecDeleteState(commrcvDOs[i].getBoolean("isdelete")));
            commrcv.setRepliedcreatorId(commrcvDOs[i].getDynamicObject("repliedcreator").getString("id"));
            commrcv.setRepliedcreatorName(commrcvDOs[i].getDynamicObject("repliedcreator").getString("name"));
            commrcv.setIndex(i);
            commrcv.setAtUsers(CommrecHelper.getAtUserIds(commrcvDOs[i].getDynamicObjectCollection("rercvmsgperentry")));
            String positionName = commrcvDOs[i].getString("positionname");
            if (StringUtils.isNotEmpty((String)positionName)) {
                commrcv.setPositionname(positionName);
                commrcv.setPositionnumber(commrcvDOs[i].getString("positionnumber"));
            }
            commrcv.setFromObjType(commrcvDOs[i].getString("robjsrc"));
            commrcvs.add(commrcv);
        }
        Collections.sort(commrcvs, new Comparator<CommrcvEntity>(){

            @Override
            public int compare(CommrcvEntity o1, CommrcvEntity o2) {
                return o1.getCreateTime().compareTo(o2.getCreateTime());
            }
        });
        return commrcvs;
    }

    public static String queryCommrecListInfo(Long appfileId, Long bussinessId, String businessType, boolean isAboutMe, String pageOpenType, Long commrecId) {
        Long queryId = businessType.equals("offer") ? appfileId : bussinessId;
        DynamicObject[] commrecDOs = pageOpenType.equals("msg") ? CommrecDBHelper.queryCommreId(commrecId) : CommrecDBHelper.queryCommrecByBussinessId(queryId);
        DynamicObject[] commrcvDOs = CommrecHelper.getCommrcvDOs(commrecDOs);
        List<CommrecEntity> commrecList = CommrecHelper.getCommrecEntityList(commrecDOs, commrcvDOs);
        if (isAboutMe) {
            commrecList = CommrecHelper.getAboutMeCommRecRcv(commrecList);
        }
        return JSON.toJSONString(commrecList);
    }

    public static CommrecResultEntity saveCommrec(CommrecParam commrecParam, DynamicObject dataEntity, IFormView view) {
        Map params = view.getFormShowParameter().getCustomParams();
        CommRecPageParam commRecPageParam = (CommRecPageParam)JSON.parseObject((String)params.get("paramJson").toString(), CommRecPageParam.class);
        DynamicObject commtheme = (DynamicObject)dataEntity.get("commtheme");
        Long commthemeId = commtheme.getLong("id");
        CommrecResultEntity saveCommrecResult = CommrecCheckHelper.SaveCommrecCheck(commthemeId, commRecPageParam.getBusinessId());
        if (!saveCommrecResult.isCheckState()) {
            saveCommrecResult.setState(false);
            String errorInfo = ResManager.loadKDString((String)"\u8be5\u4e3b\u9898\u5df2\u5b58\u5728\uff0c\u4e0d\u53ef\u65b0\u5efa", (String)"CommrecHelper_1", (String)"tsc-tsrbs-business", (Object[])new Object[0]);
            saveCommrecResult.setErrorInfo(errorInfo);
            return saveCommrecResult;
        }
        dataEntity.set("content", (Object)commrecParam.getContent());
        dataEntity.set("commcon", (Object)commtheme.getDynamicObject("commconid"));
        dataEntity.set("conoptid", (Object)commrecParam.getConclusionSelectedId());
        dataEntity.set("recrutype", (Object)commRecPageParam.getRecruTypeId());
        dataEntity.set("recrustgid", (Object)commRecPageParam.getRecruStgId());
        dataEntity.set("recrustgname", (Object)commRecPageParam.getRecruStgName());
        dataEntity.set("recrustatid", (Object)commRecPageParam.getRecruStatId());
        dataEntity.set("recrustatname", (Object)commRecPageParam.getRecruStatName());
        dataEntity.set("visiblerange", (Object)"A");
        Date date = new Date();
        dataEntity.set("modifytime", (Object)date);
        dataEntity.set("updatetime", (Object)date);
        dataEntity.set("robjsrc", (Object)commRecPageParam.getBusinessType());
        dataEntity.set("robj", (Object)commRecPageParam.getBusinessId());
        dataEntity.set("pageparam", (Object)params.get("paramJson").toString());
        if (commrecParam.getCommerid() != 0L) {
            dataEntity.set("commerid", (Object)commRecPageParam.getCommrecId());
        } else {
            Long loginUserId = UserServiceHelper.getCurrentUserId();
            dataEntity.set("commerid", (Object)loginUserId);
        }
        CommrecHelper.commPositionInfoSetValue(dataEntity, commRecPageParam);
        CommrecHelper.rcvmsgperEntrySetValue(commrecParam, view);
        CommrecHelper.commsrcEntrySetValue(commRecPageParam, view);
        CommrecHelper.commTopicEntrySetValue(commrecParam, view);
        CommrecDBHelper.saveCommrec(dataEntity);
        Long commrecId = Long.parseLong(dataEntity.get("id").toString());
        if (commrecParam.getCreateFollowTask().equals(Boolean.TRUE)) {
            CommrecHelper.createFollowTask(commrecParam.getFollowTaskDto(), commrecId, commRecPageParam);
        }
        CommrecHelper.sendSysMessage(commrecParam.getAtPeopleIds(), commrecParam.getContentText(), commRecPageParam, commrecId);
        view.invokeOperation("refresh");
        saveCommrecResult.setState(true);
        CommrecHelper.commCallBackBussinesApi(commthemeId, commRecPageParam, commrecParam);
        return saveCommrecResult;
    }

    private static void commPositionInfoSetValue(DynamicObject dataEntity, CommRecPageParam commRecPageParam) {
        dataEntity.set("positionid", (Object)commRecPageParam.getPositionId());
        dataEntity.set("positionnumber", (Object)commRecPageParam.getPositionNumber());
        dataEntity.set("positionname", (Object)commRecPageParam.getPositionName());
    }

    private static void rcvmsgperEntrySetValue(CommrecParam commrecParam, IFormView view) {
        if (commrecParam.getAtPeopleIds().size() > 0) {
            DynamicObject[] atPeopleDOs = CommrecDBHelper.queryUser(commrecParam.getAtPeopleIds());
            int[] rowIndexRcvmsgperentry = view.getModel().batchCreateNewEntryRow("rcvmsgperentry", atPeopleDOs.length);
            for (int index = 0; index < rowIndexRcvmsgperentry.length; ++index) {
                view.getModel().setValue("rcvmsgper", (Object)atPeopleDOs[index], index);
                view.getModel().setValue("isaldyread", (Object)1, index);
            }
        }
    }

    private static void commsrcEntrySetValue(CommRecPageParam commRecPageParam, IFormView view) {
        if (commRecPageParam.getBusinessType().equals("offer")) {
            view.getModel().batchCreateNewEntryRow("commsrc", 3);
            view.getModel().setValue("obj", (Object)commRecPageParam.getBusinessId(), 0);
            view.getModel().setValue("objsrc", (Object)commRecPageParam.getBusinessType(), 0);
            view.getModel().setValue("frombusinesstype", (Object)commRecPageParam.getBusinessType(), 0);
            view.getModel().setValue("obj", (Object)commRecPageParam.getAppFileId(), 1);
            view.getModel().setValue("objsrc", (Object)"appfile", 1);
            view.getModel().setValue("frombusinesstype", (Object)commRecPageParam.getBusinessType(), 1);
            view.getModel().setValue("obj", (Object)commRecPageParam.getStdRsmId(), 2);
            view.getModel().setValue("pobjsrc", (Object)"stdrsm", 2);
            view.getModel().setValue("frombusinesstype", (Object)commRecPageParam.getBusinessType(), 2);
        } else if (commRecPageParam.getBusinessType().equals("appfile")) {
            view.getModel().batchCreateNewEntryRow("commsrc", 2);
            view.getModel().setValue("obj", (Object)commRecPageParam.getBusinessId(), 0);
            view.getModel().setValue("objsrc", (Object)commRecPageParam.getBusinessType(), 0);
            view.getModel().setValue("frombusinesstype", (Object)commRecPageParam.getBusinessType(), 0);
            view.getModel().setValue("obj", (Object)commRecPageParam.getStdRsmId(), 1);
            view.getModel().setValue("objsrc", (Object)"stdrsm", 1);
            view.getModel().setValue("frombusinesstype", (Object)commRecPageParam.getBusinessType(), 1);
        } else {
            view.getModel().batchCreateNewEntryRow("commsrc", 1);
            view.getModel().setValue("obj", (Object)commRecPageParam.getBusinessId(), 0);
            view.getModel().setValue("objsrc", (Object)commRecPageParam.getBusinessType(), 0);
            view.getModel().setValue("frombusinesstype", (Object)commRecPageParam.getBusinessType(), 0);
        }
    }

    private static void commTopicEntrySetValue(CommrecParam commrecParam, IFormView view) {
        List topicObj = commrecParam.getTopicObj();
        if (topicObj != null && topicObj.size() > 0) {
            int[] rowIndexTopicEntry = view.getModel().batchCreateNewEntryRow("commtopicentry", topicObj.size());
            for (int index = 0; index < rowIndexTopicEntry.length; ++index) {
                view.getModel().setValue("topicid", (Object)((CommTopicEntity)topicObj.get(index)).getId(), index);
                view.getModel().setValue("topicname", (Object)((CommTopicEntity)topicObj.get(index)).getValue(), index);
                view.getModel().setValue("topictype", (Object)((CommTopicEntity)topicObj.get(index)).getType(), index);
                view.getModel().setValue("topicinfoid", (Object)((CommTopicEntity)topicObj.get(index)).getSelectedId(), index);
                view.getModel().setValue("topicinfo", (Object)((CommTopicEntity)topicObj.get(index)).getSelectedValue(), index);
            }
        }
    }

    private static void commCallBackBussinesApi(Long commthemeId, CommRecPageParam commRecPageParam, CommrecParam commrecParam) {
        try {
            Object result;
            logger.info("CommrecHelper->commCallBackBussinesApi start ");
            List topicObjs = commrecParam.getTopicObj();
            CommTopicEntity jobsSatusTopic = CommrecHelper.getJobsSatusTopic(topicObjs);
            logger.info("CommrecHelper->commCallBackBussinesApi commthemeId:{}", (Object)commthemeId);
            String jobsSatusTopicId = "";
            HashMap<String, String> updateMap = new HashMap<String, String>(1);
            if (jobsSatusTopic != null) {
                jobsSatusTopicId = jobsSatusTopic.getSelectedId();
                updateMap.put("jobstatus", jobsSatusTopicId);
                logger.info("CommrecHelper->commCallBackBussinesApi jobsSatusTopicSelectId:{}", (Object)jobsSatusTopic.getSelectedId());
            }
            if (commRecPageParam.getBusinessType().equals("stdrsm") && commthemeId == 1004L) {
                logger.info("CommrecHelper->commCallBackBussinesApi if all true ");
                result = DispatchServiceHelper.invokeBizService((String)"tsc", (String)"tstpm", (String)"talentPoolServiceApi", (String)"updateComRecordInfo", (Object[])new Object[]{Long.parseLong(commRecPageParam.getBusinessId()), updateMap});
                logger.info("CommrecHelper->commCallBackBussinesApi end result:{}", result);
            }
            if (!commthemeId.equals(1004L) && !jobsSatusTopicId.equals("")) {
                logger.info("CommrecHelper->commCallBackBussinesApi updateMesTrackInfo start");
                HashMap<Long, HashMap<String, String>> updateMapParent = new HashMap<Long, HashMap<String, String>>(1);
                updateMapParent.put(Long.parseLong(commRecPageParam.getBusinessId()), updateMap);
                result = DispatchServiceHelper.invokeBizService((String)"tsc", (String)"tstpm", (String)"talentPoolServiceApi", (String)"updateMesTrackInfo", (Object[])new Object[]{updateMapParent});
                logger.info("CommrecHelper->commCallBackBussinesApi updateMesTrackInfo end result:{}", result);
            }
        }
        catch (NumberFormatException e) {
            logger.info("CommrecHelper->commCallBackBussinesApi NumberFormatException:{}", (Object)e);
        }
    }

    private static CommTopicEntity getJobsSatusTopic(List<CommTopicEntity> topicObjs) {
        CommTopicEntity jobsSatusTopic = null;
        if (topicObjs == null) {
            return null;
        }
        for (int index = 0; index < topicObjs.size(); ++index) {
            if (!topicObjs.get(index).getId().equals("1321072455657202688")) continue;
            jobsSatusTopic = topicObjs.get(index);
        }
        return jobsSatusTopic;
    }

    private static void sendSysMessage(List<Long> atPeoples, String content, CommRecPageParam commRecPageParam, Long commrecId) {
        if (RequestContext.get().getUserName().length() > 100) {
            return;
        }
        String url = UrlService.getDomainContextUrl() + "/?formId=" + commRecPageParam.getSysMessagePageId() + "&list_formId=bos_list&isOnlyView=1&pageOpenType=msg&commrecId=" + commrecId + "&id=" + commRecPageParam.getBusinessId() + commRecPageParam.getBusinessAddUrlInfo();
        String mesInfoStr = ResManager.loadKDString((String)"@\u4e86\u4f60", (String)"CommrecHelper_2", (String)"tsc-tsrbs-business", (Object[])new Object[0]);
        String title = RequestContext.get().getUserName() + mesInfoStr;
        String tag = ResManager.loadKDString((String)"\u6c9f\u901a\u8bb0\u5f55", (String)"CommrecHelper_3", (String)"tsc-tsrbs-business", (Object[])new Object[0]);
        CommrecBaseHelper.sendMessage(title, content, atPeoples, Long.parseLong(RequestContext.get().getUserId()), RequestContext.get().getUserName(), url, tag);
    }

    private static void createFollowTask(FollowTaskHandleDTO dto, Long commrecId, CommRecPageParam param) {
        dto.setCommRecId(commrecId);
        dto.setAppId("tsrbs");
        dto.setBusinessId(Long.valueOf(param.getBusinessId()));
        dto.setAppFileId(param.getAppFileId());
        dto.setAppFileName(param.getAppFileName());
        dto.setPageId(param.getSysMessagePageId());
        dto.setBusinessAddUrlInfo(param.getBusinessAddUrlInfo());
        dto.setBusinessType(param.getBusinessType());
        FollowTaskHelper.followTaskHandle(dto);
    }

    public static CommrecResultEntity saveCommrcv(String jsonStr, IFormView view) {
        CommrcvParam commrcvParam = (CommrcvParam)JSON.parseObject((String)jsonStr, CommrcvParam.class);
        Map params = view.getFormShowParameter().getCustomParams();
        CommRecPageParam commRecPageParam = (CommRecPageParam)JSON.parseObject((String)params.get("paramJson").toString(), CommRecPageParam.class);
        CommrecResultEntity saveCommrcvResult = CommrecCheckHelper.SaveCommrcvCheck(commrcvParam);
        if (!saveCommrcvResult.isCheckState()) {
            return saveCommrcvResult;
        }
        Date date = new Date();
        DynamicObject commrcv = BaseHelper.createDynamicObject("tsrbs_commrcv");
        if (HRObjectUtils.isEmpty((Object)commrcv)) {
            return saveCommrcvResult;
        }
        long commrcvId = ID.genLongId();
        commrcv.set("id", (Object)commrcvId);
        commrcv.set("commrec", (Object)commrcvParam.getCommrecid());
        commrcv.set("rcvcontent", (Object)commrcvParam.getRcvcontent());
        commrcv.set("parentid", (Object)commrcvParam.getParentid());
        commrcv.set("rcvtime", (Object)date);
        commrcv.set("recrutype", (Object)commRecPageParam.getRecruTypeId());
        commrcv.set("recrustatid", (Object)commRecPageParam.getRecruStatId());
        commrcv.set("recrustatname", (Object)commRecPageParam.getRecruStatName());
        commrcv.set("recrustgid", (Object)commRecPageParam.getRecruStgId());
        commrcv.set("recrustgname", (Object)commRecPageParam.getRecruStgName());
        commrcv.set("level", (Object)2);
        commrcv.set("repliedcreator", (Object)CommrecDBHelper.queryUser(commrcvParam.getRepliedcreatorid()));
        commrcv.set("positionid", (Object)commRecPageParam.getPositionId());
        commrcv.set("positionnumber", (Object)commRecPageParam.getPositionNumber());
        commrcv.set("positionname", (Object)commRecPageParam.getPositionName());
        commrcv.set("creator", (Object)RequestContext.get().getUserId());
        commrcv.set("createtime", (Object)date);
        commrcv.set("modifier", (Object)RequestContext.get().getUserId());
        commrcv.set("modifytime", (Object)date);
        commrcv.set("enable", (Object)"1");
        commrcv.set("isdelete", (Object)0);
        commrcv.set("robjsrc", (Object)commRecPageParam.getBusinessType());
        BaseHelper.insert(commrcv, "tsrbs_commrcv");
        commrcvParam.getAtPeoples().add(commrcvParam.getRepliedcreatorid());
        CommrecHelper.saveRercvmsgperentry(commrcvId, commrcvParam);
        DynamicObject commrecDO = CommrecDBHelper.queryOneCommrec(commrcvParam.getCommrecid());
        commrecDO.set("modifytime", (Object)date);
        commrecDO.set("updatetime", (Object)date);
        String pageParam = commrecDO.getString("pageparam");
        CommrecDBHelper.saveCommrec(commrecDO);
        CommRecPageParam commPageParam = (CommRecPageParam)JSON.parseObject((String)pageParam, CommRecPageParam.class);
        CommrecHelper.sendSysMessage(commrcvParam.getAtPeoples(), commrcvParam.getRcvcontentText(), commPageParam, commrcvParam.getCommrecid());
        saveCommrcvResult.setCommrecid(commrcvParam.getCommrecid());
        saveCommrcvResult.setState(true);
        return saveCommrcvResult;
    }

    public static void saveRercvmsgperentry(Long commrcvId, CommrcvParam commrecParam) {
        DynamicObject[] rercvmsgperentrys = new DynamicObject[commrecParam.getAtPeoples().size()];
        for (int i = 0; i < commrecParam.getAtPeoples().size(); ++i) {
            DynamicObject rercvmsgperentry = BaseHelper.createDynamicObject("tsrbs_rercvmsgperentry");
            rercvmsgperentry.set("commrcvid", (Object)commrcvId);
            rercvmsgperentry.set("rcvmsgper", commrecParam.getAtPeoples().get(i));
            rercvmsgperentry.set("isaldyread", (Object)1);
            rercvmsgperentrys[i] = rercvmsgperentry;
        }
        BaseHelper.insert(rercvmsgperentrys, "tsrbs_rercvmsgperentry");
    }

    public static CommrecResultEntity deleteCommRecRcv(CommRecRcvDeleteEntity deleteParam) {
        CommrecResultEntity deleteResult = new CommrecResultEntity();
        DynamicObject commRecRcvDO = deleteParam.getDataType().equals("theme") ? CommrecDBHelper.queryOneCommrec(deleteParam.getId()) : CommrecDBHelper.queryOneCommrcv(deleteParam.getId());
        DynamicObject creater = commRecRcvDO.getDynamicObject("creator");
        int canDeleteOrNot = CommrecCheckHelper.deleteCommrecCheck(creater.getLong("id"), commRecRcvDO.getBoolean("isdelete"));
        if (canDeleteOrNot == 1) {
            commRecRcvDO.set("isdelete", (Object)1);
            commRecRcvDO.set("deletetime", (Object)new Date());
            if (deleteParam.getDataType().equals("theme")) {
                CommrecDBHelper.saveCommrec(commRecRcvDO);
            } else {
                CommrecDBHelper.saveCommrcv(commRecRcvDO);
            }
            deleteResult.setState(true);
        } else {
            deleteResult.setState(false);
            deleteResult.setErrorInfo("\u6570\u636e\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u5237\u65b0\u9875\u9762");
        }
        return deleteResult;
    }

    public static CommrecResultEntity updateCommcon(Map<String, String> updateParam) {
        String commrecId = updateParam.get("commrecId");
        CommRecRcvDeleteEntity checkDeleteParam = new CommRecRcvDeleteEntity();
        checkDeleteParam.setId(Long.valueOf(Long.parseLong(commrecId)));
        checkDeleteParam.setDataType("theme");
        CommrecResultEntity result = CommrecCheckHelper.checkDelete(checkDeleteParam);
        if (!result.isCheckState()) {
            return result;
        }
        String conoptentryId = updateParam.get("conoptentryId");
        DynamicObject commrecDO = CommrecDBHelper.queryOneCommrec(Long.parseLong(commrecId));
        commrecDO.set("conoptid", (Object)conoptentryId);
        CommrecDBHelper.saveCommrec(commrecDO);
        result.setState(true);
        return result;
    }

    public static void updateCommsrcentry(DynamicObject mergeFrom, DynamicObject mergeTo) {
        Long mergeFromId = mergeFrom.getLong("id");
        Long mergeToId = mergeTo.getLong("id");
        DynamicObject[] mergeFromCommsrcEntryDOs = CommrecDBHelper.queryCommsrcEntry(mergeFromId);
        ArrayList commsrcNews = Lists.newArrayListWithExpectedSize((int)mergeFromCommsrcEntryDOs.length);
        long[] commsrcNewEntryId = ID.genLongIds((int)mergeFromCommsrcEntryDOs.length);
        for (int index = 0; index < mergeFromCommsrcEntryDOs.length; ++index) {
            DynamicObject commsrcNew = CommrecDBHelper.generateEmptyCommsrcDynamicObject();
            commsrcNew.set("id", (Object)mergeFromCommsrcEntryDOs[index].getLong("id"));
            commsrcNew.set("entryid", (Object)commsrcNewEntryId[index]);
            commsrcNew.set("obj", (Object)mergeToId);
            commsrcNew.set("objsrc", (Object)"stdrsm");
            commsrcNew.set("frombusinesstype", (Object)"stdrsmmerge");
            commsrcNew.set("pobject", (Object)mergeFromId);
            commsrcNew.set("pobjsrc", (Object)"stdrsm");
            commsrcNews.add(commsrcNew);
        }
        CommrecDBHelper.saveCommsrcs(commsrcNews);
    }

    public static DynamicObject selectByBusinessId(Long businessId) {
        if (Objects.isNull(businessId)) {
            return null;
        }
        QFilter qFilter = new QFilter("robj", "=", (Object)businessId);
        List<DynamicObject> commRecList = BaseHelper.selectByFilter(qFilter.toArray(), "tsrbs_commrec");
        if (CollectionUtils.isEmpty(commRecList)) {
            return null;
        }
        return commRecList.stream().max(Comparator.comparing(commRec -> commRec.getDate("createtime"))).orElse(null);
    }

    public static CommrecResultEntity updateCommRec(UpdateCommRecDTO dto) {
        if (Objects.isNull(dto)) {
            logger.warn("Input param is null!");
            return new CommrecResultEntity(false, "Input param is null!");
        }
        if (dto.isInvalid().booleanValue()) {
            logger.warn("Parameter verification failed!");
            return new CommrecResultEntity(false, "Parameter verification failed!");
        }
        DynamicObject commRec = BaseHelper.selectById(dto.getCommRecId(), "tsrbs_commrec");
        if (Objects.isNull(commRec)) {
            logger.warn("Select by commRecId is null! commRecId is -> {}", (Object)dto.getCommRecId());
            return new CommrecResultEntity(false, "Select by commRecId is null!");
        }
        if (UserServiceHelper.getCurrentUserId() != commRec.getDynamicObject("creator").getLong("id")) {
            logger.warn("You can only modify the communication records you created! commRecId is -> {}", (Object)dto.getCommRecId());
            return new CommrecResultEntity(false, "You can only modify the communication records you created!");
        }
        DynamicObject newCommRec = CommrecHelper.setCommRecHandle(commRec, dto);
        try {
            BaseHelper.update(newCommRec, "tsrbs_commrec");
        }
        catch (Exception e) {
            return new CommrecResultEntity(false, "Update commRec error!");
        }
        return new CommrecResultEntity(true);
    }

    private static DynamicObject setCommRecHandle(DynamicObject commRec, UpdateCommRecDTO dto) {
        Optional.ofNullable(dto.getCommCon()).ifPresent(commCon -> commRec.set("conoptid", commCon));
        Optional.ofNullable(dto.getCommContent()).ifPresent(commContent -> commRec.set("content", commContent));
        Date date = new Date();
        commRec.set("modifytime", (Object)date);
        commRec.set("updatetime", (Object)date);
        return commRec;
    }
}

