/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbs.business.domain.commrec.service;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.id.ID;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.url.UrlService;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.tsc.tsrbs.business.domain.base.BaseHelper;
import kd.tsc.tsrbs.business.domain.commrec.service.CommrecBaseHelper;
import kd.tsc.tsrbs.business.domain.commrec.service.ScheduleHelper;
import kd.tsc.tsrbs.common.entity.commrec.FollowTaskHandleDTO;
import kd.tsc.tsrbs.common.entity.schedule.PublishScheduleDTO;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class FollowTaskHelper {
    private static final String FOLPERENTRY_FOLPER = "folperentry.folper";
    private static final String TX_TAG = "follow_task_handle";
    private static final String SCHEDULE_JOB_SUFFIX = "_followTask_SKDJ_S";
    private static final String SCHEDULE_PLAN_SUFFIX = "_followTask_SKDP_S";
    private static final String SCHEDULE_CLASS = "kd.tsc.tsrbs.formplugin.web.commrec.schedule.FollowTaskSchedule";
    private static final Integer ZERO = 0;
    private static final Integer HASHMAP_SIZE = 16;
    private static final String STDRSM = "stdrsm";
    private static final String TSTPM_STDRSM = "tstpm_stdrsm";
    private static final String STDRSM_STATUS = "datastatus";
    private static final String STDRSM_STATUS_DELETE = "-2";

    public static Boolean recoverCommRecFollowTaskByBusinessIdList(List<Pair<Long, String>> businessPairList) {
        if (CollectionUtils.isEmpty(businessPairList)) {
            return Boolean.FALSE;
        }
        List<Long> businessIdList = FollowTaskHelper.getBusinessIdListHandle(businessPairList);
        if (CollectionUtils.isEmpty(businessIdList)) {
            return Boolean.FALSE;
        }
        List<DynamicObject> commRecList = FollowTaskHelper.getCommRecListByBusinessIdListHandle(businessIdList);
        List<DynamicObject> followTaskList = FollowTaskHelper.getFollowTaskListByBusinessIdListHandle(businessIdList);
        if (CollectionUtils.isEmpty(commRecList) && CollectionUtils.isEmpty(followTaskList)) {
            return Boolean.FALSE;
        }
        FollowTaskHelper.updateCommRecAndFollowTaskHandle(commRecList, followTaskList, businessPairList);
        return Boolean.TRUE;
    }

    public static Boolean deleteCommRecFollowTaskByBusinessIdList(List<Long> businessIdList) {
        if (CollectionUtils.isEmpty(businessIdList)) {
            return Boolean.FALSE;
        }
        List<DynamicObject> commRecList = FollowTaskHelper.getCommRecListByBusinessIdListHandle(businessIdList);
        List<DynamicObject> followTaskList = FollowTaskHelper.getFollowTaskListByBusinessIdListHandle(businessIdList);
        if (CollectionUtils.isEmpty(commRecList) && CollectionUtils.isEmpty(followTaskList)) {
            return Boolean.FALSE;
        }
        FollowTaskHelper.updateCommRecAndFollowTaskHandle(commRecList, followTaskList);
        return Boolean.TRUE;
    }

    private static List<Long> getBusinessIdListHandle(List<Pair<Long, String>> businessPairList) {
        return businessPairList.stream().map(Pair::getLeft).collect(Collectors.toList());
    }

    private static void updateCommRecAndFollowTaskHandle(List<DynamicObject> commRecList, List<DynamicObject> followTaskList, List<Pair<Long, String>> businessPairList) {
        if (CollectionUtils.isNotEmpty(commRecList)) {
            DynamicObject[] commRecs = (DynamicObject[])commRecList.stream().peek(commRec -> commRec.set("isdelete", (Object)Boolean.FALSE)).toArray(DynamicObject[]::new);
            BaseHelper.update(commRecs, "tsrbs_commrec");
        }
        if (CollectionUtils.isNotEmpty(followTaskList)) {
            DynamicObject[] followTasks = (DynamicObject[])followTaskList.stream().peek(followTask -> followTask.set("isdelete", (Object)Boolean.FALSE)).toArray(DynamicObject[]::new);
            BaseHelper.update(followTasks, "tsrbs_followtask");
        }
    }

    private static void updateCommRecAndFollowTaskHandle(List<DynamicObject> commRecList, List<DynamicObject> followTaskList) {
        if (CollectionUtils.isNotEmpty(commRecList)) {
            BaseHelper.update((DynamicObject[])commRecList.stream().peek(commRec -> commRec.set("isdelete", (Object)Boolean.TRUE)).toArray(DynamicObject[]::new), "tsrbs_commrec");
        }
        if (CollectionUtils.isNotEmpty(followTaskList)) {
            BaseHelper.update((DynamicObject[])followTaskList.stream().peek(followTask -> followTask.set("isdelete", (Object)Boolean.TRUE)).toArray(DynamicObject[]::new), "tsrbs_followtask");
        }
    }

    private static FollowTaskHandleDTO publishScheduleDTOHandle(DynamicObject followTask, String appFileName) {
        FollowTaskHandleDTO dto = new FollowTaskHandleDTO();
        dto.setAppId(followTask.getString("robjsrc"));
        dto.setFollowDateTime(followTask.getDate("followtime"));
        dto.setBusinessId(Long.valueOf(followTask.getLong("robjid")));
        dto.setAppFileName(appFileName);
        dto.setPageId("tstpm_candidate_detail");
        return dto;
    }

    private static List<DynamicObject> getFollowTaskListByBusinessIdListHandle(List<Long> businessIdList) {
        QFilter qFilter = new QFilter("robjid", "in", businessIdList);
        return BaseHelper.selectByFilter(qFilter.toArray(), "tsrbs_followtask");
    }

    private static List<DynamicObject> getCommRecListByBusinessIdListHandle(List<Long> businessIdList) {
        QFilter qFilter = new QFilter("robj", "in", businessIdList);
        return BaseHelper.selectByFilter(qFilter.toArray(), "tsrbs_commrec");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean followTaskHandle(FollowTaskHandleDTO dto) {
        long followTaskId;
        if (dto.isInvalid().booleanValue()) {
            return Boolean.FALSE;
        }
        TXHandle txHandle = null;
        Pair<String, String> schedulePair = null;
        try {
            txHandle = TX.required((String)TX_TAG);
            followTaskId = ID.genLongId();
            schedulePair = FollowTaskHelper.scheduleHandle(dto, followTaskId);
            FollowTaskHelper.insertFollowTaskHandle(dto, schedulePair, followTaskId);
            FollowTaskHelper.insertFollowPersonHandle(dto, followTaskId);
        }
        catch (Exception e) {
            Optional.ofNullable(schedulePair).ifPresent(pair -> ScheduleHelper.deleteSchedule((String)pair.getLeft(), (String)pair.getRight()));
            Optional.ofNullable(txHandle).ifPresent(TXHandle::markRollback);
            Boolean bl = Boolean.FALSE;
            return bl;
        }
        finally {
            Optional.ofNullable(txHandle).ifPresent(TXHandle::close);
        }
        FollowTaskHelper.sendMessageHandle(dto, followTaskId);
        return Boolean.TRUE;
    }

    private static void insertFollowPersonHandle(FollowTaskHandleDTO dto, long followTaskId) {
        List followPersonList = dto.getFollowPersonIdList();
        if (CollectionUtils.isEmpty((Collection)followPersonList)) {
            return;
        }
        DynamicObjectCollection folPerList = new DynamicObjectCollection();
        followPersonList.forEach(followPersonId -> {
            DynamicObject folPerEntry = BaseHelper.createDynamicObject("tsrbs_folperentry");
            if (HRObjectUtils.isEmpty((Object)folPerEntry)) {
                return;
            }
            folPerEntry.set("folper", followPersonId);
            folPerEntry.set("foltaskid", (Object)followTaskId);
            folPerEntry.set("taskstatus", (Object)"A");
            folPerList.add((Object)folPerEntry);
        });
        BaseHelper.insert((DynamicObject[])folPerList.toArray((Object[])new DynamicObject[ZERO.intValue()]), "tsrbs_folperentry");
    }

    private static void insertFollowTaskHandle(FollowTaskHandleDTO dto, Pair<String, String> schedulePair, long followTaskId) {
        Date date = new Date();
        DynamicObject followTask = BaseHelper.createDynamicObject("tsrbs_followtask");
        if (HRObjectUtils.isEmpty((Object)followTask)) {
            return;
        }
        followTask.set("id", (Object)followTaskId);
        followTask.set("creator", (Object)UserServiceHelper.getCurrentUserId());
        followTask.set("modifier", (Object)UserServiceHelper.getCurrentUserId());
        followTask.set("enable", (Object)"1");
        followTask.set("createtime", (Object)date);
        followTask.set("modifytime", (Object)date);
        followTask.set("taskstatus", (Object)"A");
        followTask.set("followtime", (Object)dto.getFollowDateTime());
        followTask.set("noticeway", (Object)dto.getNoticeWays());
        followTask.set("commrec", (Object)dto.getCommRecId());
        followTask.set("skdjobid", schedulePair.getLeft());
        followTask.set("skdplanid", schedulePair.getRight());
        followTask.set("robjid", (Object)dto.getBusinessId());
        followTask.set("robjsrc", (Object)dto.getBusinessType());
        OrmLocaleValue followTaskContent = (OrmLocaleValue)followTask.get("foltaskcontent");
        followTaskContent.setLocaleValue_zh_CN(dto.getFollowTaskContent());
        BaseHelper.insert(followTask, "tsrbs_followtask");
    }

    private static Pair<String, String> scheduleHandle(FollowTaskHandleDTO dto, Long followTaskId) {
        PublishScheduleDTO publishScheduleDTO = new PublishScheduleDTO();
        String jobStr = dto.getAppId().concat(String.valueOf(followTaskId)).concat(SCHEDULE_JOB_SUFFIX);
        String planStr = dto.getAppId().concat(String.valueOf(followTaskId)).concat(SCHEDULE_PLAN_SUFFIX);
        publishScheduleDTO.setAppId(dto.getAppId());
        publishScheduleDTO.setJobName(jobStr);
        publishScheduleDTO.setJobNumber(jobStr);
        publishScheduleDTO.setPlanName(planStr);
        publishScheduleDTO.setPlanNumber(planStr);
        publishScheduleDTO.setExeTime(dto.getFollowDateTime());
        publishScheduleDTO.setScheduleClass(SCHEDULE_CLASS);
        HashMap map = Maps.newHashMapWithExpectedSize((int)HASHMAP_SIZE);
        map.put("followTaskId", followTaskId);
        map.put("businessId", dto.getBusinessId());
        map.put("appFileName", dto.getAppFileName());
        map.put("pageId", dto.getPageId());
        map.put("businessAddUrlInfo", dto.getBusinessAddUrlInfo());
        publishScheduleDTO.setParamMap((Map)map);
        return ScheduleHelper.publishSchedule(publishScheduleDTO);
    }

    public static Pair<String, String> selectScheduleIdPairById(Long followTaskId) {
        if (Objects.isNull(followTaskId)) {
            return null;
        }
        DynamicObject followTask = BaseHelper.selectById(followTaskId, "tsrbs_followtask");
        if (Objects.isNull(followTask)) {
            return null;
        }
        return Pair.of((Object)followTask.getString("skdjobid"), (Object)followTask.getString("skdplanid"));
    }

    public static DynamicObject updateTaskStatusById(Long followTaskId, String taskStatus) {
        if (Objects.isNull(followTaskId) || StringUtils.isEmpty((CharSequence)taskStatus)) {
            return null;
        }
        DynamicObject followTask = BaseHelper.selectById(followTaskId, "tsrbs_followtask");
        if (Objects.isNull(followTask)) {
            return null;
        }
        return FollowTaskHelper.updateFollowTaskStatus(followTask, taskStatus);
    }

    public static void cancelFollowTask(Long followTaskId, Long creatorId, String pageId, FollowTaskHandleDTO dto) {
        if (Objects.isNull(followTaskId) || Objects.isNull(creatorId)) {
            return;
        }
        DynamicObject followTask = BaseHelper.selectById(followTaskId, "tsrbs_followtask");
        if (Objects.isNull(followTask)) {
            return;
        }
        if (!creatorId.equals(followTask.getDynamicObject("creator").getLong("id"))) {
            return;
        }
        if ("B".equals(followTask.getString("taskstatus"))) {
            return;
        }
        FollowTaskHelper.updateFollowTaskStatus(followTask, "C");
        ScheduleHelper.deleteSchedule(followTask.getString("skdjobid"), followTask.getString("skdplanid"));
        FollowTaskHelper.sendMessageHandle(followTask, pageId, dto);
    }

    private static DynamicObject updateFollowTaskStatus(DynamicObject followTask, String taskStatus) {
        followTask.set("taskstatus", (Object)taskStatus);
        if ("B".equals(taskStatus)) {
            followTask.set("endtime", (Object)followTask.getDate("followtime"));
        }
        if ("C".equals(taskStatus)) {
            followTask.set("endtime", (Object)new Date());
        }
        DynamicObjectCollection folPerList = followTask.getDynamicObjectCollection("folperentry");
        folPerList.forEach(folPer -> FollowTaskHelper.setFolTaskStatus(folPer, taskStatus));
        return (DynamicObject)BaseHelper.update(followTask, "tsrbs_followtask");
    }

    private static void sendMessageHandle(DynamicObject followTask, String pageId, FollowTaskHandleDTO dto) {
        long currentUserId = UserServiceHelper.getCurrentUserId();
        String currentUserName = (String)UserServiceHelper.getUserInfoByID((long)currentUserId).get("name");
        String title = ResManager.loadKDString((String)"\u8ddf\u76ef\u4efb\u52a1\u53d6\u6d88", (String)"FollowTaskHelper_1", (String)"tsc-tsrbs-business", (Object[])new Object[0]);
        String contentConcatStr = ResManager.loadKDString((String)"\u53d6\u6d88\u4e86\u8ddf\u76ef\u4efb\u52a1\uff0c\u67e5\u770b\u4efb\u52a1\u8be6\u60c5", (String)"FollowTaskHelper_2", (String)"tsc-tsrbs-business", (Object[])new Object[0]);
        String tag = ResManager.loadKDString((String)"\u8ddf\u76ef\u4efb\u52a1", (String)"FollowTaskHelper_3", (String)"tsc-tsrbs-business", (Object[])new Object[0]);
        DynamicObjectCollection folPerList = followTask.getDynamicObjectCollection("folperentry");
        List<Long> folPerIdList = folPerList.stream().map(FollowTaskHelper::getFollowPersonIdListHandle).collect(Collectors.toList());
        String url = UrlService.getDomainContextUrl() + "/?formId=" + pageId + "&openTabPage=followTask&isOnlyView=1&pageOpenType=msg&followTaskId=" + followTask.getLong("id") + "&id=" + dto.getBusinessId() + dto.getBusinessAddUrlInfo();
        CommrecBaseHelper.sendMessage(title, currentUserName.concat(contentConcatStr), folPerIdList, currentUserId, currentUserName, url, tag);
    }

    private static void sendMessageHandle(FollowTaskHandleDTO dto, long followTaskId) {
        long currentUserId = UserServiceHelper.getCurrentUserId();
        String currentUserName = (String)UserServiceHelper.getUserInfoByID((long)currentUserId).get("name");
        String followTaskConcatStr = ResManager.loadKDString((String)"\u7ed9\u60a8\u5b89\u6392\u4e86\u8ddf\u76ef", (String)"FollowTaskHelper_0", (String)"tsc-tsrbs-business", (Object[])new Object[0]);
        String tag = ResManager.loadKDString((String)"\u8ddf\u76ef\u4efb\u52a1", (String)"FollowTaskHelper_3", (String)"tsc-tsrbs-business", (Object[])new Object[0]);
        String pageId = dto.getPageId();
        String url = UrlService.getDomainContextUrl() + "/?formId=" + pageId + "&openTabPage=followTask&isOnlyView=1&pageOpenType=msg&followTaskId=" + followTaskId + "&id=" + dto.getBusinessId() + dto.getBusinessAddUrlInfo();
        CommrecBaseHelper.sendMessage(currentUserName.concat(followTaskConcatStr), dto.getFollowTaskContent(), dto.getFollowPersonIdList(), currentUserId, currentUserName, url, tag);
    }

    public static Long getFollowPersonIdListHandle(DynamicObject followPerson) {
        return followPerson.getDynamicObject("folper").getLong("id");
    }

    private static void setFolTaskStatus(DynamicObject folPer, String taskStatus) {
        folPer.set("folpertaskstatus", (Object)taskStatus);
    }

    public static Boolean isFolTaskExistsByCommRecId(Long commRecId) {
        if (Objects.isNull(commRecId)) {
            return Boolean.FALSE;
        }
        QFilter userFilter = new QFilter("creator", "=", (Object)UserServiceHelper.getCurrentUserId()).or(FOLPERENTRY_FOLPER, "=", (Object)UserServiceHelper.getCurrentUserId());
        QFilter qFilter = new QFilter("commrec", "=", (Object)commRecId).and(userFilter);
        return 0 != BaseHelper.count(qFilter.toArray(), "tsrbs_followtask");
    }

    public static List<DynamicObject> selectFollowTaskList(Long commRecId, Long followTaskId, Long businessId) {
        QFilter qFilter = new QFilter("creator", "=", (Object)UserServiceHelper.getCurrentUserId()).or(FOLPERENTRY_FOLPER, "=", (Object)UserServiceHelper.getCurrentUserId());
        qFilter.and("isdelete", "=", (Object)Boolean.FALSE);
        if (Objects.nonNull(businessId)) {
            qFilter.and("robjid", "=", (Object)businessId);
        }
        if (Objects.nonNull(commRecId)) {
            qFilter = qFilter.and("commrec", "=", (Object)commRecId);
        }
        if (Objects.nonNull(followTaskId)) {
            qFilter = qFilter.and("id", "=", (Object)followTaskId);
        }
        return BaseHelper.selectByFilter(qFilter.toArray(), "tsrbs_followtask");
    }

    public static Boolean isRsmDelete(DynamicObject followTask) {
        if (!STDRSM.equals(followTask.getString("robjsrc"))) {
            return Boolean.FALSE;
        }
        DynamicObject stdRsm = BaseHelper.selectById(followTask.getLong("robjid"), TSTPM_STDRSM);
        if (Objects.isNull(stdRsm)) {
            return Boolean.FALSE;
        }
        if (STDRSM_STATUS_DELETE.equals(stdRsm.getString(STDRSM_STATUS))) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

