/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbs.business.domain.commrec.service;

import java.util.Calendar;
import kd.bos.lang.Lang;
import kd.bos.orm.util.StringUtils;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.PlanInfo;
import kd.bos.schedule.api.RepeatModeEnum;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.server.JobDispatcherProxy;
import kd.bos.service.ServiceFactory;
import kd.tsc.tsrbd.common.utils.DateUtils;
import kd.tsc.tsrbs.common.entity.schedule.PublishScheduleDTO;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduleHelper {
    private static final Logger log = LoggerFactory.getLogger(ScheduleHelper.class);
    private static final Integer HUNDRED_YEARS_LATER = 36000;

    public static Pair<String, String> publishSchedule(PublishScheduleDTO dto) {
        log.info("publishSchedule method begin, param is -> {}", (Object)dto);
        if (dto.isInvalid().booleanValue()) {
            log.warn("publishSchedule exists empty param!");
            return null;
        }
        JobDispatcherProxy proxy = new JobDispatcherProxy();
        JobInfo jobInfo = ScheduleHelper.getJobInfo(dto);
        String jobId = proxy.createJob(jobInfo);
        PlanInfo planInfo = ScheduleHelper.getPlanInfo(jobInfo, dto);
        String planId = proxy.createPlan(planInfo);
        return Pair.of((Object)jobId, (Object)planId);
    }

    public static void deleteSchedule(String jobId, String planId) {
        log.info("deleteSchedule method begin, job is -> {}, planId is -> {}", (Object)jobId, (Object)planId);
        if (StringUtils.isEmpty((Object)jobId) || StringUtils.isEmpty((Object)planId)) {
            log.warn("jobId or planId is empty!");
            return;
        }
        ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        scheduleManager.disableJob(jobId);
        scheduleManager.disableSchedule(planId);
        JobDispatcherProxy proxy = new JobDispatcherProxy();
        proxy.deleteJob(jobId);
        proxy.deletePlan(planId);
    }

    private static JobInfo getJobInfo(PublishScheduleDTO dto) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setName(dto.getJobName());
        jobInfo.setNumber(dto.getJobNumber());
        jobInfo.setAppId(dto.getAppId());
        jobInfo.setJobType(JobType.BIZ);
        jobInfo.setStrategy("1");
        jobInfo.setTaskClassname(dto.getScheduleClass());
        jobInfo.setRunConcurrently(true);
        jobInfo.setParams(dto.getParamMap());
        return jobInfo;
    }

    private static PlanInfo getPlanInfo(JobInfo jobInfo, PublishScheduleDTO dto) {
        PlanInfo planInfo = new PlanInfo();
        planInfo.setJobId(jobInfo.getId());
        planInfo.setName(dto.getPlanName());
        planInfo.setNumber(dto.getPlanNumber());
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.setTime(dto.getExeTime());
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(DateUtils.afterNowDateTime((int)HUNDRED_YEARS_LATER));
        planInfo.setStartTime(startCalendar);
        planInfo.setEndTime(endCalendar);
        planInfo.setRepeatMode(RepeatModeEnum.NONE);
        return planInfo;
    }
}

