/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbs.business.domain.export.service;

import java.io.File;
import java.io.IOException;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tsc.tsrbs.business.domain.export.enums.FontFileEnum;
import org.apache.commons.io.FilenameUtils;

public class TscFontPath {
    private static final Log log = LogFactory.getLog(TscFontPath.class);
    private static JarEntry jarEntry = null;
    private static JarFile jarFile = null;
    private String resourceFile;

    private TscFontPath(String fontName) {
        this.resourceFile = this.getResource(fontName);
    }

    private String getResource(String fontName) {
        String resourcesCatalog = TscFontPath.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        String clientType = System.getenv("ViewClient_Type");
        log.info("\u3010TscFontPath\u3011font resourcesCatalog \"{}\" for evn \"{}", (Object)resourcesCatalog, (Object)clientType);
        fontName = FilenameUtils.getName((String)fontName);
        if ("Windows".equals(clientType)) {
            String fontResources = "";
            fontResources = !resourcesCatalog.contains("out") ? resourcesCatalog.substring(0, resourcesCatalog.indexOf("build")) + "build/resources/main/resources/fonts" : resourcesCatalog.substring(0, resourcesCatalog.indexOf("out")) + "build/resources/main/resources/fonts";
            return fontResources + "/" + fontName;
        }
        File file = new File(resourcesCatalog, "");
        try {
            jarFile = new JarFile(file);
            jarEntry = jarFile.getJarEntry("resources/fonts/" + fontName);
            return this.generatorFontPath(fontName);
        }
        catch (IOException e) {
            log.error("\u3010TscFontPath\u3011get font url error : ", (Throwable)e);
            return null;
        }
    }

    /*
     * Exception decompiling
     */
    private String generatorFontPath(String fontName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String getFontPath(String fontName) {
        if (FontFileEnum.getFontFileEnum(fontName) == null) {
            throw new KDBizException("fontFile not exits");
        }
        return new TscFontPath((String)fontName).resourceFile;
    }
}

