/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbs.business.domain.foreignadminorg;

import java.util.Collections;
import java.util.Date;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.org.service.OrgService;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.business.application.external.org.BizOrgUnitService;

public class ForeignAdminOrgHelper {
    public static boolean createForeignAdminOrgRoot() {
        OrgService orgService = new OrgService();
        long rootOrgId = orgService.getRootOrgId();
        Map result = (Map)HRMServiceHelper.invokeHRMPService((String)"haos", (String)"IHAOSBatchAdminOrgInfoQueryService", (String)"adminOrgInfoQuery", (Object[])new Object[]{Collections.singletonList(rootOrgId), new Date()});
        if (result == null || result.isEmpty()) {
            return false;
        }
        Map rootOrgInfo = (Map)result.get(String.valueOf(rootOrgId));
        if (rootOrgInfo == null || rootOrgInfo.isEmpty()) {
            return false;
        }
        String name = (String)rootOrgInfo.get("name");
        LocaleString localeName = new LocaleString(name);
        DynamicObject foreignAdminOrg = BusinessDataServiceHelper.newDynamicObject((String)"tsrbs_foreignadminorg");
        long id = BizOrgUnitService.getRootOrgId();
        foreignAdminOrg.set("id", (Object)id);
        foreignAdminOrg.set("name", (Object)localeName);
        String number = CodeRuleServiceHelper.getNumber((String)"tsrbs_foreignadminorg", (DynamicObject)foreignAdminOrg, null);
        foreignAdminOrg.set("number", (Object)number);
        foreignAdminOrg.set("status", (Object)"C");
        foreignAdminOrg.set("enable", (Object)"1");
        foreignAdminOrg.set("masterid", (Object)id);
        foreignAdminOrg.set("longnumber", (Object)number);
        foreignAdminOrg.set("level", (Object)1);
        foreignAdminOrg.set("fullname", (Object)localeName);
        foreignAdminOrg.set("creator", (Object)RequestContext.get().getCurrUserId());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{foreignAdminOrg});
        ForeignAdminOrgHelper.copyRootToSynedAdminOrg(foreignAdminOrg);
        return true;
    }

    private static void copyRootToSynedAdminOrg(DynamicObject root) {
        DynamicObject synAdminOrg = BusinessDataServiceHelper.newDynamicObject((String)"tsrbs_synadminorg");
        HRDynamicObjectUtils.copy((DynamicObject)root, (DynamicObject)synAdminOrg);
        synAdminOrg.set("id", (Object)BizOrgUnitService.getRootOrgId());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{synAdminOrg});
    }

    public static boolean isExistRootAdminOrg() {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("tsrbs_foreignadminorg");
        QFilter parentFilter = new QFilter("parent", "=", (Object)0L);
        return helper.isExists(parentFilter);
    }

    public static FormShowParameter getAdminOrgHeadInfoParam(Long adminOrgId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tsrbs_adminorghead");
        showParameter.getOpenStyle().setTargetKey("headinfopanel");
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.setCustomParam("id", (Object)adminOrgId);
        showParameter.setStatus(OperationStatus.VIEW);
        return showParameter;
    }

    public static Long getDefaultForeignAdminOrgByNumber(String number) {
        QFilter qFilter = new QFilter("number", "=", (Object)number);
        qFilter.and(new QFilter("entryentity.isdefaultadminorg", "=", (Object)"1"));
        DynamicObject dynamicObject = ForeignAdminOrgHelper.getAdminOrgHelper().loadDynamicObject(qFilter.toArray());
        if (dynamicObject == null) {
            return 0L;
        }
        DynamicObjectCollection orgObjs = dynamicObject.getDynamicObjectCollection("entryentity");
        for (DynamicObject orgObj : orgObjs) {
            if (!"1".equals(orgObj.getString("isdefaultadminorg"))) continue;
            return orgObj.getLong("realadminorg.id");
        }
        return 0L;
    }

    public static HRBaseServiceHelper getAdminOrgHelper() {
        return new HRBaseServiceHelper("tsrbs_foreignadminorg");
    }

    public static int getLevelByLongNumber(String longNumber) {
        if (HRStringUtils.isEmpty((String)longNumber)) {
            return 0;
        }
        String[] levelArrays = longNumber.split("\\.");
        return levelArrays.length;
    }

    public static void editLowerDate(BeginOperationTransactionArgs args) {
        DynamicObject[] dataEntities = args.getDataEntities();
        QFilter filter = new QFilter("id", "=", (Object)dataEntities[0].getLong("id"));
        DynamicObject OldDy = ForeignAdminOrgHelper.getAdminOrgHelper().queryOne("level", new QFilter[]{filter});
        if (OldDy != null) {
            int currentLevel = dataEntities[0].getInt("level");
            int oldLevel = OldDy.getInt("level");
            if (oldLevel != currentLevel) {
                DynamicObject[] query;
                QFilter qFilter = new QFilter("longnumber", "like", (Object)("%" + dataEntities[0].getString("number") + "%"));
                for (DynamicObject dynamicObject : query = ForeignAdminOrgHelper.getAdminOrgHelper().query("level", new QFilter[]{qFilter})) {
                    dynamicObject.set("level", (Object)(dynamicObject.getInt("level") + currentLevel - oldLevel));
                }
                if (query.length > 1) {
                    ForeignAdminOrgHelper.getAdminOrgHelper().update(query);
                }
            }
        }
    }

    public static DynamicObject[] getChildrenOrgList(String longNumber) {
        QFilter qFilter = new QFilter("longnumber", "like", (Object)(longNumber + "%"));
        return ForeignAdminOrgHelper.getAdminOrgHelper().loadDynamicObjectArray(qFilter.toArray());
    }
}

