/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbs.business.domain.foreignadminorg.datasync.department;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.tsc.tsrbs.business.domain.foreignadminorg.ForeignBindExternalOrgHelper;
import kd.tsc.tsrbs.business.domain.foreignadminorg.datasync.department.DepartmentSyncServiceFactory;
import kd.tsc.tsrbs.business.domain.foreignadminorg.datasync.department.IDepartmentSyncService;
import kd.tsc.tsrbs.business.domain.synrecord.SynRecordService;
import kd.tsc.tsrbs.common.enums.foreignadminorg.ForeignOrgSynStatusEnum;
import kd.tsc.tsrbs.common.enums.foreignadminorg.ForeignSynStatusEnum;

public class DepartmentSyncService {
    private static final ForeignBindExternalOrgHelper bindExternalOrgHelper = ForeignBindExternalOrgHelper.Singleton.INSTANCE.getInstance();

    public static void pushAsyncTask(AbstractFormPlugin formPlugin, long partnerTenantId) {
        DynamicObject bindTenantOb = bindExternalOrgHelper.queryByTenantId(partnerTenantId);
        if (DepartmentSyncService.checkPushStatus(formPlugin, partnerTenantId, bindTenantOb)) {
            return;
        }
        JobInfo jobInfo = DepartmentSyncService.builJobInfo(partnerTenantId, bindTenantOb);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)formPlugin, "departmentSyncCallBack");
        JobFormInfo jobFormInfo = DepartmentSyncService.buildJobFormInfo(jobInfo, closeCallBack);
        JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)formPlugin.getView());
    }

    private static boolean checkPushStatus(AbstractFormPlugin formPlugin, long partnerTenantId, DynamicObject bindTenantOb) {
        if (bindTenantOb == null) {
            formPlugin.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u79df\u6237\uff0c\u8bf7\u786e\u8ba4\u79df\u6237\u662f\u5426\u6b63\u786e\uff1f", (String)"DepartmentSyncService_2", (String)"tsc-tsrbs-bussiness", (Object[])new Object[0]));
            return true;
        }
        String enable = bindTenantOb.getString("enable");
        if (enable.equals("0")) {
            formPlugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u751f\u6001\u4f19\u4f34\u79df\u6237\u5df2\u7981\u7528\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"SynedAdminOrgViewPlugin_7", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]));
            return true;
        }
        String synchstatus = bindTenantOb.getString("synchstatus");
        if (ForeignSynStatusEnum.SYNCHRONIZING.code.equals(synchstatus)) {
            formPlugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u79df\u6237\u5f53\u524d\u6b63\u5728\u8fdb\u884c\u884c\u653f\u7ec4\u7ec7\u540c\u6b65\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"SynedAdminOrgViewPlugin_4", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]));
            return true;
        }
        List<DynamicObject> notSynRecordObjList = SynRecordService.getNotSynRecordObjList(partnerTenantId);
        if (notSynRecordObjList.isEmpty()) {
            formPlugin.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u5f85\u540c\u6b65\u7684\u6570\u636e\uff0c\u5237\u65b0\u9875\u9762\u8bd5\u8bd5\u3002", (String)"DepartmentSyncService_3", (String)"tsc-tsrbs-bussiness", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private static JobInfo builJobInfo(long partnerTenantId, DynamicObject bindTenantOb) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setAppId("tsrsc");
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setName(ResManager.loadKDString((String)"\u540c\u6b65\u81f3\u7b2c\u4e09\u65b9", (String)"DepartmentSyncService_1", (String)"tsc-tsrbs-bussiness", (Object[])new Object[0]));
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname("kd.tsc.tsrbs.business.domain.foreignadminorg.datasync.department.DepartmentSyncTask");
        bindTenantOb.set("synchstatus", (Object)ForeignSynStatusEnum.SYNCHRONIZING.code);
        bindExternalOrgHelper.updateOne(bindTenantOb);
        HashMap<String, Object> paramMap = new HashMap<String, Object>(6);
        paramMap.put("partnerTenantId", partnerTenantId);
        paramMap.put("bindTenantId", bindTenantOb.getPkValue());
        jobInfo.setParams(paramMap);
        return jobInfo;
    }

    private static JobFormInfo buildJobFormInfo(JobInfo jobInfo, CloseCallBack closeCallBack) {
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setCaption(ResManager.loadKDString((String)"\u540c\u6b65\u81f3\u7b2c\u4e09\u65b9", (String)"DepartmentSyncService_1", (String)"tsc-tsrbs-bussiness", (Object[])new Object[0]));
        jobFormInfo.setCloseCallBack(closeCallBack);
        jobFormInfo.setCanBackground(Boolean.TRUE.booleanValue());
        jobFormInfo.setCanStop(Boolean.TRUE.booleanValue());
        jobFormInfo.setClickClassName("kd.tsc.tsrbs.business.domain.foreignadminorg.datasync.department.DepartmentSyncTaskClick");
        return jobFormInfo;
    }

    public static ForeignOrgSynStatusEnum invokeTpData(DynamicObject notSynRecordObj, String partnerType, Set<DynamicObject> synRecordList, String adminEmail) {
        IDepartmentSyncService departmentSyncService = DepartmentSyncServiceFactory.getDepartmentSyncService(partnerType);
        return departmentSyncService.syncData(notSynRecordObj, synRecordList, adminEmail);
    }
}

