/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbs.business.domain.foreignadminorg.datasync.department;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.tsc.tsrbs.business.domain.eip.EipProcessInstanceInfo;
import kd.tsc.tsrbs.business.domain.foreignadminorg.datasync.department.IDepartmentSyncService;
import kd.tsc.tsrbs.business.domain.foreignadminorg.datasync.mk.DepartmentSyncMkService;
import kd.tsc.tsrbs.common.enums.foreignadminorg.ForeignOrgSynStatusEnum;

public class DepartmentSyncServiceFactory
implements IDepartmentSyncService {
    private static final Log LOG = LogFactory.getLog(DepartmentSyncServiceFactory.class);
    private static final String DEFAULT_SERVICE = "DEFAULT";
    static Map<String, IDepartmentSyncService> REGISTER_SERVICE = Maps.newHashMapWithExpectedSize((int)8);

    public static void registerService(String partnerType, IDepartmentSyncService departmentSynService) {
        if (REGISTER_SERVICE.containsKey(partnerType)) {
            REGISTER_SERVICE.replace(partnerType, departmentSynService);
        } else {
            REGISTER_SERVICE.put(partnerType, departmentSynService);
        }
    }

    public static IDepartmentSyncService getDepartmentSyncService(String partnerType) {
        if (StringUtils.isEmpty((String)partnerType)) {
            return REGISTER_SERVICE.get(DEFAULT_SERVICE);
        }
        IDepartmentSyncService departmentSyncService = REGISTER_SERVICE.get(partnerType);
        return departmentSyncService == null ? REGISTER_SERVICE.get(DEFAULT_SERVICE) : departmentSyncService;
    }

    @Override
    public ForeignOrgSynStatusEnum syncData(DynamicObject notSynRecordObj, Set<DynamicObject> synRecordList, String adminEmail) {
        LOG.info("DepartmentSyncServiceFactory.syncData default helper data {}", (Object)notSynRecordObj);
        return null;
    }

    @Override
    public ForeignOrgSynStatusEnum callBack(DynamicObject notSynRecordObj, Set<DynamicObject> synRecordList, EipProcessInstanceInfo processInstanceInfo) {
        return null;
    }

    static {
        REGISTER_SERVICE.put("MK", new DepartmentSyncMkService());
        REGISTER_SERVICE.put(DEFAULT_SERVICE, new DepartmentSyncServiceFactory());
    }
}

