/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbs.business.domain.foreignadminorg.datasync.department;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.MessageHandler;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsrbs.business.domain.foreignadminorg.ForeignBindExternalOrgHelper;
import kd.tsc.tsrbs.business.domain.foreignadminorg.datasync.department.DepartmentSyncService;
import kd.tsc.tsrbs.business.domain.synrecord.SynRecordService;
import kd.tsc.tsrbs.common.enums.foreignadminorg.ForeignOrgSynStatusEnum;
import kd.tsc.tsrbs.common.enums.foreignadminorg.ForeignSynStatusEnum;

public class DepartmentSyncTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(DepartmentSyncTask.class);
    private static final String PARTNER_TENANT_ID = "partnerTenantId";
    private static final String BINDTENANTID = "bindTenantId";
    private static final ForeignBindExternalOrgHelper bindExternalOrgHelper = ForeignBindExternalOrgHelper.Singleton.INSTANCE.getInstance();

    public MessageHandler getMessageHandle() {
        return super.getMessageHandle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext requestContext, Map<String, Object> param) throws KDException {
        this.feedbackProgress(0, ResManager.loadKDString((String)"\u5df2\u7ecf\u8fdb\u5165\u4efb\u52a1\u6267\u884c\u73af\u8282\uff0c\u5f00\u59cb\u6267\u884c\u4efb\u52a1", (String)"DepartmentSyncTask_1", (String)"tsc-tsrbs-bussiness", (Object[])new Object[0]), null);
        Object partnerTenantId = param.get(PARTNER_TENANT_ID);
        Object bindTenantId = param.get(BINDTENANTID);
        if (partnerTenantId == null) {
            LOG.info("partnerTenantId is null");
            return;
        }
        List<DynamicObject> notSynRecordObjList = SynRecordService.getNotSynRecordObjList(Long.parseLong(partnerTenantId.toString()));
        LOG.info("DepartmentSyncTask.execute notSynRecordObjList data {}", notSynRecordObjList);
        DynamicObject partnerTenantObj = new HRBaseServiceHelper("tsrsc_partner_tenant").queryOne(partnerTenantId);
        if (partnerTenantObj == null) {
            LOG.info("DepartmentSyncTask.execute partnerTenantObj is null {}", (Object)partnerTenantObj);
            return;
        }
        int notSynSize = notSynRecordObjList.size();
        LinkedHashSet<DynamicObject> synRecordList = new LinkedHashSet<DynamicObject>(notSynSize);
        String adminEmail = partnerTenantObj.getString("adminemail");
        String tpdatanum = partnerTenantObj.getString("tpdatanum");
        try {
            for (int index = 0; index < notSynSize; ++index) {
                if (this.isStop()) {
                    LOG.info("DepartmentSyncTask.execute task is terminated, taskId : {}", (Object)this.taskId);
                    this.stop();
                    break;
                }
                ForeignOrgSynStatusEnum synStatusEnum = DepartmentSyncService.invokeTpData(notSynRecordObjList.get(index), tpdatanum, synRecordList, adminEmail);
                if (synStatusEnum == ForeignOrgSynStatusEnum.SYN_FAILED) {
                    LOG.info("DepartmentSyncTask.execute task is terminated, taskId : {} notSynRecordObjId : {}", (Object)this.taskId, notSynRecordObjList.get(index).getPkValue());
                    break;
                }
                String feedbackProcessMsg = ResManager.loadKDString((String)"\u5f00\u59cb\u8fdb\u884c\u7b2c  %s / %s \u6b21\u5faa\u73af", (String)"DepartmentSyncTask_2", (String)"tsc-tsrbs-bussiness", (Object[])new Object[0]);
                String desc = String.format(feedbackProcessMsg, index, notSynSize);
                this.feedbackProgress(100 * index / notSynSize, desc, null);
            }
        }
        catch (Exception ex) {
            LOG.error("DepartmentSyncTask.execute error ", (Throwable)ex);
        }
        finally {
            DynamicObject bindTenantOb = bindExternalOrgHelper.queryOne(bindTenantId);
            if (synRecordList.size() > 0) {
                SynRecordService.synCallbackUpdate(partnerTenantObj, new ArrayList<DynamicObject>(synRecordList), bindTenantOb);
            }
            bindTenantOb.set("synchstatus", (Object)ForeignSynStatusEnum.SYN_COMPLETE.code);
            bindExternalOrgHelper.updateOne(bindTenantOb);
        }
        this.callbackCustomdata(notSynSize, synRecordList);
    }

    private void callbackCustomdata(int notSynSize, LinkedHashSet<DynamicObject> synRecordList) {
        List copySynRecordList = synRecordList.stream().filter(synRecordObj -> ForeignOrgSynStatusEnum.SYN_SUCCESS.code.equals(synRecordObj.getString("synstatus"))).collect(Collectors.toList());
        String msg = ResManager.loadKDString((String)"\u603b\u5171%s\u6761\u6570\u636e, %s\u6761\u540c\u6b65\u6210\u529f, %s\u6761\u540c\u6b65\u5931\u8d25, %s\u6761\u672a\u540c\u6b65\u3002", (String)"DepartmentSyncTask_0", (String)"tsc-tsrbs-bussiness", (Object[])new Object[0]);
        HashMap<String, String> result = new HashMap<String, String>(4);
        result.put("data", String.format(Locale.ROOT, msg, notSynSize, copySynRecordList.size(), synRecordList.size() - copySynRecordList.size(), notSynSize - synRecordList.size()));
        this.feedbackCustomdata(result);
    }
}

