/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbs.business.domain.foreignadminorg.datasync.mk;

import com.alibaba.dubbo.common.json.JSON;
import com.alibaba.dubbo.common.json.ParseException;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tsc.tsrbd.common.utils.DateUtils;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.business.domain.eip.EipProcessInstanceInfo;
import kd.tsc.tsrbs.business.domain.foreignadminorg.datasync.department.IDepartmentSyncService;
import kd.tsc.tsrbs.business.domain.foreignadminorg.datasync.mk.DepartmentSyncMkConstance;
import kd.tsc.tsrbs.business.domain.foreignadminorg.datasync.mk.MkResponseCodeEnum;
import kd.tsc.tsrbs.business.domain.foreignadminorg.datasync.mk.OperationType;
import kd.tsc.tsrbs.common.enums.foreignadminorg.ForeignOrgSynStatusEnum;

public class DepartmentSyncMkService
implements IDepartmentSyncService,
DepartmentSyncMkConstance {
    private static final Log LOG = LogFactory.getLog(DepartmentSyncMkService.class);
    private static final String CODE = "code";
    private static final String MSG = "msg";

    @Override
    public ForeignOrgSynStatusEnum syncData(DynamicObject notSynRecordObj, Set<DynamicObject> synStatusList, String adminEmail) {
        ArrayList params = Lists.newArrayListWithExpectedSize((int)8);
        boolean isMatch = this.buildMatchOperationType(notSynRecordObj, adminEmail, params);
        if (isMatch) {
            return this.synExecute("tsrsc_mk_syncDepartment", params, notSynRecordObj, synStatusList);
        }
        return null;
    }

    @Override
    public ForeignOrgSynStatusEnum callBack(DynamicObject notSynRecordObj, Set<DynamicObject> synStatusList, EipProcessInstanceInfo processInstanceInfo) {
        ForeignOrgSynStatusEnum synStatusEnum;
        Map returnData;
        LOG.info("DepartmentSyncMkService.callBack notSynRecordObjId : {} processInstanceInfo : {}", notSynRecordObj.getPkValue(), (Object)processInstanceInfo.toString());
        Map<String, Object> output = processInstanceInfo.getOutput();
        if (output == null) {
            return null;
        }
        try {
            returnData = output.get("returnData") instanceof Map ? (Map)output.get("returnData") : (Map)JSON.parse((String)output.get("returnData").toString(), Map.class);
        }
        catch (ParseException ex) {
            LOG.error("DepartmentSyncMkService.callBack parse error", (Throwable)ex);
            return null;
        }
        if (returnData == null || !(returnData.get(CODE) instanceof Long) && !(returnData.get(CODE) instanceof Integer)) {
            return null;
        }
        notSynRecordObj.set("syndate", (Object)DateUtils.nowDateTime());
        notSynRecordObj.set("synoperator", (Object)TSCRequestContext.getUserId());
        if (MkResponseCodeEnum.SUCCESS.code == Integer.parseInt(returnData.get(CODE).toString()) || MkResponseCodeEnum.DATA_EXIT.code == Integer.parseInt(returnData.get(CODE).toString())) {
            notSynRecordObj.set("synstatus", (Object)ForeignOrgSynStatusEnum.SYN_SUCCESS.code);
            synStatusEnum = ForeignOrgSynStatusEnum.SYN_SUCCESS;
        } else {
            notSynRecordObj.set("synstatus", (Object)ForeignOrgSynStatusEnum.SYN_FAILED.code);
            synStatusEnum = ForeignOrgSynStatusEnum.SYN_FAILED;
        }
        synStatusList.add(notSynRecordObj);
        return synStatusEnum;
    }

    private boolean buildMatchOperationType(DynamicObject notSynRecordObj, String adminEmail, List<Object> params) {
        String opType = notSynRecordObj.getString("optype");
        LOG.info("DepartmentSyncMkService.syncData opType {}", (Object)opType);
        OperationType operationType = OperationType.getOperationType(opType);
        DynamicObject extOrgObj = notSynRecordObj.getDynamicObject("bizobj");
        DynamicObject parentObj = extOrgObj.getDynamicObject("parent");
        if (parentObj == null) {
            return false;
        }
        String level = extOrgObj.getString("level");
        ArrayList departmentsParamList = Lists.newArrayListWithExpectedSize((int)4);
        HashMap departmentMap = Maps.newHashMapWithExpectedSize((int)8);
        if (operationType != null) {
            params.add(operationType.code);
            switch (operationType) {
                case INSERT: 
                case START_USING: 
                case UPDATE: {
                    departmentMap.put("name", notSynRecordObj.getString("adminorgname"));
                    departmentMap.put("departmentCode", extOrgObj.getString("number"));
                    departmentMap.put("parentCode", "2".equals(level) ? "0" : notSynRecordObj.getString("parentnumber"));
                    departmentsParamList.add(departmentMap);
                    params.add(departmentsParamList);
                    params.add(adminEmail);
                    params.add(extOrgObj.getString("enable"));
                    if ("0".equals(extOrgObj.getString("enable"))) {
                        ArrayList deleteDepartmentsParamList = Lists.newArrayListWithExpectedSize((int)4);
                        HashMap deleteDepartmentMap = Maps.newHashMapWithExpectedSize((int)8);
                        deleteDepartmentMap.put("department_code", extOrgObj.getString("number"));
                        deleteDepartmentsParamList.add(deleteDepartmentMap);
                        params.add(deleteDepartmentsParamList);
                    } else {
                        params.add(null);
                    }
                    return true;
                }
                case FORBIDDEN: {
                    departmentMap.put("department_code", extOrgObj.getString("number"));
                    departmentsParamList.add(departmentMap);
                    params.add(departmentsParamList);
                    params.add(adminEmail);
                    params.add(extOrgObj.getString("enable"));
                    params.add(null);
                    return true;
                }
            }
            return false;
        }
        return false;
    }
}

