/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbs.business.domain.oprecord.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbs.business.domain.oprecord.service.helper.OprecordHelper;
import kd.tsc.tsrbs.common.enums.OpDefEnum;

public final class OpRecordBusinessHelper {
    private static final String MODULE = OpRecordBusinessHelper.class.getName();
    private static OprecordHelper oprecordHelper = new OprecordHelper();

    private OpRecordBusinessHelper() {
    }

    public static String getOpTextTpl(OpDefEnum opDefEnum) {
        String code = opDefEnum.getCode();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbs_opdef");
        QFilter qFilter = new QFilter("number", "=", (Object)code);
        DynamicObject opDef = serviceHelper.queryOne("optexttpl", qFilter.toArray());
        String opTextTpl = opDef.getString("optexttpl");
        return opTextTpl;
    }

    public static DynamicObject[] getOpDefAll(String entityType) {
        QFilter qFilter = new QFilter("entitytype", "=", (Object)entityType);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbs_opdef");
        if (HRStringUtils.equals((String)entityType, (String)"tspr_appfile")) {
            qFilter.or(new QFilter("entitytype", "=", (Object)"tso_offerbase"));
            return serviceHelper.query(qFilter.toArray(), "index asc");
        }
        return serviceHelper.query(qFilter.toArray(), "index asc");
    }

    public static List<ComboItem> getOpDefAllComboItem(String entityType) {
        DynamicObject[] opDefAll = OpRecordBusinessHelper.getOpDefAll(entityType);
        ArrayList<ComboItem> data = new ArrayList<ComboItem>(opDefAll.length);
        for (DynamicObject opDef : opDefAll) {
            String name = opDef.getString("name");
            String number = opDef.getString("number");
            if ((HRStringUtils.equals((String)number, (String)OpDefEnum.DELETE_OFFER.getCode()) || HRStringUtils.equals((String)number, (String)OpDefEnum.DELETE_OFFER_APPFORM.getCode())) && HRStringUtils.equals((String)entityType, (String)"tso_offerbase")) continue;
            data.add(new ComboItem(new LocaleString(name), number));
        }
        return data;
    }

    public static DynamicObject[] listOpRecord(String bizObj, String opNumber, Date headDateStart, Date headDateEnd, String searchVal) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbs_oprecord");
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        if (HRStringUtils.isNotEmpty((String)bizObj)) {
            String[] bizObjs = bizObj.split(",");
            qFilters.add(new QFilter("bizobj", "in", (Object)bizObjs));
        }
        if (HRStringUtils.isNotEmpty((String)searchVal)) {
            qFilters.add(new QFilter("oprtext", "like", (Object)("%" + searchVal + "%")));
        }
        if (HRStringUtils.isNotEmpty((String)opNumber)) {
            qFilters.add(new QFilter("opnumber", "=", (Object)opNumber));
        }
        if (!HRObjectUtils.isEmpty((Object)headDateStart)) {
            qFilters.add(new QFilter("optime", ">=", (Object)headDateStart));
        }
        if (!HRObjectUtils.isEmpty((Object)headDateEnd)) {
            qFilters.add(new QFilter("optime", "<", (Object)headDateEnd));
        }
        String selectProps = "optime,oprtext,operatorname,opnumber,bizentry,bizobjname,id,iskeywordupd,clicknumber,custparameters,deleteflag";
        String orderBy = "id desc";
        DynamicObject[] opRecords = serviceHelper.query(selectProps, qFilters.toArray(new QFilter[0]), orderBy);
        return opRecords;
    }

    public static List<Long> showOpRecordList(AbstractFormDataModel model, CardEntry cardEntry, DynamicObject[] opRecords) {
        int length = opRecords.length;
        int[] rowIndex = model.batchCreateNewEntryRow("oprentryentity", length);
        ArrayList<Long> opRecordIdList = new ArrayList<Long>(length);
        for (int i = 0; i < length; ++i) {
            String oprText;
            DynamicObject opRecord = opRecords[i];
            model.setValue("optime", (Object)opRecord.getDate("optime"), rowIndex[i]);
            boolean isUpd = opRecord.getBoolean("iskeywordupd");
            if (isUpd) {
                String suffixText = ResManager.loadKDString((String)"\uff0c\u5e76\u4fee\u6539\u4e86", (String)(MODULE + "_0"), (String)"tsc-tsrbd-bussiness", (Object[])new Object[0]);
                model.setValue("textcontent", (Object)suffixText, rowIndex[i]);
            } else {
                cardEntry.setChildVisible(false, rowIndex[i], new String[]{"updateoptextflex"});
            }
            String clickNumber = opRecord.getString("clicknumber");
            if (!HRStringUtils.isEmpty((String)clickNumber)) {
                model.setValue("clicknumber", (Object)clickNumber, rowIndex[i]);
                model.setValue("unclicknumber", (Object)clickNumber, rowIndex[i]);
                cardEntry.setChildVisible(false, rowIndex[i], new String[]{"unclicknumberflex"});
                if (HRStringUtils.equals((String)opRecord.getString("deleteflag"), (String)"1")) {
                    cardEntry.setChildVisible(false, rowIndex[i], new String[]{"clicknumberflex"});
                    cardEntry.setChildVisible(true, rowIndex[i], new String[]{"unclicknumberflex"});
                }
            } else {
                cardEntry.setChildVisible(false, rowIndex[i], new String[]{"clicknumberflex"});
                cardEntry.setChildVisible(false, rowIndex[i], new String[]{"unclicknumberflex"});
            }
            if ((oprText = opRecord.getString("oprtext")).length() != 0 && oprText.charAt(oprText.length() - 1) == '\u3002') {
                String newOprText = oprText.substring(0, oprText.length() - 1);
                model.setValue("oprtext", (Object)newOprText, rowIndex[i]);
            } else {
                model.setValue("oprtext", (Object)oprText, rowIndex[i]);
            }
            model.setValue("textfield", (Object)"\u3002", rowIndex[i]);
            model.setValue("operatorname", (Object)opRecord.getString("operatorname"), rowIndex[i]);
            opRecordIdList.add(opRecord.getLong("id"));
        }
        return opRecordIdList;
    }

    public static DynamicObjectCollection listOpFcRecord(String opRecordId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbs_oprecord");
        DynamicObject opRecord = serviceHelper.queryOne((Object)Long.parseLong(opRecordId));
        DynamicObjectCollection objFcRecordList = opRecord.getDynamicObjectCollection("entryentity");
        return objFcRecordList;
    }

    public static DynamicObject queryOpRecordById(Long opRecordId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbs_oprecord");
        QFilter qFilter = new QFilter("id", "=", (Object)opRecordId);
        return serviceHelper.loadDynamicObject(qFilter);
    }

    public static DynamicObject[] getOpRecordByClickNumber(String clickNumber) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbs_oprecord");
        QFilter qFilter = new QFilter("clicknumber", "=", (Object)clickNumber);
        return serviceHelper.loadDynamicObjectArray(qFilter.toArray());
    }

    public static boolean isBackGroundOR(Long id) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbs_oprecord");
        QFilter qFilter = new QFilter("id", "=", (Object)id);
        DynamicObject dynamicObject = serviceHelper.loadDynamicObject(qFilter);
        String opNumber = dynamicObject.getString("opnumber");
        return opNumber.equals(OpDefEnum.UPDATE_BGSUR_RESULT.getCode());
    }
}

