/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbs.business.domain.oprecord.service.helper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbs.business.domain.oprecord.service.OpRecordBusinessHelper;
import kd.tsc.tsrbs.common.entity.oprecord.OprecordChangeModel;
import kd.tsc.tsrbs.common.entity.oprecord.OprecordMessageModel;

public class OprecordHelper {
    private static final Log logger = LogFactory.getLog(OprecordHelper.class);
    private final HRBaseServiceHelper bizCountServiceHelper = new HRBaseServiceHelper("tsrbs_oprecord");

    public List<DynamicObject> saveOprecord(List<OprecordMessageModel> list) {
        ArrayList bizCounts = Lists.newArrayListWithExpectedSize((int)16);
        DynamicObject bizCount = null;
        for (OprecordMessageModel opr : list) {
            Map bizMap;
            bizCount = BusinessDataServiceHelper.newDynamicObject((String)"tsrbs_oprecord");
            if (null != opr.getModelId()) {
                bizCount.set("id", (Object)opr.getModelId());
            }
            if (null != (bizMap = opr.getBizMap())) {
                for (Map.Entry entry : bizMap.entrySet()) {
                    DynamicObject biz = BusinessDataServiceHelper.newDynamicObject((String)"tsrbs_oprecord");
                    this.setProperties(biz, opr);
                    biz.set("bizentry", entry.getKey());
                    biz.set("bizobj", entry.getValue());
                    bizCounts.add(biz);
                }
                continue;
            }
            this.setProperties(bizCount, opr);
            bizCounts.add(bizCount);
        }
        DynamicObject[] dynamicObjects = bizCounts.toArray(new DynamicObject[0]);
        this.bizCountServiceHelper.save(dynamicObjects);
        return bizCounts;
    }

    private void setProperties(DynamicObject bizCount, OprecordMessageModel opr) {
        bizCount.set("operator", (Object)opr.getOperator());
        bizCount.set("operatorname", (Object)opr.getOperatorname());
        bizCount.set("operatorrole", (Object)opr.getOperatorrole());
        bizCount.set("bizobjrole", (Object)opr.getBizobjrole());
        bizCount.set("bizobjname", (Object)opr.getBizobjname());
        bizCount.set("bizentry", (Object)opr.getBizentry());
        bizCount.set("bizobj", (Object)opr.getBizobj());
        bizCount.set("opnumber", (Object)opr.getOpnumber());
        String opnumber = opr.getOpnumber();
        if (!HRStringUtils.isEmpty((String)opnumber) && opnumber.startsWith("delete")) {
            String clickNumber = opr.getClicknumber();
            if (!HRStringUtils.isEmpty((String)clickNumber)) {
                DynamicObject[] records = OpRecordBusinessHelper.getOpRecordByClickNumber(clickNumber);
                for (DynamicObject record : records) {
                    record.set("deleteflag", (Object)"1");
                }
                this.bizCountServiceHelper.save(records);
            }
            bizCount.set("deleteflag", (Object)"1");
        }
        bizCount.set("optime", (Object)opr.getOptime());
        if (opr.getOprtext().length() > 500) {
            bizCount.set("oprtext", (Object)(opr.getOprtext().substring(0, 497) + "..."));
        } else if (opr.getOprtext().length() != 0 && opr.getOprtext().charAt(opr.getOprtext().length() - 1) == '\u3002') {
            String newOprText = opr.getOprtext().substring(0, opr.getOprtext().length() - 1);
            bizCount.set("oprtext", (Object)newOprText);
        } else {
            bizCount.set("oprtext", (Object)opr.getOprtext());
        }
        bizCount.set("clicknumber", (Object)opr.getClicknumber());
        bizCount.set("custparameters", (Object)opr.getCustparameters());
        bizCount.set("skipformid", (Object)opr.getSkipFormId());
        bizCount.set("skippkid", (Object)opr.getSkipPKId());
        if (opr.getChangeList() != null && opr.getChangeList().size() > 0) {
            bizCount.set("iskeywordupd", (Object)"1");
            ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(opr.getChangeList().size());
            DynamicObject dynamicObject = null;
            for (OprecordChangeModel porm : opr.getChangeList()) {
                DynamicObjectCollection entryentity = bizCount.getDynamicObjectCollection("entryentity");
                dynamicObject = entryentity.addNew();
                dynamicObject.set("fieldkey", (Object)porm.getFieldkey());
                dynamicObject.set("fieldname", (Object)porm.getFieldname());
                dynamicObject.set("originalvalue", (Object)porm.getOriginalvalue());
                dynamicObject.set("newvalue", (Object)porm.getNewvalue());
                dynamicObjectList.add(dynamicObject);
            }
            bizCount.set("entryentity", dynamicObjectList);
        } else {
            bizCount.set("iskeywordupd", (Object)"0");
        }
    }
}

