/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbs.business.domain.privacy.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.tsc.tsrbs.business.domain.privacy.IPrivacyService;

public class PrivacyService
implements IPrivacyService {
    private static final Log logger = LogFactory.getLog(PrivacyService.class);
    private static final String CODE_200 = "200";
    private static final String RESPONSE_CODE = "responseCode";
    private static final String PAGE = "hrobs_mob_portalhome";

    private PrivacyService() {
    }

    public static PrivacyService getInstance() {
        return Instance.INSTANCE;
    }

    @Override
    public Tuple<Boolean, Object> queryPrivacy() {
        HashMap requestMap = Maps.newHashMapWithExpectedSize((int)16);
        requestMap.put("user", String.valueOf(RequestContext.get().getCurrUserId()));
        requestMap.put("system", Boolean.TRUE);
        HashMap group = Maps.newHashMapWithExpectedSize((int)16);
        HashSet localeSet = Sets.newHashSetWithExpectedSize((int)16);
        localeSet.add(this.getLocaleId());
        group.put(PAGE, localeSet);
        requestMap.put("group", group);
        Map responseMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSPrivacyService", (String)"getPrivacySigningList", (Object[])new Object[]{requestMap});
        logger.info(MessageFormat.format("PrivacyServiceImpl.queryPrivacy,response:{0}", responseMap));
        if (responseMap != null && CODE_200.equals(responseMap.get(RESPONSE_CODE))) {
            List data = (List)responseMap.get("data");
            Map dataMap = CollectionUtils.isEmpty((Collection)data) ? null : (Map)data.get(0);
            return new Tuple((Object)Boolean.TRUE, (Object)dataMap);
        }
        return new Tuple((Object)Boolean.FALSE, responseMap == null ? null : responseMap.get("errMessage"));
    }

    @Override
    public Tuple<Boolean, Object> signPrivacy(Long privacyId) {
        HashMap requestMap = Maps.newHashMapWithExpectedSize((int)16);
        requestMap.put("user", String.valueOf(RequestContext.get().getCurrUserId()));
        requestMap.put("system", Boolean.TRUE);
        requestMap.put("id", privacyId);
        requestMap.put("modifyTime", new Date());
        ArrayList list = Lists.newArrayListWithCapacity((int)16);
        list.add(requestMap);
        Map responseMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSPrivacyService", (String)"signPrivacy", (Object[])new Object[]{list});
        logger.info(MessageFormat.format("PrivacyServiceImpl.signPrivacy,response:{0}", responseMap));
        if (responseMap != null && CODE_200.equals(responseMap.get(RESPONSE_CODE))) {
            List data = (List)responseMap.get("data");
            Map dataMap = CollectionUtils.isEmpty((Collection)data) ? null : (Map)data.get(0);
            return new Tuple((Object)Boolean.TRUE, (Object)dataMap);
        }
        if (responseMap != null) {
            return new Tuple((Object)Boolean.FALSE, responseMap.get("errMessage"));
        }
        return new Tuple((Object)Boolean.FALSE, null);
    }

    public Long getLocaleId() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("inte_language");
        DynamicObject dy = serviceHelper.queryOne("id", new QFilter("number", "=", (Object)RequestContext.get().getLang()));
        return dy == null ? null : Long.valueOf(dy.getLong("id"));
    }

    private static class Instance {
        private static PrivacyService INSTANCE = new PrivacyService();

        private Instance() {
        }
    }
}

