/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbs.business.domain.rpc.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.tsc.tsrbs.business.domain.rpc.IHrRpcService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class HrRpcServiceImpl
implements IHrRpcService {
    private static final Log log = LogFactory.getLog(HrRpcServiceImpl.class);

    @Override
    public Map<String, Object> getHdmRegBill(Long regBillId) {
        return (Map)HRMServiceHelper.invokeHRService((String)"hdm", (String)"IRegBillService", (String)"getRegBillById", (Object[])new Object[]{regBillId});
    }

    @Override
    public Map<String, Object> getHtmQuitBill(Long quitBillId) {
        return (Map)HRMServiceHelper.invokeHRService((String)"htm", (String)"IQuitBillQuery", (String)"queryQuitBillById", (Object[])new Object[]{quitBillId});
    }

    @Override
    public Pair<Long, Long> getEmployeePair(Long recordId) {
        Map<String, Object> resultMap = this.getPersonMap(recordId);
        if (MapUtils.isEmpty(resultMap)) {
            return null;
        }
        log.info("HrRpcServiceImpl.getEmployeePair.resultMap.isSuccess -> {}", resultMap.get("success"));
        if (!((Boolean)resultMap.get("success")).booleanValue()) {
            return null;
        }
        Map dataMap = (Map)resultMap.get("data");
        if (MapUtils.isEmpty((Map)dataMap)) {
            return null;
        }
        List personList = (List)dataMap.get("data");
        if (CollectionUtils.isEmpty((Collection)personList)) {
            return null;
        }
        Map employeeMap = (Map)((Map)personList.get(0)).get("hrpi_employee");
        if (MapUtils.isEmpty((Map)employeeMap)) {
            return null;
        }
        return Pair.of((Object)((Long)dataMap.get("billId")), (Object)((Long)employeeMap.get("boid")));
    }

    @Override
    public Triple<Long, Long, Long> getEmployeeTriple(Long recordId) {
        Map<String, Object> resultMap = this.getPersonMap(recordId);
        if (MapUtils.isEmpty(resultMap)) {
            return null;
        }
        log.info("HrRpcServiceImpl.getEmployeePair.resultMap.isSuccess -> {}", resultMap.get("success"));
        if (!((Boolean)resultMap.get("success")).booleanValue()) {
            return null;
        }
        Map dataMap = (Map)resultMap.get("data");
        if (MapUtils.isEmpty((Map)dataMap)) {
            return null;
        }
        List personList = (List)dataMap.get("data");
        if (CollectionUtils.isEmpty((Collection)personList)) {
            return null;
        }
        Map employeeMap = (Map)((Map)personList.get(0)).get("hrpi_employee");
        if (MapUtils.isEmpty((Map)employeeMap)) {
            return null;
        }
        Map personMap = (Map)((Map)personList.get(0)).get("hrpi_person");
        if (MapUtils.isEmpty((Map)personMap)) {
            return null;
        }
        return Triple.of((Object)((Long)dataMap.get("billId")), (Object)((Long)employeeMap.get("boid")), (Object)((Long)personMap.get("boid")));
    }

    @Override
    public Map<String, Object> getPersonMap(Long recordId) {
        return (Map)HRMServiceHelper.invokeHRService((String)"hpfs", (String)"IHPFSPersonChgService", (String)"getChgInfoByRecordId", (Object[])new Object[]{recordId});
    }

    @Override
    public Map<String, Object> getPrimaryEmpPosOrgRel(Long personId) {
        return (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"getPrimaryEmpposorgrel", (Object[])new Object[]{personId});
    }
}

