/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbs.business.domain.rpc.impl;

import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.tsc.tsrbs.business.domain.rpc.IHrmpRpcService;
import kd.tsc.tsrbs.common.dto.request.hrmp.ConsumeMsgDTO;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class HrmpRpcServiceImpl
implements IHrmpRpcService {
    private static final Log log = LogFactory.getLog(HrmpRpcServiceImpl.class);

    @Override
    public Map<String, Object> getEmployeeMap(Long employeeId) {
        List personList = (List)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hrpi", (String)"IHRPIPersonSyncService", (String)"listInfo", (Object[])new Object[]{"hrpi_employee", employeeId, null, null});
        if (CollectionUtils.isEmpty((Collection)personList)) {
            return new HashMap<String, Object>(16);
        }
        return personList.stream().filter(person -> (Boolean)person.get("iscurrentversion")).findFirst().orElseGet(HashMap::new);
    }

    @Override
    public Map<String, Object> getTrialMap(Long employeeId) {
        List trialList = (List)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hrpi", (String)"IHRPIPersonSyncService", (String)"listInfo", (Object[])new Object[]{"hrpi_trialperiod", null, null, employeeId});
        if (CollectionUtils.isEmpty((Collection)trialList)) {
            return new HashMap<String, Object>(16);
        }
        return trialList.stream().filter(trial -> (Boolean)trial.get("iscurrentversion")).findFirst().orElseGet(HashMap::new);
    }

    @Override
    public DynamicObject getEmployeeLaborRelStatus(Long employeeId) {
        Map laborRelStatusMap = (Map)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hrpi", (String)"IHRPIEmployeeService", (String)"getEmployeeStatus", (Object[])new Object[]{Collections.singletonList(employeeId)});
        if (MapUtils.isEmpty((Map)laborRelStatusMap)) {
            return null;
        }
        return (DynamicObject)laborRelStatusMap.get(employeeId);
    }

    @Override
    public void updateConsumeMsgInfo(ConsumeMsgDTO dto) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("msgCenterId", dto.getMsgCenterId());
        map.put("msgSubNo", dto.getMsgSubNo());
        map.put("businessTypeId", dto.getBusinessTypeId());
        map.put("handleStatus", dto.getHandleStatus());
        map.put("consumeMsg", dto.getConsumeMsg());
        log.info("HrmpRpcServiceImpl.updateConsumeMsgInfo.map -> {}", (Object)JSONObject.toJSONString(map));
        DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSMsgService", (String)"updateConsumeMsgInfo", (Object[])new Object[]{map});
    }
}

