/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbs.business.domain.rsm.common;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;
import kd.tsc.tsrbd.business.domain.perm.PermissionHelper;
import kd.tsc.tsrbd.common.constants.rsm.ResumeConstants;
import kd.tsc.tsrbs.business.domain.rsm.entity.AppResumeBo;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeAnalysisHelper;
import kd.tsc.tsrbs.common.constants.rsm.RsmCommonKDString;
import org.apache.commons.collections.CollectionUtils;

public class RsmCommonService {
    private static final Log LOG = LogFactory.getLog(RsmCommonService.class);
    public static final String KEY_CANDPIC = "candpic";
    public static final String KEY_REG = "reg";
    private static final RsmCommonService rsmCommonService = new RsmCommonService();

    private RsmCommonService() {
    }

    public static RsmCommonService getInstance() {
        return rsmCommonService;
    }

    public void previewOriginalResume(Object appFileId, String originFlex, DynamicObject appRes, String targetKey, IFormView view, boolean isSkipCheckPerm) {
        long appResId = appRes.getLong("id");
        List attachments = AttachmentServiceHelper.getAttachments((String)"tstpm_rsm", (Object)appResId, (String)"attachmentpanelap");
        String originResUrl = null;
        if (CollectionUtils.isNotEmpty((Collection)attachments)) {
            HashMap attachmentsMap = new HashMap(attachments.size());
            attachments.forEach(attachment -> attachmentsMap.put((Long)attachment.get("createdate"), attachment));
            List createdateList = attachmentsMap.keySet().stream().sorted().collect(Collectors.toList());
            Map finalAttachmentMap = (Map)attachmentsMap.get(createdateList.get(createdateList.size() - 1));
            originResUrl = (String)finalAttachmentMap.get("relativeUrl");
        }
        if (HRStringUtils.isNotEmpty(originResUrl)) {
            view.setVisible(Boolean.TRUE, new String[]{originFlex});
            view.setVisible(Boolean.FALSE, new String[]{"nooriginresflex", "noorigiletter"});
            RsmCommonService.previewFile(originResUrl, targetKey, view, "tsrsc_originalresfile", isSkipCheckPerm);
        } else {
            view.setVisible(Boolean.TRUE, new String[]{"nooriginresflex", "noorigiletter"});
            view.setVisible(Boolean.FALSE, new String[]{"originresflex"});
        }
        Tab tabAp = (Tab)view.getControl("tabap");
        tabAp.activeTab("taboriginrsm");
    }

    public static void previewFile(String filePath, String targetKey, IFormView view, String formId, boolean isSkipCheckPerm) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(targetKey);
        showParameter.setSendToClient(true);
        showParameter.setFormId(formId);
        showParameter.setCustomParam("filepath", (Object)filePath);
        if (isSkipCheckPerm) {
            showParameter.setHasRight(true);
            showParameter.setCustomParam("skipCheckPerm", (Object)Boolean.toString(true));
        }
        view.showForm(showParameter);
    }

    public static void initAppResInfo(DynamicObject appRes, IFormView view) {
        if (appRes != null) {
            LOG.info("initAppResInfo.appRes:{}", (Object)appRes);
            boolean vFlag = false;
            Label lblName = (Label)view.getControl("lblname");
            lblName.setText(appRes.getString("fullname"));
            String age = appRes.getString("age");
            vFlag = RsmCommonService.setLabelText(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u5c81", (String)"AppFileHeadHelper_0", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]), age), "labelage", HRStringUtils.isNotEmpty((String)age) && !"0".equals(age), view, false);
            String gender = appRes.getString("gender");
            vFlag = RsmCommonService.setLabelText(RsmCommonService.getGenderDesc(gender), "labelgender", true, view, vFlag);
            int workYearsNum = appRes.getInt("workingyears");
            vFlag = RsmCommonService.setLabelText(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u5de5\u4f5c\u7ecf\u9a8c", (String)"AppFileHeadHelper_1", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]), ResumeAnalysisHelper.getWorkYearShow(workYearsNum)), "labelexp", workYearsNum != 0, view, vFlag);
            DynamicObject school = appRes.getDynamicObject("highesteduschool");
            String schoolName = school == null ? null : school.getString("name");
            vFlag = RsmCommonService.setLabelText(schoolName, "labelsch", true, view, vFlag);
            DynamicObject diploma = appRes.getDynamicObject("highesteducation");
            String diplomaName = diploma == null ? null : diploma.getString("name");
            vFlag = RsmCommonService.setLabelText(diplomaName, "labeledu", true, view, vFlag);
            vFlag = RsmCommonService.setLabelText(appRes.getString("highestspecialty"), "labelmajor", true, view, vFlag);
            String recentCompany = appRes.getString("recentcompany");
            String recentPosition = appRes.getString("recentposition");
            vFlag = RsmCommonService.setLabelText(recentCompany, "labelcmy", true, view, vFlag);
            RsmCommonService.setLabelText(recentPosition, "labelpos", true, view, vFlag);
            RsmCommonService.setPicByAppRes(appRes, view);
        }
    }

    private static void setPicByAppRes(DynamicObject appRes, IFormView view) {
        String photo = appRes.getString("photo");
        if (HRStringUtils.isNotEmpty((String)photo)) {
            Image candPic = (Image)view.getControl(KEY_CANDPIC);
            candPic.setUrl(HRImageUrlUtil.getImageFullUrl((String)photo));
        }
    }

    private static String getGenderDesc(String gender) {
        if (HRStringUtils.isEmpty((String)gender)) {
            return null;
        }
        switch (gender) {
            case "0": {
                return ResManager.loadKDString((String)"\u7537", (String)"AppFileHeadHelper_2", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]);
            }
            case "1": {
                return ResManager.loadKDString((String)"\u5973", (String)"AppFileHeadHelper_3", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]);
            }
        }
        return null;
    }

    private static boolean setLabelText(String content, String key, boolean visible, IFormView view, boolean vFlag) {
        if (visible && HRStringUtils.isNotEmpty((String)content)) {
            view.setVisible(Boolean.TRUE, new String[]{key});
            if (vFlag) {
                view.setVisible(Boolean.TRUE, new String[]{key + KEY_REG});
            } else {
                view.setVisible(Boolean.FALSE, new String[]{key + KEY_REG});
            }
            Label label = (Label)view.getControl(key);
            label.setText(content);
            return true;
        }
        view.setVisible(Boolean.FALSE, new String[]{key, key + KEY_REG});
        return vFlag;
    }

    public static void setDeliveryInfo(DynamicObject deliveryRec, IFormView view) {
        String nothing = RsmCommonKDString.nothing();
        Label lblDeldeliverTime = (Label)view.getControl("lbldeldelivertime");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT+8:00"));
        lblDeldeliverTime.setText(sdf.format(deliveryRec.getDate("applytime")) + " UTC+08:00");
        Label lblResChnl = (Label)view.getControl("lblreschnl");
        DynamicObject recruchnlnm = deliveryRec.getDynamicObject("recruchnlnm");
        if (null == recruchnlnm) {
            lblResChnl.setText(nothing);
        } else {
            lblResChnl.setText(recruchnlnm.getString("name"));
        }
        Label lblAccess = (Label)view.getControl("lblaccess");
        DynamicObject resacqmthd = deliveryRec.getDynamicObject("resacqmthd");
        if (null == resacqmthd) {
            lblAccess.setText(nothing);
        } else {
            lblAccess.setText(resacqmthd.getString("name"));
        }
    }

    public static void updateAppFileDeliveryByAppResume(DynamicObject appFile, AppResumeBo resumeBo) {
        DynamicObject delivery = RsmCommonService.getDelivery(resumeBo);
        appFile.set("deliveryrec", (Object)delivery);
        appFile.set("applytime", delivery.get("applytime"));
        appFile.set("resacqmthd", delivery.get("resacqmthd"));
        appFile.set("recruchnlnm", delivery.get("recruchnlnm"));
    }

    public static void updateAppFileByAppResume(DynamicObject appFile, AppResumeBo resumeBo) {
        DynamicObject rsm = resumeBo.getRsm();
        appFile.set("name", rsm.get("fullname"));
        appFile.set("phone", rsm.get("phone"));
        appFile.set("email", rsm.get("email"));
        appFile.set("jobstatus", rsm.get("jobstatus"));
        appFile.set("highesteduschool", rsm.get("highesteduschool"));
        appFile.set("highesteducation", rsm.get("highesteducation"));
        appFile.set("birthday", rsm.get("birthday"));
        appFile.set("highestspecialty", rsm.get("highestspecialty"));
    }

    public static DynamicObject getDelivery(AppResumeBo resumeBo) {
        DynamicObject delivery = resumeBo.getDelivery();
        if (delivery == null) {
            delivery = RsmCommonService.getDelivery(resumeBo.getRsm());
            resumeBo.setDelivery(delivery);
        }
        return delivery;
    }

    public static DynamicObject getDelivery(DynamicObject rsmDt) {
        long deliveryId = rsmDt.getLong("delivery.id");
        HRBaseServiceHelper deliveryHelper = new HRBaseServiceHelper("tstpm_srrdelivery");
        return deliveryHelper.queryOne((Object)deliveryId);
    }

    public static AppResumeBo getAppResumeBo(Long rsmId) {
        DynamicObject rsmDt = ServiceHelperCache.getHrBaseServiceHelper((String)"tstpm_srrsm").queryOne((Object)rsmId);
        if (rsmDt != null) {
            return new AppResumeBo(rsmDt, RsmCommonService.getDelivery(rsmDt));
        }
        return null;
    }

    public static void loadAllListData(AppResumeBo resumeBo) {
        for (String subpage : ResumeConstants.SUBPAGES) {
            resumeBo.setEntry(subpage, RsmCommonService.getRsmList(resumeBo, subpage));
        }
    }

    public static void loadSRAllListData(AppResumeBo resumeBo) {
        for (String subpage : ResumeConstants.SUBPAGES_SR) {
            resumeBo.setEntry(subpage, RsmCommonService.getRsmList(resumeBo, subpage));
        }
    }

    public static DynamicObjectCollection getRsmList(AppResumeBo resumeBo, String pageNum) {
        DynamicObject rsm = resumeBo.getRsm();
        if (rsm == null || rsm.getLong("id") == 0L || !rsm.getDataEntityState().getFromDatabase()) {
            return new DynamicObjectCollection();
        }
        long rsmId = rsm.getLong("id");
        QFilter qFilter = new QFilter("rsm", "=", (Object)rsmId);
        DynamicObject[] eduExps = ServiceHelperCache.getHrBaseServiceHelper((String)pageNum).loadDynamicObjectArray(pageNum, qFilter.toArray());
        DynamicObjectCollection eduExpList = new DynamicObjectCollection();
        eduExpList.addAll(Arrays.asList(eduExps));
        return eduExpList;
    }

    public static String getOpenAppFileEntityId(Object appFileId) {
        boolean hasAppFileRight = PermissionHelper.hasOpPerm((String)"tssrm_appfile_viewm", (String)"47150e89000000ac", (Object)appFileId);
        String entityId = "tssrm_appfile_viewm";
        if (!hasAppFileRight) {
            hasAppFileRight = PermissionHelper.hasOpPerm((String)"tssrm_appfile_viewc", (String)"47150e89000000ac", (Object)appFileId);
            entityId = "tssrm_appfile_viewc";
        }
        if (!hasAppFileRight) {
            entityId = "";
        }
        return entityId;
    }
}

