/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbs.business.domain.rsm.service;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;
import kd.tsc.tsrbd.common.constants.rsm.ResumeConstants;
import kd.tsc.tsrbs.business.domain.rsm.entity.AppResumeBo;
import kd.tsc.tsrbs.business.domain.rsm.entity.EducationInfo;
import kd.tsc.tsrbs.business.domain.rsm.entity.ExperienceInfo;
import kd.tsc.tsrbs.business.domain.rsm.entity.LanguagesSkills;
import kd.tsc.tsrbs.business.domain.rsm.entity.ProjectInfo;
import kd.tsc.tsrbs.business.domain.rsm.entity.ResumeInfo;
import kd.tsc.tsrbs.business.domain.rsm.entity.Skills;
import kd.tsc.tsrbs.business.domain.rsm.entity.TrainingInfo;
import kd.tsc.tsrbs.business.domain.rsm.service.AnalysisService;
import kd.tsc.tsrbs.business.domain.rsm.service.AnalysisServiceFactory;
import kd.tsc.tsrbs.business.domain.rsm.service.PictureUploadBizServiceHelper;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeAnalysisHelper;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeExpSortHelper;
import kd.tsc.tsrbs.business.domain.rsm.service.SHrAnalysisService;
import kd.tsc.tsrbs.common.exception.TSCBizException;

public class AddResumeBizServiceHelper {
    private static AddResumeBizServiceHelper addResumeBizServiceHelper = new AddResumeBizServiceHelper();
    private PictureUploadBizServiceHelper pictureUploadBizServiceHelper = PictureUploadBizServiceHelper.getInstance();
    private ResumeAnalysisHelper resumeAnalysisHelper = ResumeAnalysisHelper.getInstance();
    private static final Log LOG = LogFactory.getLog(AddResumeBizServiceHelper.class);

    private AddResumeBizServiceHelper() {
    }

    public static AddResumeBizServiceHelper getInstance() {
        return addResumeBizServiceHelper;
    }

    public ResumeInfo getInputStreamByResumeUrl(String url) {
        AnalysisService analysisService = AnalysisServiceFactory.createSHrInstance();
        ResumeInfo resumeInfo = null;
        try {
            resumeInfo = analysisService.analysisRsmByFilePath(url);
        }
        catch (IOException ioException) {
            LOG.error("AddResumeBizServiceHelper.getInputStreamByResumeUrl ERROR :{}", (Object)ioException.getMessage());
        }
        return resumeInfo;
    }

    public DynamicObject generateResumeInfo(ResumeInfo resumeInfo) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tstpm_srrsm");
        DynamicObject rsmDy = hrBaseServiceHelper.generateEmptyDynamicObject();
        Long resumeDtId = ORM.create().genLongId(hrBaseServiceHelper.getEntityName());
        rsmDy.set("id", (Object)resumeDtId);
        ResumeAnalysisHelper.setCreatorAndTime(rsmDy);
        rsmDy.set("fullname", (Object)resumeInfo.getName());
        rsmDy.set("gender", (Object)ResumeAnalysisHelper.getGender(resumeInfo.getGender()));
        this.setRsmBirthdayAndAge(resumeInfo, rsmDy);
        this.setRsmPartwtAndWorkYear(resumeInfo, rsmDy);
        String jobStatus = resumeInfo.getJobStatus();
        if (HRStringUtils.isNotEmpty((String)jobStatus)) {
            rsmDy.set("jobstatus", (Object)ResumeAnalysisHelper.getJobStatus(jobStatus));
        }
        this.setRsmPhone(resumeInfo, rsmDy);
        rsmDy.set("email", (Object)resumeInfo.getEmail());
        this.setRsmPhoto(resumeInfo, rsmDy);
        rsmDy.set("resumestoadd", (Object)resumeInfo.getResumeStoAdd());
        rsmDy.set("nation", (Object)this.resumeAnalysisHelper.getNation(resumeInfo.getNation()));
        rsmDy.set("politicsstatus", (Object)this.resumeAnalysisHelper.getPoliticsStatus(resumeInfo.getPoliticsStatus()));
        if (HRStringUtils.isNotEmpty((String)resumeInfo.getCertificateNumber())) {
            rsmDy.set("certificatenumber", (Object)resumeInfo.getCertificateNumber());
            rsmDy.set("certificatetype", (Object)1010L);
        }
        rsmDy.set("maritalstatus", (Object)ResumeAnalysisHelper.getMarryStatus(resumeInfo.getMaritalStatus()));
        rsmDy.set("procreationstatus", (Object)ResumeAnalysisHelper.getPregnantStatus(resumeInfo.getProcreationStatus()));
        rsmDy.set("rgstprmtrsd", (Object)this.resumeAnalysisHelper.getCityId(resumeInfo.getRgstprmtrsd()));
        rsmDy.set("nativeplace", (Object)this.resumeAnalysisHelper.getCityId(resumeInfo.getNativePlace()));
        rsmDy.set("expccity", (Object)this.resumeAnalysisHelper.getAdminDivision(resumeInfo.getExpccity()));
        rsmDy.set("exptmonsal", (Object)this.resumeAnalysisHelper.analysisMoney(resumeInfo.getExptmonsal()));
        rsmDy.set("expcarrivaldate", (Object)ResumeAnalysisHelper.parseDate(resumeInfo.getExpcarrivalDate()));
        rsmDy.set("curfxdsal", (Object)this.resumeAnalysisHelper.analysisMoney(resumeInfo.getCurfxdsal()));
        rsmDy.set("selfevaluation", (Object)resumeInfo.getSelfEvaluation());
        this.setRsmHobby(resumeInfo, rsmDy);
        if (HRStringUtils.isNotEmpty((String)resumeInfo.getConregId())) {
            rsmDy.set("natreg", (Object)this.resumeAnalysisHelper.convertStringToDt("bd_country", resumeInfo.getConregId(), "id,name"));
        }
        return rsmDy;
    }

    private void setRsmBirthdayAndAge(ResumeInfo resumeInfo, DynamicObject rsmDy) {
        if (HRStringUtils.isNotEmpty((String)resumeInfo.getBirthday())) {
            Date birthdayDate = ResumeAnalysisHelper.parseDate(resumeInfo.getBirthday());
            rsmDy.set("birthday", (Object)birthdayDate);
            int age = ResumeAnalysisHelper.calculateAge(birthdayDate);
            rsmDy.set("age", (Object)age);
        } else if (HRStringUtils.isNotEmpty((String)resumeInfo.getAge())) {
            int age = this.resumeAnalysisHelper.getInteger(resumeInfo.getAge());
            rsmDy.set("age", (Object)age);
            Date propBirthday = ResumeAnalysisHelper.getBirthdayByAge(age);
            rsmDy.set("propbirthday", (Object)propBirthday);
        }
    }

    private void setRsmPartwtAndWorkYear(ResumeInfo resumeInfo, DynamicObject rsmDy) {
        BigDecimal bg;
        if (HRStringUtils.isNotEmpty((String)resumeInfo.getPartWorkTime())) {
            Date partWorkTimeDate = ResumeAnalysisHelper.parseDate(resumeInfo.getPartWorkTime());
            rsmDy.set("partwt", (Object)partWorkTimeDate);
            int totalMonth = ResumeAnalysisHelper.calMonthByStartDate(partWorkTimeDate);
            rsmDy.set("workingyears", (Object)totalMonth);
        } else if (HRStringUtils.isNotEmpty((String)resumeInfo.getExperience()) && (bg = new BigDecimal(resumeInfo.getExperience())).compareTo(BigDecimal.ZERO) > 0) {
            int totalMonth = bg.multiply(new BigDecimal(12)).intValue();
            rsmDy.set("workingyears", (Object)totalMonth);
            Date workTime = ResumeAnalysisHelper.getDateStartByDiffYear(bg.intValue());
            rsmDy.set("partwt", (Object)workTime);
        }
    }

    private void setRsmPhone(ResumeInfo resumeInfo, DynamicObject rsmDy) {
        String phone = resumeInfo.getPhone();
        if (HRStringUtils.isNotEmpty((String)phone)) {
            if (!phone.contains("+")) {
                phone = "+86-" + phone;
            }
            rsmDy.set("phone", (Object)phone);
        }
    }

    private void setRsmHobby(ResumeInfo resumeInfo, DynamicObject rsmDy) {
        DynamicObjectCollection doc = this.resumeAnalysisHelper.getHobby(resumeInfo.getHobby());
        if (doc != null && !doc.isEmpty()) {
            rsmDy.set("hobby", (Object)doc);
        }
    }

    private void setRsmPhoto(ResumeInfo resumeInfo, DynamicObject rsmDy) {
        if (HRStringUtils.isNotEmpty((String)resumeInfo.getPhotoBase64String())) {
            try {
                String picturePath = this.pictureUploadBizServiceHelper.uploadPicture(resumeInfo.getPhotoBase64String(), resumeInfo.getFileName());
                rsmDy.set("photo", (Object)picturePath);
            }
            catch (Exception ex) {
                LOG.error("generateResumeInfo upload picture file error", (Throwable)new TSCBizException((Throwable)ex));
            }
        }
    }

    public List<DynamicObject> generateEducationInfo(DynamicObject rsm, ResumeInfo resumeInfo) {
        ArrayList<EducationInfo> educationInfoList = new ArrayList<EducationInfo>(Arrays.asList(resumeInfo.getEducationInfo()));
        if (educationInfoList.isEmpty()) {
            return Lists.newArrayList();
        }
        List<Object> eduExpDyList = Lists.newArrayListWithCapacity((int)educationInfoList.size());
        HRBaseServiceHelper hrBaseServiceHelper = ServiceHelperCache.getHrBaseServiceHelper((String)"tstpm_srrsmeduexp");
        for (EducationInfo educationInfo : educationInfoList) {
            DynamicObject educationDy = hrBaseServiceHelper.generateEmptyDynamicObject();
            educationDy.set("id", (Object)ID.genLongId());
            educationDy.set("rsm", rsm.get("id"));
            Date startDate = ResumeAnalysisHelper.parseDate(educationInfo.getStartDate());
            educationDy.set("startdate", (Object)startDate);
            Date endingDate = ResumeAnalysisHelper.parseDate(educationInfo.getEndingDate());
            educationDy.set("endingdate", (Object)endingDate);
            this.setEduExpSchool(educationInfo, educationDy);
            this.setEduExpOtherInfo(educationInfo, educationDy);
            educationDy.set("specialtyname", (Object)educationInfo.getSpeciality());
            ResumeAnalysisHelper.setCreatorAndTime(educationDy);
            eduExpDyList.add(educationDy);
        }
        eduExpDyList = ResumeExpSortHelper.sortRsmEduExp((List<DynamicObject>)eduExpDyList);
        ResumeExpSortHelper.setHighestEduInfo((DynamicObject)eduExpDyList.get(0), rsm);
        return eduExpDyList;
    }

    private void setEduExpSchool(EducationInfo educationInfo, DynamicObject educationDy) {
        if (HRStringUtils.isNotEmpty((String)educationInfo.getSchoolNameId())) {
            DynamicObject schoolDy = this.resumeAnalysisHelper.getSchool(educationInfo.getSchoolNameId());
            educationDy.set("schoolname", (Object)schoolDy);
            if (schoolDy != null && schoolDy.getLong("id") == 1386848073895945216L) {
                educationDy.set("othschname", (Object)educationInfo.getSchoolNameId());
            }
        }
    }

    private void setEduExpOtherInfo(EducationInfo educationInfo, DynamicObject educationDy) {
        if (HRStringUtils.isNotEmpty((String)educationInfo.getEducationId())) {
            educationDy.set("education", (Object)this.resumeAnalysisHelper.getEducation(educationInfo.getEducationId()));
        }
        if (HRStringUtils.isNotEmpty((String)educationInfo.getDegreeId())) {
            educationDy.set("degree", null);
        }
        if (HRStringUtils.isNotEmpty((String)educationInfo.getEducationForm())) {
            educationDy.set("educationform", (Object)this.resumeAnalysisHelper.getEducationForm(educationInfo.getEducationForm()));
        }
        if (HRStringUtils.isNotEmpty((String)educationInfo.getIsOverseasExp())) {
            educationDy.set("isoverseasexp", (Object)educationInfo.getIsOverseasExp());
        }
    }

    public List<DynamicObject> generateExperienceInfo(DynamicObject rsm, ResumeInfo resumeInfo) {
        ArrayList<ExperienceInfo> experienceInfoList = new ArrayList<ExperienceInfo>(Arrays.asList(resumeInfo.getExperienceInfo()));
        if (experienceInfoList.isEmpty()) {
            return Lists.newArrayList();
        }
        List<Object> workExpList = Lists.newArrayListWithExpectedSize((int)experienceInfoList.size());
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tstpm_srrsmworkexp");
        for (ExperienceInfo experienceInfo : experienceInfoList) {
            DynamicObject workExpDy = hrBaseServiceHelper.generateEmptyDynamicObject();
            workExpDy.set("id", (Object)ID.genLongId());
            workExpDy.set("rsm", rsm.get("id"));
            Date startDate = ResumeAnalysisHelper.parseDate(experienceInfo.getStartDate());
            workExpDy.set("startdate", (Object)startDate);
            Date endingDate = ResumeAnalysisHelper.parseDate(experienceInfo.getEndingDate());
            workExpDy.set("endingdate", (Object)endingDate);
            workExpDy.set("positionname", (Object)experienceInfo.getPositionName());
            workExpDy.set("companyname", (Object)experienceInfo.getCompanyName());
            if (HRStringUtils.isNotEmpty((String)experienceInfo.getCityId())) {
                workExpDy.set("city", (Object)this.resumeAnalysisHelper.getCityId(experienceInfo.getCityId()));
            }
            workExpDy.set("workresponsibility", (Object)experienceInfo.getWorkrEsponsibility());
            workExpDy.set("workachievement", (Object)experienceInfo.getWorkAchievement());
            if (HRStringUtils.isNotEmpty((String)experienceInfo.getCompanySize())) {
                workExpDy.set("companysize", (Object)this.resumeAnalysisHelper.getInteger(experienceInfo.getCompanySize()));
            }
            if (HRStringUtils.isNotEmpty((String)experienceInfo.getCompanyNature())) {
                workExpDy.set("companynature", (Object)this.resumeAnalysisHelper.getCompanyNature(experienceInfo.getCompanyNature()));
            }
            workExpDy.set("department", (Object)experienceInfo.getDepartment());
            this.setWorkExpOtherInfo(experienceInfo, workExpDy);
            ResumeAnalysisHelper.setCreatorAndTime(workExpDy);
            workExpList.add(workExpDy);
        }
        workExpList = ResumeExpSortHelper.sortRsmWorkExp((List<DynamicObject>)workExpList);
        ResumeExpSortHelper.setRecentWorkInfo((DynamicObject)workExpList.get(0), rsm);
        return workExpList;
    }

    private void setWorkExpOtherInfo(ExperienceInfo experienceInfo, DynamicObject workExpDy) {
        if (HRStringUtils.isNotEmpty((String)experienceInfo.getQuitReason())) {
            workExpDy.set("quitreason", (Object)this.resumeAnalysisHelper.convertStringToDt("tsrbd_leavereason", experienceInfo.getQuitReason(), "id,number,name,index"));
        }
        if (HRStringUtils.isNotEmpty((String)experienceInfo.getAnnualSalary())) {
            workExpDy.set("annualsalary", (Object)this.resumeAnalysisHelper.analysisMoney(experienceInfo.getAnnualSalary()));
        }
        if (HRStringUtils.isNotEmpty((String)experienceInfo.getUnderlingNumber())) {
            workExpDy.set("underlingnumber", (Object)this.resumeAnalysisHelper.getInteger(experienceInfo.getUnderlingNumber()));
        }
        workExpDy.set("reportobject", (Object)experienceInfo.getReportObject());
        if (HRStringUtils.isNotEmpty((String)experienceInfo.getWorkType())) {
            workExpDy.set("jobnature", (Object)this.resumeAnalysisHelper.getWorkType(experienceInfo.getWorkType()));
        }
        if (HRStringUtils.isNotEmpty((String)experienceInfo.getVocation())) {
            workExpDy.set("industrytype", (Object)this.resumeAnalysisHelper.convertStringToDtId("hbss_industrytype", experienceInfo.getVocation()));
        }
    }

    public List<DynamicObject> generateProjectInfo(DynamicObject rsm, ResumeInfo resumeInfo) {
        ArrayList<ProjectInfo> projectInfos = new ArrayList<ProjectInfo>(Arrays.asList(resumeInfo.getProjectExperience()));
        if (projectInfos.isEmpty()) {
            return Lists.newArrayList();
        }
        List<Object> proExpList = Lists.newArrayListWithExpectedSize((int)projectInfos.size());
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tstpm_srrsmprjexp");
        for (ProjectInfo projectInfo : projectInfos) {
            DynamicObject prjExpDy = hrBaseServiceHelper.generateEmptyDynamicObject();
            prjExpDy.set("id", (Object)ID.genLongId());
            prjExpDy.set("rsm", rsm.get("id"));
            if (HRStringUtils.isNotEmpty((String)projectInfo.getStartDate())) {
                Date startDate = ResumeAnalysisHelper.parseDate(projectInfo.getStartDate());
                prjExpDy.set("startdate", (Object)startDate);
            }
            if (HRStringUtils.isNotEmpty((String)projectInfo.getEndingDate())) {
                Date endingDate = ResumeAnalysisHelper.parseDate(projectInfo.getEndingDate());
                prjExpDy.set("endingdate", (Object)endingDate);
            }
            prjExpDy.set("projectname", (Object)projectInfo.getProjectName());
            prjExpDy.set("belongscompany", (Object)projectInfo.getBelongsCompany());
            prjExpDy.set("projectjob", (Object)projectInfo.getProjectJob());
            prjExpDy.set("projectresp", (Object)projectInfo.getProjectResp());
            prjExpDy.set("projectdesc", (Object)projectInfo.getProjectDesc());
            ResumeAnalysisHelper.setCreatorAndTime(prjExpDy);
            proExpList.add(prjExpDy);
        }
        proExpList = ResumeExpSortHelper.sortRsmPrjExp((List<DynamicObject>)proExpList);
        return proExpList;
    }

    public List<DynamicObject> generateLangAbilityInfo(DynamicObject rsm, ResumeInfo resumeInfo) {
        ArrayList<LanguagesSkills> languageInfos = new ArrayList<LanguagesSkills>(Arrays.asList(resumeInfo.getLanguageAbility()));
        if (languageInfos.isEmpty()) {
            return Lists.newArrayList();
        }
        ArrayList langSkillList = Lists.newArrayListWithExpectedSize((int)languageInfos.size());
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tstpm_srrsmlangabl");
        int index = 0;
        for (LanguagesSkills lang : languageInfos) {
            DynamicObject familiarity;
            DynamicObject langSklDy = hrBaseServiceHelper.generateEmptyDynamicObject();
            langSklDy.set("id", (Object)ID.genLongId());
            langSklDy.set("rsm", rsm.get("id"));
            if (HRStringUtils.isNotEmpty((String)lang.getLanguageName())) {
                langSklDy.set("languagename", (Object)ResumeAnalysisHelper.getLanguage(lang.getLanguageName()));
            }
            if (HRStringUtils.isNotEmpty((String)lang.getLangCertScore())) {
                langSklDy.set("langcertscore", (Object)lang.getLangCertScore());
            } else {
                langSklDy.set("langcertscore", (Object)0);
            }
            if (HRStringUtils.isNotEmpty((String)lang.getListAndSpkAbl())) {
                familiarity = this.resumeAnalysisHelper.getFamiliarity(lang.getListAndSpkAbl());
                langSklDy.set("listandspkabl", (Object)familiarity);
                langSklDy.set("spoken", (Object)familiarity);
            }
            if (HRStringUtils.isNotEmpty((String)lang.getLiteracy())) {
                familiarity = this.resumeAnalysisHelper.getFamiliarity(lang.getLiteracy());
                langSklDy.set("read", (Object)familiarity);
                langSklDy.set("literacy", (Object)familiarity);
            }
            langSklDy.set("index", (Object)index);
            ResumeAnalysisHelper.setCreatorAndTime(langSklDy);
            ++index;
            langSkillList.add(langSklDy);
        }
        return langSkillList;
    }

    public List<DynamicObject> generateSkillInfo(DynamicObject rsm, ResumeInfo resumeInfo) {
        ArrayList<Skills> skillsList = new ArrayList<Skills>(Arrays.asList(resumeInfo.getProfessionalSkills()));
        if (skillsList.isEmpty()) {
            return Lists.newArrayList();
        }
        ArrayList skillList = Lists.newArrayListWithExpectedSize((int)skillsList.size());
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tstpm_srrsmproskl");
        int index = 0;
        for (Skills skl : skillsList) {
            DynamicObject skillDy = hrBaseServiceHelper.generateEmptyDynamicObject();
            skillDy.set("id", (Object)ID.genLongId());
            skillDy.set("rsm", rsm.get("id"));
            skillDy.set("skillname", (Object)skl.getSkillName());
            skillDy.set("useDuration", (Object)skl.getUseDuration());
            if (HRStringUtils.isNotEmpty((String)skl.getMastery())) {
                skillDy.set("mastery", (Object)this.resumeAnalysisHelper.convertStringToDtId("hbss_familiarity", skl.getMastery()));
            }
            skillDy.set("index", (Object)index);
            ResumeAnalysisHelper.setCreatorAndTime(skillDy);
            ++index;
            skillList.add(skillDy);
        }
        return skillList;
    }

    public List<DynamicObject> generateTrainInfo(DynamicObject rsm, ResumeInfo resumeInfo) {
        ArrayList<TrainingInfo> trainingInfos = new ArrayList<TrainingInfo>(Arrays.asList(resumeInfo.getTrainingExperience()));
        if (trainingInfos.isEmpty()) {
            return Lists.newArrayList();
        }
        ArrayList traExpList = Lists.newArrayListWithExpectedSize((int)trainingInfos.size());
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tstpm_srrsmtrnexp");
        int index = 0;
        for (TrainingInfo trainingInfo : trainingInfos) {
            DynamicObject traExpDy = hrBaseServiceHelper.generateEmptyDynamicObject();
            traExpDy.set("id", (Object)ID.genLongId());
            traExpDy.set("rsm", rsm.get("id"));
            if (HRStringUtils.isNotEmpty((String)trainingInfo.getStartDate())) {
                Date startDate = ResumeAnalysisHelper.parseDate(trainingInfo.getStartDate());
                traExpDy.set("startdate", (Object)startDate);
            }
            if (HRStringUtils.isNotEmpty((String)trainingInfo.getEndingDate())) {
                Date endingDate = ResumeAnalysisHelper.parseDate(trainingInfo.getEndingDate());
                traExpDy.set("endingdate", (Object)endingDate);
            }
            traExpDy.set("trainingdesc", (Object)trainingInfo.getTrainingDesc());
            traExpDy.set("traininginst", (Object)trainingInfo.getTrainingInst());
            traExpDy.set("trainingcourse", (Object)trainingInfo.getTrainingCourse());
            traExpDy.set("trainingplace", (Object)trainingInfo.getTrainingPlace());
            traExpDy.set("certificatetitle", (Object)trainingInfo.getCertificateTitle());
            traExpDy.set("index", (Object)index);
            ResumeAnalysisHelper.setCreatorAndTime(traExpDy);
            ++index;
            traExpList.add(traExpDy);
        }
        return traExpList;
    }

    public ResumeInfo getLocalJsonResume() {
        ResumeInfo resumeInfo;
        String str = ResumeAnalysisHelper.txt2String();
        Gson gson = new Gson();
        try {
            str = SHrAnalysisService.handleToResumeInfoData(str);
            resumeInfo = (ResumeInfo)gson.fromJson(str, ResumeInfo.class);
        }
        catch (JsonSyntaxException ex) {
            LOG.error((Throwable)ex);
            resumeInfo = (ResumeInfo)gson.fromJson(str.substring(1), ResumeInfo.class);
        }
        if (resumeInfo != null) {
            resumeInfo.setFileName("Java\u5f00\u53d1\u5de5\u7a0b\u5e08-\u767d\u4e1c\u658c-\u62c9\u52fe\u62db\u8058.pdf");
            resumeInfo.setResumeStoAdd("/tenant_patchhr_test/241358211622/202105/\u524d\u7aef\u5f00\u53d1\u5de5\u7a0b\u5e08-51job-20210524.txt");
            if (HRStringUtils.isEmpty((String)resumeInfo.getName()) || HRStringUtils.isEmpty((String)resumeInfo.getEmail()) || HRStringUtils.isEmpty((String)resumeInfo.getPhone())) {
                resumeInfo.setResult(ResumeConstants.RESULT_NOTFULL);
            } else {
                resumeInfo.setResult(ResumeConstants.RESULT_SUCCESS);
            }
            resumeInfo.setResultStatus(200);
        }
        return resumeInfo;
    }

    public void loadExpEntity(ResumeInfo resumeInfo, AppResumeBo resumeBo) {
        DynamicObject rsm = resumeBo.getRsm();
        if (null != resumeInfo.getEducationInfo()) {
            List<DynamicObject> eduExpList = this.generateEducationInfo(rsm, resumeInfo);
            resumeBo.setEntry("tstpm_srrsmeduexp", eduExpList);
        }
        if (null != resumeInfo.getExperienceInfo()) {
            List<DynamicObject> workExpList = this.generateExperienceInfo(rsm, resumeInfo);
            resumeBo.setEntry("tstpm_srrsmworkexp", workExpList);
        }
        if (null != resumeInfo.getProjectExperience()) {
            List<DynamicObject> prjExpList = this.generateProjectInfo(rsm, resumeInfo);
            resumeBo.setEntry("tstpm_srrsmprjexp", prjExpList);
        }
        if (null != resumeInfo.getLanguageAbility()) {
            List<DynamicObject> langAbility = this.generateLangAbilityInfo(rsm, resumeInfo);
            resumeBo.setEntry("tstpm_srrsmlangabl", langAbility);
        }
        if (null != resumeInfo.getProfessionalSkills()) {
            List<DynamicObject> skillList = this.generateSkillInfo(rsm, resumeInfo);
            resumeBo.setEntry("tstpm_srrsmproskl", skillList);
        }
        if (null != resumeInfo.getTrainingExperience()) {
            List<DynamicObject> trainExp = this.generateTrainInfo(rsm, resumeInfo);
            resumeBo.setEntry("tstpm_srrsmtrnexp", trainExp);
        }
    }
}

