/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbs.business.domain.rsm.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class AdminDivisionHelper {
    private static HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper("bd_admindivision");

    private AdminDivisionHelper() {
    }

    public static List<Map<String, String>> getAdminDivisionsByParentId(long parentId) {
        ORM orm = ORM.create();
        QFilter filter = new QFilter("parent", "=", (Object)parentId);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection dynamicObjects = orm.query("bd_admindivision", "id,name", filters, "id asc");
        ArrayList provinces = Lists.newArrayListWithExpectedSize((int)dynamicObjects.size());
        for (DynamicObject dynamicObject : dynamicObjects) {
            HashMap map = Maps.newHashMapWithExpectedSize((int)2);
            map.put("id", dynamicObject.get("id").toString());
            map.put("name", dynamicObject.get("name").toString());
            provinces.add(map);
        }
        return provinces;
    }

    public static boolean haveChildAdminDivision(long parentId) {
        List<Map<String, String>> childAdminDivision = AdminDivisionHelper.getAdminDivisionsByParentId(parentId);
        return !childAdminDivision.isEmpty();
    }

    public static DynamicObject getAdminDivisionById(long adminId) {
        String queryField = "id,name,parent,basedatafield,iscity";
        return baseServiceHelper.queryOne(queryField, (Object)adminId);
    }

    public static String fullName(long id) {
        DynamicObject division;
        ArrayList<String> names = new ArrayList<String>();
        DynamicObject lastDivision = null;
        while ((division = baseServiceHelper.queryOne("number,name,parent,basedatafield", (Object)id)) != null) {
            names.add(division.getString("name"));
            id = division.getLong("parent.id");
            lastDivision = division;
        }
        if (names.isEmpty()) {
            return null;
        }
        if (null != lastDivision) {
            HRBaseServiceHelper levelHelper = new HRBaseServiceHelper("bd_admindivisionlevel");
            DynamicObject level = levelHelper.queryOne("name,country", (Object)lastDivision.getLong("basedatafield.id"));
            StringBuilder builder = new StringBuilder(level.getString("country.name"));
            for (int i = names.size() - 1; i >= 0; --i) {
                builder.append((String)names.get(i));
            }
            return builder.toString();
        }
        return null;
    }
}

