/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbs.business.domain.rsm.service;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;

public class CandidateSortHelper {
    private CandidateSortHelper() {
    }

    public static List<DynamicObject> sortExperience(DynamicObject[] array, String startDateField, String endDateField, String createTimeField) {
        int length = array.length;
        ArrayList hadDateList = Lists.newArrayListWithExpectedSize((int)length);
        ArrayList noneDateList = Lists.newArrayListWithExpectedSize((int)length);
        for (DynamicObject dynamicObject : array) {
            Date endingDate = dynamicObject.getDate(endDateField);
            Date startDate = dynamicObject.getDate(startDateField);
            if (Objects.equal((Object)endingDate, null) && Objects.equal((Object)startDate, null)) {
                noneDateList.add(dynamicObject);
                continue;
            }
            hadDateList.add(dynamicObject);
        }
        ArrayList resultList = Lists.newArrayListWithExpectedSize((int)length);
        if (!hadDateList.isEmpty()) {
            hadDateList.sort((o1, o2) -> {
                Date o1StartDate = o1.getDate(startDateField);
                Date o1EndingDate = o1.getDate(endDateField);
                Date o1CreateTime = o1.getDate(createTimeField);
                Date o2StartDate = o2.getDate(startDateField);
                Date o2EndingDate = o2.getDate(endDateField);
                Date o2CreateTime = o2.getDate(createTimeField);
                return CandidateSortHelper.getResult(o1StartDate, o1EndingDate, o1CreateTime, o2StartDate, o2EndingDate, o2CreateTime);
            });
            resultList.addAll(hadDateList);
        }
        if (!noneDateList.isEmpty()) {
            noneDateList.sort((o1, o2) -> CandidateSortHelper.compare(o1.getDate(createTimeField), o2.getDate(createTimeField)));
            resultList.addAll(noneDateList);
        }
        return resultList;
    }

    private static int getResult(Date o1StartDate, Date o1EndingDate, Date o1CreateDate, Date o2StartDate, Date o2EndingDate, Date o2CreateDate) {
        int compare = o1StartDate != null && o1EndingDate != null ? CandidateSortHelper.handStartAndEnd(o1StartDate, o1EndingDate, o1CreateDate, o2StartDate, o2EndingDate, o2CreateDate) : (o1StartDate != null ? CandidateSortHelper.hadStartNoEnd(o1StartDate, o1CreateDate, o2StartDate, o2EndingDate, o2CreateDate) : CandidateSortHelper.noStartHadEnd(o1EndingDate, o1CreateDate, o2StartDate, o2EndingDate, o2CreateDate));
        return compare;
    }

    private static int handStartAndEnd(Date o1StartDate, Date o1EndingDate, Date o1CreateDate, Date o2StartDate, Date o2EndingDate, Date o2CreateDate) {
        int compare = o2StartDate != null && o2EndingDate != null ? CandidateSortHelper.compareBothDate(o1StartDate, o1EndingDate, o1CreateDate, o2StartDate, o2EndingDate, o2CreateDate) : (o2StartDate != null ? CandidateSortHelper.compareSingleDate(o1StartDate, o1CreateDate, o2StartDate, o2CreateDate) : CandidateSortHelper.compareSingleDate(o1EndingDate, o1CreateDate, o2EndingDate, o2CreateDate));
        return compare;
    }

    private static int noStartHadEnd(Date o1EndingDate, Date o1CreateDate, Date o2StartDate, Date o2EndingDate, Date o2CreateDate) {
        int compare = o2EndingDate != null ? CandidateSortHelper.compareSingleDate(o1EndingDate, o1CreateDate, o2EndingDate, o2CreateDate) : CandidateSortHelper.compareSingleDate(o1EndingDate, o1CreateDate, o2StartDate, o2CreateDate);
        return compare;
    }

    private static int hadStartNoEnd(Date o1StartDate, Date o1CreateDate, Date o2StartDate, Date o2EndingDate, Date o2CreateDate) {
        int compare = o2StartDate != null ? CandidateSortHelper.compareSingleDate(o1StartDate, o1CreateDate, o2StartDate, o2CreateDate) : CandidateSortHelper.compareSingleDate(o1StartDate, o1CreateDate, o2EndingDate, o2CreateDate);
        return compare;
    }

    public static void addIndex(List<DynamicObject> list) {
        int index = list.size();
        for (DynamicObject dynamicObject : list) {
            dynamicObject.set("index", (Object)new BigDecimal(index));
            --index;
        }
    }

    public static BigDecimal sortSingle(DynamicObject dy, DynamicObject[] list) {
        BigDecimal currIndex;
        DynamicObject[] newArrays = new DynamicObject[list.length + 1];
        newArrays[0] = dy;
        int count = 1;
        DynamicObject[] dynamicObjectArray = list;
        int n = dynamicObjectArray.length;
        for (int i = 0; i < n; ++i) {
            DynamicObject dynamicObject;
            newArrays[count] = dynamicObject = dynamicObjectArray[i];
            ++count;
        }
        List<DynamicObject> sort = CandidateSortHelper.sortExperience(newArrays, "startdate", "endingdate", "createtime");
        int index = sort.indexOf(dy);
        if (index == newArrays.length - 1) {
            BigDecimal bIndex = new BigDecimal(index);
            currIndex = bIndex.divide(new BigDecimal(2), 2, RoundingMode.HALF_UP);
        } else {
            DynamicObject afterObject = sort.get(index + 1);
            BigDecimal afterIndex = afterObject.getBigDecimal("index");
            if (index == 0) {
                currIndex = afterIndex.add(new BigDecimal(2));
            } else {
                DynamicObject beforeObject = sort.get(index - 1);
                BigDecimal beforeIndex = beforeObject.getBigDecimal("index");
                currIndex = afterIndex.add(beforeIndex).divide(new BigDecimal(2), 2, RoundingMode.HALF_UP);
            }
        }
        return currIndex;
    }

    private static int compareBothDate(Date o1StartDate, Date o1EndingDate, Date o1CreateDate, Date o2StartDate, Date o2EndingDate, Date o2CreateDate) {
        int compare = CandidateSortHelper.compare(o1EndingDate, o2EndingDate);
        if (compare == 0) {
            compare = CandidateSortHelper.compare(o1StartDate, o2StartDate);
        }
        if (compare == 0) {
            compare = CandidateSortHelper.compare(o1CreateDate, o2CreateDate);
        }
        return compare;
    }

    private static int compareSingleDate(Date o1Date, Date o1CreateTime, Date o2Date, Date o2CreateTime) {
        int compare = CandidateSortHelper.compare(o1Date, o2Date);
        if (compare == 0) {
            compare = CandidateSortHelper.compare(o1CreateTime, o2CreateTime);
        }
        return compare;
    }

    private static int compare(Date start, Date end) {
        long startTime = 0L;
        if (null != start) {
            startTime = start.getTime();
        }
        long endTime = 0L;
        if (null != end) {
            endTime = end.getTime();
        }
        if (startTime == endTime) {
            return 0;
        }
        int result = 1;
        if (startTime > endTime) {
            result = -1;
        }
        return result;
    }
}

