/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbs.business.domain.rsm.service;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.NumberGenerater;
import kd.tsc.tsrbs.common.exception.TSCBizException;
import org.apache.commons.codec.binary.Base64;

public class PictureUploadBizServiceHelper {
    private static PictureUploadBizServiceHelper pictureUploadBizServiceHelper = new PictureUploadBizServiceHelper();
    private static final Log logger = LogFactory.getLog(PictureUploadBizServiceHelper.class);

    private PictureUploadBizServiceHelper() {
    }

    public static PictureUploadBizServiceHelper getInstance() {
        return pictureUploadBizServiceHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String uploadPicture(String photoBase64String, String fileName, String suffix, String prefix) {
        FileService fs = FileServiceFactory.getImageFileService();
        String upload = null;
        InputStream inputStream = null;
        try {
            inputStream = this.baseToInputStream(photoBase64String.getBytes(StandardCharsets.UTF_8));
            String[] fileNameArray = fileName.split("\\.");
            String fileNamePre = fileNameArray[0];
            String photoRandomId = NumberGenerater.getInstance().generaterNextNumber(HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now()), prefix);
            StringBuilder imgName = new StringBuilder();
            imgName.append(fileNamePre);
            imgName.append(suffix);
            StringBuilder imgPath = new StringBuilder();
            imgPath.append("/tsrbs_resume/images/");
            imgPath.append(String.valueOf(photoRandomId));
            imgPath.append('/');
            imgPath.append((CharSequence)imgName);
            FileItem fi = new FileItem(imgName.toString(), imgPath.toString(), inputStream);
            fi.setCreateNewFileWhenExists(true);
            upload = fs.upload(fi);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ex) {
                    logger.error("PictureUploadBizServiceHelper.uploadPicture.error", (Throwable)ex);
                }
            }
        }
        return upload;
    }

    public String uploadPicture(String photoBase64String, String fileName) {
        return this.uploadPicture(photoBase64String, fileName, ".JPG", "");
    }

    private InputStream baseToInputStream(byte[] photoBase64String) {
        ByteArrayInputStream stream;
        try {
            byte[] bytes1 = Base64.decodeBase64((byte[])photoBase64String);
            stream = new ByteArrayInputStream(bytes1);
        }
        catch (Exception e) {
            logger.error("PictureUploadBizServiceHelper.baseToInputStream.error", (Throwable)e);
            throw new TSCBizException((Throwable)e);
        }
        return stream;
    }
}

