/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbs.business.domain.rsm.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;
import kd.tsc.tsrbd.common.constants.TSCBaseConstants;
import kd.tsc.tsrbd.common.constants.rsm.RsmAnalysisKDString;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.business.domain.rsm.service.RsmAnalysisValueMap;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class ResumeAnalysisHelper {
    private static final String LOCAL_RESUME_JSON = "D:/sample.json";
    private static final String[] DATE_PATTERNS = new String[]{"yyyy-MM-dd HH:mm:ss", "yyyy/MM/dd HH:mm:ss", "yyyyMMdd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy/MM/dd HH:mm", "yyyy-MM-dd", "yyyy/MM/dd", "yyyy\u5e74MM\u6708dd\u65e5", "yyyy\u5e74MM\u6708dd", "yyyy\u5e74M\u6708d\u65e5", "yyyy\u5e74M\u6708d", "yyyyMMdd", "yyyy-MM", "yyyy/M", "yyyy\u5e74MM\u6708", "yyyy\u5e74M\u6708", "yyyy\u5e74M", "yyyy.M", "yyyy\u5e74", "yyyy"};
    private String checkPhoneRegix = "[\\w!#$%&'*+/=?^_`{|}~-]+(?:\\.[\\w!#$%&'*+/=?^_`{|}~-]+)*@(?:[\\w](?:[\\w-]*[\\w])?\\.)+[\\w](?:[\\w-]*[\\w])?";
    private Pattern regex = Pattern.compile(this.checkPhoneRegix);
    private static final Pattern PATTERN = Pattern.compile("^-?\\d+(\\.\\d+)?$");
    private static final Log logger = LogFactory.getLog(ResumeAnalysisHelper.class);
    private Map<String, DynamicObject> dyCache = Maps.newConcurrentMap();
    private static ResumeAnalysisHelper resumeAnalysisHelper = new ResumeAnalysisHelper();

    public static ResumeAnalysisHelper getInstance() {
        return resumeAnalysisHelper;
    }

    private ResumeAnalysisHelper() {
    }

    public static int calculateAge(Date birthday) {
        boolean currentDateLessThanBirthday;
        if (birthday == null) {
            return 0;
        }
        LocalDate now = LocalDate.now();
        int yearNow = now.getYear();
        int monthNow = now.getMonthValue();
        int dayOfMonthNow = now.getDayOfMonth();
        LocalDate localBir = Instant.ofEpochMilli(birthday.getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
        int yearBirth = localBir.getYear();
        int monthBirth = localBir.getMonthValue();
        int dayOfMonthBirth = localBir.getDayOfMonth();
        int age = yearNow - yearBirth;
        boolean bl = currentDateLessThanBirthday = monthNow < monthBirth || monthNow == monthBirth && dayOfMonthNow < dayOfMonthBirth;
        if (currentDateLessThanBirthday) {
            --age;
        }
        return age;
    }

    public static int calMonthByStartDate(Date startDate) {
        if (null == startDate) {
            return 0;
        }
        Long totalDay = (System.currentTimeMillis() - startDate.getTime()) / 86400000L;
        return ResumeAnalysisHelper.getTotalMouthsByTotalDays(totalDay.intValue());
    }

    public static int calculateDuration(DynamicObject eduExp) {
        Date startDate = eduExp.getDate("startdate");
        Date endDate = eduExp.getDate("endingdate");
        if (startDate != null && endDate != null) {
            return ResumeAnalysisHelper.calculateDuration(startDate, endDate);
        }
        return 0;
    }

    public static int calculateDuration(Date startTime, Date endTime) {
        if (startTime == null || endTime == null) {
            return -1;
        }
        Long totalDay = (endTime.getTime() - startTime.getTime()) / 86400000L;
        return totalDay.intValue();
    }

    public static String conversionDuration(int totalDay) {
        if (totalDay < 0) {
            return "";
        }
        int year = totalDay / 365;
        int yearSurplusDay = totalDay % 365;
        int month = yearSurplusDay / 30;
        int monthSurplusDay = yearSurplusDay % 30;
        if (year == 0) {
            return ResumeAnalysisHelper.calculateZeroYearDuration(month, monthSurplusDay);
        }
        return ResumeAnalysisHelper.calculateYearDuration(year, month, monthSurplusDay);
    }

    private static String calculateYearDuration(int year, int month, int monthSurplusDay) {
        String duration = "";
        if (monthSurplusDay >= 15) {
            ++month;
        }
        duration = month == 0 ? String.format(Locale.ROOT, RsmAnalysisKDString.regYear(), year) : String.format(Locale.ROOT, RsmAnalysisKDString.regYearMonth(), year, month);
        return duration;
    }

    private static String calculateZeroYearDuration(int month, int monthSurplusDay) {
        String duration = "";
        if (monthSurplusDay >= 15) {
            ++month;
        }
        if (month == 12) {
            int year = 1;
            duration = String.format(Locale.ROOT, RsmAnalysisKDString.regYear(), year);
        } else if (month != 0) {
            duration = String.format(Locale.ROOT, RsmAnalysisKDString.regMonth(), month);
        }
        return duration;
    }

    public static int calculateWorkingYears(Date partwt) {
        if (partwt == null) {
            return 0;
        }
        Date currentDate = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        Long workingYears = (currentDate.getTime() - partwt.getTime()) / 1471228928L;
        return workingYears.intValue();
    }

    public static String conversionGender(String gender) {
        String genderDesc = "";
        genderDesc = "0".equals(gender) ? RsmAnalysisKDString.genderM() : ("1".equals(gender) ? RsmAnalysisKDString.genderW() : ("2".equals(gender) ? RsmAnalysisKDString.genderN() : ""));
        return genderDesc;
    }

    public static Map<String, Object> getPromptInfoParams(String promptInfo) {
        HashMap fieldMap = Maps.newHashMapWithExpectedSize((int)1);
        HashMap itemMap = Maps.newHashMapWithExpectedSize((int)1);
        HashMap tipMap = Maps.newHashMapWithExpectedSize((int)1);
        String language = "zh_CN";
        tipMap.put(language, promptInfo);
        itemMap.put("emptytip", tipMap);
        fieldMap.put("item", itemMap);
        return fieldMap;
    }

    public static void setPromptInfo(IFormView formView) {
        Map<String, Object> promptInfoParams = ResumeAnalysisHelper.getPromptInfoParams(RsmAnalysisKDString.pleaseInput());
        formView.updateControlMetadata("startdate", promptInfoParams);
        formView.updateControlMetadata("endingdate", promptInfoParams);
    }

    public static boolean checkStartEndDate(DynamicObject obj) {
        Date startDate = obj.getDate("startdate");
        Date endingDate = obj.getDate("endingdate");
        return startDate == null || endingDate == null || HRDateTimeUtils.dateDiff((Date)startDate, (Date)endingDate) >= 0L;
    }

    public static List<String> getCountrys() {
        HRBaseServiceHelper countryHelper = new HRBaseServiceHelper("bd_country");
        DynamicObject[] countryDys = countryHelper.query(null);
        ArrayList countryIds = Lists.newArrayListWithExpectedSize((int)countryDys.length);
        for (DynamicObject countryDy : countryDys) {
            countryIds.add(countryDy.getString("id"));
        }
        return countryIds;
    }

    public static Boolean isCity(Object id) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("bd_admindivision");
        DynamicObject dynamicObject = helper.loadSingle(id);
        return dynamicObject.getBoolean("iscity");
    }

    public static Date getBirthdayByAge(int age) {
        LocalDateTime localDateTime = LocalDateTime.now();
        localDateTime = localDateTime.plusYears((long)age * -1L);
        localDateTime = localDateTime.withMonth(1);
        localDateTime = localDateTime.withDayOfMonth(1);
        return HRDateTimeUtils.localDateTime2Date((LocalDateTime)localDateTime);
    }

    public static Date getDateByDiffMonth(int month) {
        LocalDateTime localDateTime = LocalDateTime.now();
        localDateTime = localDateTime.plusMonths((long)month * -1L);
        localDateTime = localDateTime.withDayOfMonth(1);
        return HRDateTimeUtils.localDateTime2Date((LocalDateTime)localDateTime);
    }

    public static Date getDateStartByDiffYear(int diffYear) {
        LocalDateTime localDateTime = LocalDateTime.now();
        localDateTime = localDateTime.plusYears((long)diffYear * -1L);
        localDateTime = localDateTime.withMonth(1);
        localDateTime = localDateTime.withDayOfMonth(1);
        return HRDateTimeUtils.localDateTime2Date((LocalDateTime)localDateTime);
    }

    public static boolean checkPhone(String phone) {
        boolean flag = false;
        if (!phone.startsWith("+86-")) {
            phone = StringUtils.replace((String)phone, (String)"+", (String)"").replace("-", "").trim();
            flag = ResumeAnalysisHelper.isNumber(phone);
        } else if ((phone = StringUtils.removeStart((String)phone, (String)"+86-")).length() != 11) {
            flag = false;
        } else {
            try {
                Long.parseLong(phone);
                flag = true;
            }
            catch (NumberFormatException e) {
                flag = false;
                logger.error((Throwable)e);
            }
        }
        return flag;
    }

    public static boolean checkEmail(String email) {
        boolean flag;
        try {
            Matcher matcher = ResumeAnalysisHelper.getInstance().regex.matcher(email);
            flag = matcher.matches();
        }
        catch (Exception e) {
            flag = false;
            logger.error((Throwable)e);
        }
        return flag;
    }

    public static boolean isNumber(String string) {
        if (string == null) {
            return false;
        }
        return PATTERN.matcher(string).matches();
    }

    public static void setCreatorAndTime(DynamicObject dy) {
        if (dy != null) {
            Long userId = TSCRequestContext.getUserId();
            Date now = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
            dy.set("creator", (Object)userId);
            dy.set("createtime", (Object)now);
            dy.set("modifier", (Object)userId);
            dy.set("modifytime", (Object)now);
        }
    }

    public static String txt2String() {
        try {
            File file = new File(LOCAL_RESUME_JSON);
            return FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    public static Long getGender(String gender) {
        if (HRStringUtils.isEmpty((String)gender)) {
            return 1030L;
        }
        gender = gender.trim();
        Map<String, Long> valueMap = RsmAnalysisValueMap.getGenderMap();
        Long genderName = valueMap.get(gender);
        if (null == genderName) {
            genderName = 1030L;
        } else if (genderName != 1010L && genderName != 1020L) {
            genderName = 1040L;
        }
        return genderName;
    }

    public Long getPoliticsStatus(String politics) {
        Map<String, Long> valueMap = RsmAnalysisValueMap.getPoliticsMap();
        Long politicsId = valueMap.get(politics);
        if (null != politicsId) {
            return politicsId;
        }
        return 1140L;
    }

    public static Long getJobStatus(String jobStatus) {
        Map<String, Long> valueMap = RsmAnalysisValueMap.getJobStatusMap();
        Long jobStatusId = valueMap.get(jobStatus);
        if (null != jobStatusId) {
            return jobStatusId;
        }
        return 0L;
    }

    public static Long getMarryStatus(String marryStatus) {
        Map<String, Long> valueMap = RsmAnalysisValueMap.getMarryStatusMap();
        Long marryStatusId = valueMap.get(marryStatus);
        if (null != marryStatusId) {
            return marryStatusId;
        }
        return 0L;
    }

    public static Long getPregnantStatus(String ps) {
        Map<String, Long> valueMap = RsmAnalysisValueMap.getPregnantStatus();
        Long psId = valueMap.get(ps);
        if (null != psId) {
            return psId;
        }
        return 0L;
    }

    public DynamicObject getNation(String nation) {
        String nationName;
        if (HRStringUtils.isNotEmpty((String)nation) && !nation.endsWith(nationName = RsmAnalysisKDString.nation())) {
            nation = nation + nationName;
        }
        return this.convertStringToDt("hbss_flok", nation, "id,name");
    }

    public String getCityId(String city) {
        String rCity;
        if (HRStringUtils.isEmpty((String)city)) {
            return null;
        }
        if (city.contains("-")) {
            String[] cityArr = city.split("-");
            rCity = cityArr[cityArr.length - 1];
        } else {
            rCity = city;
        }
        String provinceDesc = RsmAnalysisKDString.province();
        String cityDesc = RsmAnalysisKDString.city();
        String coutryDesc = RsmAnalysisKDString.county();
        long cityId = 0L;
        if (!(rCity.endsWith(provinceDesc) || rCity.endsWith(cityDesc) || rCity.endsWith(coutryDesc) || (cityId = this.convertStringToDtId("bd_admindivision", rCity = rCity + provinceDesc)) != 0L)) {
            rCity = rCity + cityDesc;
            cityId = this.convertStringToDtId("bd_admindivision", rCity);
        }
        return cityId == 0L ? null : String.valueOf(cityId);
    }

    public DynamicObjectCollection getHobby(String hobby) {
        if (HRStringUtils.isNotEmpty((String)hobby)) {
            String[] hobbys = hobby.split(",");
            DynamicObjectCollection doc = new DynamicObjectCollection();
            for (String str : hobbys) {
                DynamicObject hDy = this.convertStringToDt("hbss_hobby", str, "id");
                if (null == hDy) continue;
                doc.add((Object)hDy);
            }
            return doc;
        }
        return new DynamicObjectCollection();
    }

    public static Date parseDate(String dateString) {
        if (StringUtils.isEmpty((CharSequence)dateString)) {
            return null;
        }
        String nowDay = RsmAnalysisKDString.nowDay();
        if (HRStringUtils.equals((String)nowDay, (String)dateString)) {
            return HRDateTimeUtils.localDate2Date((LocalDate)LocalDate.now());
        }
        Date date = null;
        for (String PATTERN : DATE_PATTERNS) {
            try {
                date = HRDateTimeUtils.parseDate((String)dateString, (String)PATTERN);
                if (null == date) continue;
                break;
            }
            catch (ParseException pe) {
                logger.error("parseDate error:{}", (Object)pe.getMessage());
            }
        }
        return date;
    }

    public int analysisMoney(String moneyStr) {
        int money = 0;
        if (HRStringUtils.isNotEmpty((String)moneyStr)) {
            char ch;
            if (moneyStr.contains("-")) {
                moneyStr = moneyStr.split("-")[1];
            }
            StringBuilder moneyS = new StringBuilder();
            for (int i = 0; i < moneyStr.length() && Character.isDigit(ch = moneyStr.charAt(i)); ++i) {
                moneyS.append(ch);
            }
            if (HRStringUtils.isNotEmpty((String)moneyS.toString())) {
                money = Integer.parseInt(moneyS.toString());
            }
        }
        return money;
    }

    public DynamicObject getSchool(String schoolName) {
        HRBaseServiceHelper serviceHelper;
        if (HRStringUtils.isEmpty((String)schoolName)) {
            return null;
        }
        DynamicObject school = this.dyCache.get(schoolName);
        if (null != school && school.getLong("id") != 0L) {
            return school;
        }
        String prop = "id,number,name,index";
        school = this.convertStringToDt("hbss_college", schoolName, prop);
        if (school == null && (school = (serviceHelper = ServiceHelperCache.getHrBaseServiceHelper((String)"hbss_college")).queryOne(prop, (Object)1386848073895945216L)) != null) {
            this.dyCache.put(schoolName, school);
        }
        return school;
    }

    public DynamicObject getEducation(String education) {
        return this.cacheFromDB(education, "id", "hbss_diploma", Integer2 -> RsmAnalysisValueMap.getEducationMap());
    }

    public DynamicObject getCompanyNature(String companyNature) {
        return this.cacheFromDB(companyNature, "id", "hbss_empnature", Integer2 -> RsmAnalysisValueMap.getCompanyNatureMap());
    }

    public DynamicObject getEducationForm(String from) {
        return this.cacheFromDB(from, "id", "hbss_diplomatype", Integer2 -> RsmAnalysisValueMap.getEduFormMap());
    }

    public DynamicObject getWorkType(String type) {
        return this.cacheFromDB(type, "id", "hbss_laborreltypecls", Integer2 -> RsmAnalysisValueMap.getWorkTypeMap());
    }

    public DynamicObject getAdminDivision(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        String suffixProvince = RsmAnalysisKDString.province();
        String suffixCity = RsmAnalysisKDString.city();
        String suffixCounty = RsmAnalysisKDString.county();
        String[] tokens = name.split("-");
        String token = tokens[tokens.length - 1];
        String suffix = token.substring(token.length() - 1);
        if (suffix.equals(suffixProvince) || suffix.equals(suffixCity) || suffix.equals(suffixCounty)) {
            token = token.substring(0, token.length() - 1);
        }
        return this.getBaseDataMultiLang(TSCBaseConstants.DB_ROUTE_SYS, "bd_admindivision", token, null, null);
    }

    public static Long getLanguage(String language) {
        language = language.trim();
        Map<String, Long> valueMap = RsmAnalysisValueMap.getLanguageMap();
        Long languageType = valueMap.get(language);
        return languageType;
    }

    public DynamicObject getFamiliarity(String name) {
        return this.getBaseDataMultiLang(TSCBaseConstants.DB_ROUTE_HMP, "hbss_familiarity", name, RsmAnalysisValueMap.FAMILIARITY_MAP, "id");
    }

    public <T> DynamicObject getBaseDataMultiLang(DBRoute route, String formId, String name, Map<String, T> map, String prop) {
        Object value;
        DynamicObject dynamicObject = this.dyCache.get(this.cacheKey(formId, name));
        if (dynamicObject != null) {
            return dynamicObject;
        }
        HRBaseServiceHelper serviceHelper = ServiceHelperCache.getHrBaseServiceHelper((String)formId);
        Object v0 = value = MapUtils.isEmpty(map) ? null : map.get(name);
        if (value != null) {
            QFilter qFilter = new QFilter(prop, "=", value);
            dynamicObject = serviceHelper.queryOne("id,number,name,index", qFilter);
        } else {
            String tableName = EntityMetadataCache.getDataEntityType((String)formId).getAlias();
            String sql = String.format("SELECT t1.fid FROM %1$s t1 LEFT JOIN %1$s_l t2 ON t2.fid = t1.fid WHERE t2.flocaleid = '%2$s' AND t2.fname = '%3$s';", tableName, ResManager.getLanguage(), name);
            dynamicObject = (DynamicObject)DB.query((DBRoute)route, (String)sql, resultSet -> {
                if (resultSet.next()) {
                    DynamicObject obj = serviceHelper.generateEmptyDynamicObject();
                    obj.set("id", (Object)resultSet.getLong("fid"));
                    return obj;
                }
                return null;
            });
        }
        if (dynamicObject != null) {
            this.dyCache.put(this.cacheKey(formId, name), dynamicObject);
        }
        return dynamicObject;
    }

    private String cacheKey(String formId, String name) {
        return formId + "." + name;
    }

    private DynamicObject cacheFromDB(String key, String prop, String entityId, IntFunction<Map<String, ?>> function) {
        DynamicObject result = null;
        if (HRStringUtils.isNotEmpty((String)key)) {
            DynamicObject skilledDY = this.dyCache.get(key);
            if (skilledDY != null) {
                if (skilledDY.getLong("id") != 0L) {
                    result = skilledDY;
                }
            } else {
                result = this.cacheFromDBFunctionApply(key, prop, entityId, function);
            }
        }
        logger.info("ResumeAnalysisHelper.cacheFromDB,key:{},prop:{},entityId:{},result:{}", new Object[]{key, prop, entityId, result});
        return result;
    }

    private DynamicObject cacheFromDBFunctionApply(String key, String prop, String entityId, IntFunction<Map<String, ?>> function) {
        DynamicObject result = null;
        Map<String, ?> map = function.apply(0);
        Object value = map.get(key);
        if (null != value) {
            QFilter qFilter;
            String findProps = "id,number,name,index";
            HRBaseServiceHelper serviceHelper = ServiceHelperCache.getHrBaseServiceHelper((String)entityId);
            DynamicObject typeDy = serviceHelper.queryOne(findProps, qFilter = new QFilter(prop, "=", value));
            if (null == typeDy) {
                typeDy = serviceHelper.generateEmptyDynamicObject();
                typeDy.set("id", (Object)0L);
                this.dyCache.put(key, typeDy);
                result = null;
            } else {
                this.dyCache.put(key, typeDy);
                result = typeDy;
            }
        }
        return result;
    }

    public int getInteger(String intDesc) {
        int age;
        block3: {
            age = 0;
            try {
                age = Integer.parseInt(intDesc);
            }
            catch (NumberFormatException ex) {
                StringBuilder ageS = new StringBuilder();
                for (int i = 0; i < intDesc.length(); ++i) {
                    if (!Character.isDigit(intDesc.charAt(i))) continue;
                    ageS.append(intDesc.charAt(i));
                }
                String newAgeS = StringUtils.removeStart((String)ageS.toString(), (String)"0");
                if (!HRStringUtils.isNotEmpty((String)newAgeS)) break block3;
                age = Integer.parseInt(newAgeS);
            }
        }
        return age;
    }

    public static String getWorkYearShow(int totalMonth) {
        String result = "";
        if (totalMonth > 0) {
            int year = totalMonth / 12;
            int month = totalMonth % 12;
            if (year == 0) {
                String monthDesc = RsmAnalysisKDString.regMonth();
                result = String.format(Locale.ROOT, monthDesc, month);
            } else if (month == 0) {
                String yearDesc = RsmAnalysisKDString.regYear();
                result = String.format(Locale.ROOT, yearDesc, year);
            } else {
                String yearMonthDesc = RsmAnalysisKDString.regYearMonth();
                result = String.format(Locale.ROOT, yearMonthDesc, year, month);
            }
        } else if (totalMonth == 0) {
            String insMonth;
            result = insMonth = RsmAnalysisKDString.regInsMonth();
        } else if (totalMonth == -2) {
            result = ResManager.loadKDString((String)"\u5e94\u5c4a\u751f", (String)"RsmAnalysisKDString_87", (String)"tsc-tsrbs-common", (Object[])new Object[0]);
        } else if (totalMonth == -1) {
            result = ResManager.loadKDString((String)"\u5728\u6821\u751f", (String)"RsmAnalysisKDString_88", (String)"tsc-tsrbs-common", (Object[])new Object[0]);
        }
        return result;
    }

    public long convertStringToDtId(String entryName, String str) {
        DynamicObject dt = this.convertStringToDt(entryName, str, "id");
        if (dt != null) {
            return dt.getLong("id");
        }
        return 0L;
    }

    public DynamicObject convertStringToDt(String entryName, String str, String prop) {
        DynamicObject result = null;
        if (HRStringUtils.isNotEmpty((String)str)) {
            DynamicObject dy = this.dyCache.get(str);
            if (null != dy && dy.getLong("id") != 0L) {
                result = dy;
            } else {
                QFilter qFilter;
                HRBaseServiceHelper hrBaseServiceHelper = ServiceHelperCache.getHrBaseServiceHelper((String)entryName);
                DynamicObject dt = hrBaseServiceHelper.queryOne(prop, (qFilter = new QFilter("name", "=", (Object)str)).toArray());
                if (null != dt) {
                    this.dyCache.put(str, dt);
                    result = dt;
                } else {
                    dt = hrBaseServiceHelper.generateEmptyDynamicObject();
                    dt.set("id", (Object)0L);
                    this.dyCache.put(str, dt);
                    result = null;
                }
            }
        }
        return result;
    }

    public static int calMonthByStartDate(Date startDate, Date endDate) {
        if (null == startDate || null == endDate) {
            return 0;
        }
        Date date = new Date(1099, 11, 31);
        if (date.equals(endDate)) {
            endDate = new Date();
        }
        Long totalDay = (endDate.getTime() - startDate.getTime()) / 86400000L;
        return ResumeAnalysisHelper.getTotalMouthsByTotalDays(totalDay.intValue());
    }

    public static int getTotalMouthsByTotalDays(int totalDay) {
        int year = totalDay / 365;
        int yearSurplusDay = totalDay % 365;
        int month = yearSurplusDay / 30;
        int monthSurplusDay = yearSurplusDay % 30;
        if (monthSurplusDay >= 15) {
            ++month;
        }
        return year * 12 + month;
    }
}

