/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbs.business.domain.rsm.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.tsc.tsrbs.business.domain.rsm.service.CandidateSortHelper;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeAnalysisHelper;

public class ResumeExpSortHelper {
    private ResumeExpSortHelper() {
    }

    public static List<DynamicObject> sortRsmEduExp(List<DynamicObject> rsmEduExps) {
        if (rsmEduExps == null || rsmEduExps.isEmpty()) {
            return Lists.newArrayListWithExpectedSize((int)0);
        }
        ArrayList notNullCationEduExps = Lists.newArrayListWithCapacity((int)rsmEduExps.size());
        int highestCationIndex = Integer.MAX_VALUE;
        highestCationIndex = ResumeExpSortHelper.getHighestCationIndex(rsmEduExps, notNullCationEduExps, highestCationIndex);
        List<DynamicObject> indexRepeatedEduExps = ResumeExpSortHelper.getHighestEduList(rsmEduExps, notNullCationEduExps, highestCationIndex);
        List<Object> rsmEduExpSorts = Lists.newArrayListWithCapacity((int)rsmEduExps.size());
        DynamicObject highestEduExp = null;
        if (!indexRepeatedEduExps.isEmpty()) {
            List<DynamicObject> highestEduExpSorts = CandidateSortHelper.sortExperience(indexRepeatedEduExps.toArray(new DynamicObject[indexRepeatedEduExps.size()]), "startdate", "endingdate", "createtime");
            highestEduExp = highestEduExpSorts.get(0);
        }
        if (!rsmEduExps.isEmpty()) {
            rsmEduExpSorts = CandidateSortHelper.sortExperience(rsmEduExps.toArray(new DynamicObject[rsmEduExps.size()]), "startdate", "endingdate", "createtime");
        }
        if (rsmEduExpSorts != null && !rsmEduExpSorts.isEmpty()) {
            if (null == highestEduExp) {
                highestEduExp = (DynamicObject)rsmEduExpSorts.get(0);
            }
            for (int i = 0; i < rsmEduExpSorts.size(); ++i) {
                DynamicObject eduExp = (DynamicObject)rsmEduExpSorts.get(i);
                if (eduExp.getLong("id") == highestEduExp.getLong("id")) {
                    eduExp.set("ishighestedu", (Object)Boolean.TRUE);
                } else {
                    eduExp.set("ishighestedu", (Object)Boolean.FALSE);
                }
                eduExp.set("index", (Object)i);
                ResumeExpSortHelper.setEduDuration(eduExp);
            }
        }
        return rsmEduExpSorts;
    }

    private static int getHighestCationIndex(List<DynamicObject> rsmEduExps, List<DynamicObject> notNullCationEduExps, int highestCationIndex) {
        for (DynamicObject rsmEduExp : rsmEduExps) {
            DynamicObject eduCation = rsmEduExp.getDynamicObject("education");
            if (eduCation != null) {
                notNullCationEduExps.add(rsmEduExp);
                int cationIndex = eduCation.getInt("id");
                if (cationIndex < highestCationIndex) {
                    highestCationIndex = cationIndex;
                }
            }
            if (rsmEduExp.get("createtime") != null) continue;
            ResumeAnalysisHelper.setCreatorAndTime(rsmEduExp);
        }
        return highestCationIndex;
    }

    private static List<DynamicObject> getHighestEduList(List<DynamicObject> rsmEduExps, List<DynamicObject> notNullCationEduExps, int highestCationIndex) {
        ArrayList indexRepeatedEduExps = Lists.newArrayListWithCapacity((int)rsmEduExps.size());
        for (DynamicObject rsmEduExp : notNullCationEduExps) {
            DynamicObject eduCation = rsmEduExp.getDynamicObject("education");
            int cationIndex = eduCation.getInt("id");
            if (cationIndex != highestCationIndex) continue;
            indexRepeatedEduExps.add(rsmEduExp);
        }
        return indexRepeatedEduExps;
    }

    private static void setEduDuration(DynamicObject eduExp) {
        int duration = ResumeAnalysisHelper.calculateDuration(eduExp);
        eduExp.set("lengthofstudy", (Object)duration);
        if (eduExp.containsProperty("showlengthofstudy")) {
            eduExp.set("showlengthofstudy", (Object)ResumeAnalysisHelper.conversionDuration(duration));
        }
    }

    public static void setHighestEduInfo(DynamicObject highestEduExp, DynamicObject rsm) {
        if (highestEduExp != null) {
            rsm.set("highesteduschool", highestEduExp.get("schoolname"));
            rsm.set("hestspecialtycat", highestEduExp.get("specialtycategory"));
            rsm.set("highestspecialty", highestEduExp.get("specialtyname"));
            rsm.set("highesteducation", highestEduExp.get("education"));
            rsm.set("highestdegree", highestEduExp.get("degree"));
        } else {
            rsm.set("highesteduschool", null);
            rsm.set("hestspecialtycat", null);
            rsm.set("highestspecialty", null);
            rsm.set("highesteducation", null);
            rsm.set("highestdegree", null);
        }
    }

    public static List<DynamicObject> sortAllDy(List<DynamicObject> allDyList) {
        if (allDyList == null || allDyList.isEmpty()) {
            return allDyList;
        }
        Comparator timeComparator = (dy1, dy2) -> dy2.getDate("modifytime").compareTo(dy1.getDate("modifytime"));
        Collections.sort(allDyList, timeComparator);
        return allDyList;
    }

    public static List<DynamicObject> sortByProperty(List<DynamicObject> allDyList, String property) {
        if (allDyList == null || allDyList.isEmpty()) {
            return allDyList;
        }
        allDyList.sort((dy1, dy2) -> dy2.getDate(property).compareTo(dy1.getDate(property)));
        return allDyList;
    }

    public static List<DynamicObject> sortRsmWorkExp(List<DynamicObject> rsmWorkExps) {
        DynamicObject[] rsmWorkExpArr = new DynamicObject[rsmWorkExps.size()];
        rsmWorkExps.toArray(rsmWorkExpArr);
        if (rsmWorkExpArr.length <= 0) {
            return rsmWorkExps;
        }
        List<DynamicObject> sortResults = CandidateSortHelper.sortExperience(rsmWorkExpArr, "startdate", "endingdate", "createtime");
        if (sortResults != null && !sortResults.isEmpty()) {
            for (int i = 0; i < sortResults.size(); ++i) {
                DynamicObject workExpDy = sortResults.get(i);
                if (i == 0) {
                    workExpDy.set("isrecwork", (Object)"1");
                } else {
                    workExpDy.set("isrecwork", (Object)"0");
                }
                workExpDy.set("index", (Object)i);
                ResumeExpSortHelper.setWorkDuration(workExpDy);
            }
        }
        return sortResults;
    }

    private static void setWorkDuration(DynamicObject recentWorkExp) {
        int workTime = ResumeAnalysisHelper.calculateDuration(recentWorkExp);
        recentWorkExp.set("lengthofwork", (Object)workTime);
        recentWorkExp.set("showlengthofwork", (Object)ResumeAnalysisHelper.conversionDuration(workTime));
    }

    public static void setRecentWorkInfo(DynamicObject rsmWork, DynamicObject rsm) {
        if (rsmWork != null) {
            rsm.set("recentcompany", rsmWork.get("companyname"));
            rsm.set("recentposition", rsmWork.get("positionname"));
        } else {
            rsm.set("recentcompany", null);
            rsm.set("recentposition", null);
        }
    }

    public static List<DynamicObject> sortRsmPrjExp(List<DynamicObject> rsmPrjExps) {
        DynamicObject[] rsmPrjExpArr = new DynamicObject[rsmPrjExps.size()];
        rsmPrjExps.toArray(rsmPrjExpArr);
        if (rsmPrjExpArr.length <= 0) {
            return rsmPrjExps;
        }
        List<DynamicObject> sortResults = CandidateSortHelper.sortExperience(rsmPrjExpArr, "startdate", "endingdate", "createtime");
        for (int j = 0; j < sortResults.size(); ++j) {
            sortResults.get(j).set("index", (Object)j);
            ResumeExpSortHelper.setPrjDuration(sortResults.get(j));
        }
        return sortResults;
    }

    private static void setPrjDuration(DynamicObject prjExp) {
        int workTime = ResumeAnalysisHelper.calculateDuration(prjExp);
        prjExp.set("projectduration", (Object)workTime);
        prjExp.set("showprojectduration", (Object)ResumeAnalysisHelper.conversionDuration(workTime));
    }

    public static List<DynamicObject> sortRsminterExp(List<DynamicObject> rsminterExp) {
        DynamicObject[] rsmPrjExpArr = new DynamicObject[rsminterExp.size()];
        rsminterExp.toArray(rsmPrjExpArr);
        if (rsmPrjExpArr.length <= 0) {
            return rsminterExp;
        }
        List<DynamicObject> sortResults = CandidateSortHelper.sortExperience(rsmPrjExpArr, "startdate", "endingdate", "createtime");
        for (int j = 0; j < sortResults.size(); ++j) {
            sortResults.get(j).set("index", (Object)j);
            ResumeExpSortHelper.setWorkDuration(sortResults.get(j));
        }
        return sortResults;
    }
}

