/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbs.business.domain.service;

import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbs.common.constants.coordination.SubscribeStatusEnum;

public class CoordPublisherDomainService {
    private static final HRBaseServiceHelper REPOSITORY = new HRBaseServiceHelper("tsrbs_coordpublisher");

    public DynamicObject queryOneCoordPublisher(String number) {
        QFilter numFilter = new QFilter("number", "=", (Object)number);
        return REPOSITORY.queryOne("number,actioncloud,actionapp", numFilter);
    }

    public void subscribePublisher(List<String> numbers) {
        QFilter numFilter = new QFilter("number", "in", numbers);
        DynamicObject[] publishers = REPOSITORY.query("substatus", new QFilter[]{numFilter});
        DynamicObject[] updatePublisherArray = (DynamicObject[])Arrays.stream(publishers).filter(publisher -> !this.isSubscribe((DynamicObject)publisher)).peek(publisher -> publisher.set("substatus", (Object)SubscribeStatusEnum.HAS_SUBSCRIBED.getNumber())).toArray(DynamicObject[]::new);
        REPOSITORY.update(updatePublisherArray);
    }

    public void unSubscribePublisher(List<String> numbers) {
        QFilter numFilter = new QFilter("number", "in", numbers);
        DynamicObject[] publishers = REPOSITORY.query("substatus", new QFilter[]{numFilter});
        DynamicObject[] updatePublisherArray = (DynamicObject[])Arrays.stream(publishers).filter(this::isSubscribe).peek(publisher -> publisher.set("substatus", (Object)SubscribeStatusEnum.NOT_SUBSCRIBED.getNumber())).toArray(DynamicObject[]::new);
        REPOSITORY.update(updatePublisherArray);
    }

    private boolean isSubscribe(DynamicObject publisher) {
        String subStatus = publisher.getString("substatus");
        return HRStringUtils.equals((String)subStatus, (String)SubscribeStatusEnum.HAS_SUBSCRIBED.getNumber());
    }
}

