/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbs.business.domain.service;

import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRBaseUtils;
import kd.tsc.tsrbs.common.constants.coordination.CoordMsgTypeEnum;
import org.apache.commons.lang3.ObjectUtils;

public class CoordinationMsgDomainService {
    private static final HRBaseServiceHelper REPOSITORY = new HRBaseServiceHelper("tsrbs_coordinationmsg");

    public boolean isMsgExists(Long msgCenterBoId) {
        return REPOSITORY.isExists(new QFilter("msgcenterbo", "=", (Object)msgCenterBoId));
    }

    public DynamicObject newCrossDomainCoordinationMsg() {
        DynamicObject emptyCoordMsg = REPOSITORY.generateEmptyDynamicObject();
        emptyCoordMsg.set("msgType", (Object)CoordMsgTypeEnum.CROSS_DOMAIN.getNumber());
        return emptyCoordMsg;
    }

    public DynamicObject saveInDomainCoordinationMsg(Map<String, Object> messageInfo) {
        DynamicObject newCoordMsg = REPOSITORY.generateEmptyDynamicObject();
        newCoordMsg.set("msgType", (Object)CoordMsgTypeEnum.IN_DOMAIN.getNumber());
        String msgPubNo = (String)messageInfo.get("msgPubNo");
        String msgNumber = (String)messageInfo.get("msgNumber");
        String msgTitle = (String)messageInfo.get("msgTitle");
        String msgDesc = (String)messageInfo.get("msgDesc");
        String msgStatus = (String)messageInfo.get("msgstatus");
        Long senderId = (Long)messageInfo.get("senderId");
        Date sendTime = (Date)messageInfo.get("sendTime");
        String params = (String)messageInfo.get("params");
        Object msgCloud = messageInfo.get("msgCloud");
        Object msgApp = messageInfo.get("msgApp");
        newCoordMsg.set("number", (Object)msgNumber);
        newCoordMsg.set("name", (Object)msgTitle);
        newCoordMsg.set("status", (Object)"C");
        newCoordMsg.set("enable", (Object)"1");
        newCoordMsg.set("description", (Object)msgDesc);
        newCoordMsg.set("index", (Object)0);
        newCoordMsg.set("issyspreset", (Object)0);
        newCoordMsg.set("msgcloud", msgCloud);
        newCoordMsg.set("msgapp", msgApp);
        newCoordMsg.set("msgsubno", (Object)msgPubNo);
        newCoordMsg.set("msgstatus", (Object)msgStatus);
        newCoordMsg.set("sender", (Object)senderId);
        newCoordMsg.set("sendtime", (Object)sendTime);
        newCoordMsg.set("msgcontent", (Object)params);
        if (ObjectUtils.isNotEmpty((Object)messageInfo.get("groupNumber"))) {
            newCoordMsg.set("groupnum", messageInfo.get("groupNumber"));
        }
        if (ObjectUtils.isNotEmpty((Object)messageInfo.get("groupSeq"))) {
            newCoordMsg.set("groupseq", messageInfo.get("groupSeq"));
        }
        if (ObjectUtils.isNotEmpty((Object)messageInfo.get("groupCount"))) {
            newCoordMsg.set("groupcount", messageInfo.get("groupCount"));
        }
        HRBaseUtils.setSysField((DynamicObject)newCoordMsg);
        this.saveCoordinationMsg(newCoordMsg);
        return newCoordMsg;
    }

    public void saveCoordinationMsg(DynamicObject newCoordinationMsg) {
        REPOSITORY.saveOne(newCoordinationMsg);
    }

    public boolean isMsgConsumed(Long id) {
        QFilter qFilter = new QFilter("id", "=", (Object)id);
        qFilter.and("msgstatus", "=", (Object)"A");
        return REPOSITORY.isExists(qFilter);
    }

    public void writeMsgStatus(long msgId, String msgStatus) {
        DynamicObject dy = REPOSITORY.queryOne((Object)msgId);
        dy.set("msgstatus", (Object)msgStatus);
        REPOSITORY.saveOne(dy);
    }

    public DynamicObject[] getNotConsumedMsg() {
        QFilter msgStatusFilter = new QFilter("msgstatus", "=", (Object)"A");
        return REPOSITORY.query("id , number , name , msgapp , msgcloud , groupnum , groupseq , msgsubno", msgStatusFilter.toArray());
    }
}

