/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbs.business.domain.service;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRBaseUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbs.business.ServiceFactory;
import kd.tsc.tsrbs.business.application.CoordinationApplicationService;
import kd.tsc.tsrbs.business.domain.service.CoordSubscriberDomainService;
import kd.tsc.tsrbs.business.domain.service.CoordTaskLogDomainService;
import kd.tsc.tsrbs.business.domain.service.CoordinationMsgDomainService;
import kd.tsc.tsrbs.business.task.coordination.CoordinationTask;
import kd.tsc.tsrbs.common.constants.coordination.CoordExecuteTypeEnum;
import kd.tsc.tsrbs.common.constants.coordination.CoordTaskStatusEnum;
import org.apache.commons.lang3.ObjectUtils;

public class CoordinationTaskDomainService {
    private static final Log LOGGER = LogFactory.getLog(CoordinationTaskDomainService.class);
    private static final HRBaseServiceHelper REPOSITORY = new HRBaseServiceHelper("tsrbs_coordinationtask");
    public static final ExecutorService EXECUTOR_SERVICE = ThreadPools.newExecutorService((String)CoordinationApplicationService.class.getName(), (int)10);
    private final CoordTaskLogDomainService coordTaskLogDomainService = ServiceFactory.getService(CoordTaskLogDomainService.class);
    private final CoordinationMsgDomainService coordinationMsgDomainService = ServiceFactory.getService(CoordinationMsgDomainService.class);
    private final CoordSubscriberDomainService coordSubscriberDomainService = ServiceFactory.getService(CoordSubscriberDomainService.class);
    private final String selectFields = "id , groupnum , groupseq , coordsubscriber , retrycount , taskstatus , coordinationmsg , status , enable";

    public void batchCreateTask(DynamicObject coordinationMsg, DynamicObject[] coordSubscriberList) {
        ORM orm = ORM.create();
        long[] ids = orm.genLongIds(REPOSITORY.getEntityName(), coordSubscriberList.length);
        for (int i = 0; i < coordSubscriberList.length; ++i) {
            EXECUTOR_SERVICE.submit(new CoordinationTask(coordinationMsg, coordSubscriberList[i], ids[i], CoordExecuteTypeEnum.SYSTEM_EXECUTION.getType()));
        }
    }

    public DynamicObject createTask(DynamicObject coordinationMsg, DynamicObject coordSubscriber, Long id, String taskStatus) {
        DynamicObject taskDy = REPOSITORY.generateEmptyDynamicObject();
        taskDy.set("id", (Object)id);
        taskDy.set("masterid", (Object)id);
        taskDy.set("number", (Object)coordinationMsg.getString("number"));
        taskDy.set("name", (Object)coordinationMsg.getString("name"));
        taskDy.set("batchno", (Object)"");
        if (coordinationMsg.get("msgapp") instanceof DynamicObject) {
            taskDy.set("bizappid", (Object)coordinationMsg.getDynamicObject("msgapp").getString("id"));
        } else if (coordinationMsg.get("msgapp") instanceof String) {
            taskDy.set("bizappid", (Object)coordinationMsg.getString("msgapp"));
        }
        if (coordinationMsg.get("msgcloud") instanceof DynamicObject) {
            taskDy.set("bizcloud", (Object)coordinationMsg.getDynamicObject("msgcloud").getString("id"));
        } else if (coordinationMsg.get("msgcloud") instanceof String) {
            taskDy.set("bizcloud", (Object)coordinationMsg.getString("msgcloud"));
        }
        taskDy.set("businesstag", (Object)coordinationMsg.getString("number"));
        if (ObjectUtils.isNotEmpty((Object)coordinationMsg.getString("groupnum"))) {
            taskDy.set("groupnum", (Object)coordinationMsg.getString("groupnum"));
        }
        if (ObjectUtils.isNotEmpty((Object)coordinationMsg.getString("groupseq"))) {
            taskDy.set("groupseq", (Object)coordinationMsg.getString("groupseq"));
        }
        taskDy.set("coordsubscriber", (Object)coordSubscriber);
        if (HRStringUtils.isNotEmpty((String)taskStatus)) {
            taskDy.set("taskstatus", (Object)taskStatus);
        } else {
            taskDy.set("taskstatus", (Object)CoordTaskStatusEnum.EXECUTING.getStatus());
        }
        taskDy.set("startdate", (Object)new Date());
        taskDy.set("coordinationmsg", (Object)coordinationMsg);
        HRBaseUtils.setSysField((DynamicObject)taskDy);
        taskDy.set("enable", (Object)"1");
        taskDy.set("status", (Object)"C");
        REPOSITORY.saveOne(taskDy);
        return taskDy;
    }

    public void execute(DynamicObject taskDy, String execType) {
        DynamicObject coordSubscriber = taskDy.getDynamicObject("coordsubscriber");
        DynamicObject coordinationMsg = taskDy.getDynamicObject("coordinationmsg");
        String appId = coordSubscriber.getString("consumerapp.number");
        String cloudId = coordSubscriber.getString("consumercloud.number");
        String serviceName = coordSubscriber.getString("consumerservice");
        String methodName = coordSubscriber.getString("consumermethod");
        Date startDate = new Date();
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        map.put("taskId", taskDy.getLong("id"));
        map.put("execType", execType);
        map.put("startDate", startDate);
        try {
            DispatchServiceHelper.invokeBizService((String)cloudId.toLowerCase(), (String)appId.toLowerCase(), (String)serviceName, (String)methodName, (Object[])new Object[]{coordinationMsg, map});
            LOGGER.info("cloudId:{},appId:{},serviceName:{},methodName:{},coordinationMsg:{},map:{}", new Object[]{cloudId, appId, serviceName, methodName, coordinationMsg, map});
        }
        catch (Exception ex) {
            map.put("taskStatus", CoordTaskStatusEnum.FALSE.getStatus());
            map.put("taskInfo", ex.getMessage());
            this.callBackResult(coordinationMsg, map);
            LOGGER.error("CoordinationTaskDomainService.excute() excute error , errorInfo = ", (Throwable)ex);
        }
    }

    public void callBackResult(DynamicObject coordinationMsg, Map<String, Object> resultMap) {
        this.callBackMsg(coordinationMsg);
        Long taskId = (Long)resultMap.get("taskId");
        String taskInfo = (String)resultMap.get("taskInfo");
        String execType = (String)resultMap.get("execType");
        String taskStatus = (String)resultMap.get("taskStatus");
        Date startDate = (Date)resultMap.get("startDate");
        if (taskId == 0L) {
            return;
        }
        DynamicObject taskDy = REPOSITORY.queryOne((Object)taskId);
        if (HRObjectUtils.isEmpty((Object)taskDy)) {
            return;
        }
        if (!HRStringUtils.isNotEmpty((String)taskStatus)) {
            return;
        }
        taskDy.set("taskstatus", (Object)taskStatus);
        taskDy.set("startdate", (Object)startDate);
        taskDy.set("enddate", (Object)new Date());
        if (!HRStringUtils.equals((String)execType, (String)CoordExecuteTypeEnum.SYSTEM_EXECUTION.getType())) {
            int retryCount = taskDy.getInt("retrycount");
            taskDy.set("retrycount", (Object)(retryCount + 1));
        }
        REPOSITORY.saveOne(taskDy);
        this.coordTaskLogDomainService.log(taskDy, execType, taskInfo);
    }

    private void callBackMsg(DynamicObject coordinationMsg) {
        boolean isMsgConsumed = this.coordinationMsgDomainService.isMsgConsumed(coordinationMsg.getLong("id"));
        if (isMsgConsumed) {
            return;
        }
        String msgSubNo = coordinationMsg.getString("msgsubno");
        if (HRStringUtils.isEmpty((String)msgSubNo)) {
            return;
        }
        DynamicObject[] coordSubscriberList = this.coordSubscriberDomainService.getCoordSubscriberList(Collections.singletonList(msgSubNo));
        if (coordSubscriberList == null || coordSubscriberList.length < 1) {
            return;
        }
        boolean existsTask = this.isExistsTask(coordinationMsg, coordSubscriberList);
        if (existsTask) {
            this.coordinationMsgDomainService.writeMsgStatus(coordinationMsg.getLong("id"), "A");
        }
    }

    private boolean isExistsTask(DynamicObject coordinationMsg, DynamicObject[] coordSubscriberList) {
        Set coordSubscriberIds = Arrays.stream(coordSubscriberList).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        QFilter msgIdFilter = new QFilter("coordinationmsg", "=", (Object)coordinationMsg.getLong("id"));
        QFilter subScriberFilter = new QFilter("coordsubscriber", "in", coordSubscriberIds);
        DynamicObject[] taskDys = REPOSITORY.queryOriginalArray("id", new QFilter[]{msgIdFilter, subScriberFilter});
        return taskDys.length == coordSubscriberIds.size();
    }

    public DynamicObject[] getTaskList() {
        Set taskStatusSet = Stream.of(CoordTaskStatusEnum.TO_BE_EXECUTE.getStatus(), CoordTaskStatusEnum.FALSE.getStatus()).collect(Collectors.toSet());
        QFilter taskStatusFilter = new QFilter("taskstatus", "in", taskStatusSet);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        return REPOSITORY.query("id , groupnum , groupseq , coordsubscriber , retrycount , taskstatus , coordinationmsg , status , enable", new QFilter[]{taskStatusFilter, statusFilter, enableFilter});
    }

    public DynamicObject[] getTaskListByIds(List<Long> ids) {
        QFilter idFilter = new QFilter("id", "in", ids);
        return REPOSITORY.query("id , groupnum , groupseq , coordsubscriber , retrycount , taskstatus , coordinationmsg , status , enable", idFilter.toArray());
    }

    public DynamicObject[] getTaskListBySubAndMsg(DynamicObject coordinationMsg, DynamicObject[] coordSubscriberList) {
        Set coordSubscriberIds = Arrays.stream(coordSubscriberList).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        QFilter msgIdFilter = new QFilter("coordinationmsg", "=", (Object)coordinationMsg.getLong("id"));
        QFilter subScriberFilter = new QFilter("coordsubscriber", "in", coordSubscriberIds);
        return REPOSITORY.queryOriginalArray("id", new QFilter[]{msgIdFilter, subScriberFilter});
    }
}

