/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbs.business.domain.service;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbs.common.constants.coordination.CoordExecuteTypeEnum;
import kd.tsc.tsrbs.common.constants.coordination.CoordTaskStatusEnum;

public class CoordinationValidatorDomainService {
    private static final Log LOGGER = LogFactory.getLog(CoordinationValidatorDomainService.class);
    private static final HRBaseServiceHelper REPOSITORY = new HRBaseServiceHelper("tsrbs_coordinationtask");

    public Map<String, String> validate(DynamicObject taskDy, String execType) {
        HashMap<String, String> validateResult = new HashMap<String, String>(2);
        if (HRStringUtils.equals((String)execType, (String)CoordExecuteTypeEnum.SYSTEM_EXECUTION.getType())) {
            return this.systemValidate(taskDy, validateResult);
        }
        if (HRStringUtils.equals((String)execType, (String)CoordExecuteTypeEnum.MANUAL_EXECUTION.getType())) {
            return this.manualValidate(taskDy, validateResult);
        }
        if (HRStringUtils.equals((String)execType, (String)CoordExecuteTypeEnum.SCHEDULED_EXECUTION.getType())) {
            return this.scheduledValidate(taskDy, validateResult);
        }
        return this.getValidateResult(false, null, validateResult);
    }

    private Map<String, String> scheduledValidate(DynamicObject taskDy, Map<String, String> validateResult) {
        this.checkTaskStatus(taskDy, validateResult);
        if (!Boolean.parseBoolean(validateResult.get("result"))) {
            return validateResult;
        }
        this.checkTaskRetryCount(taskDy, validateResult);
        if (!Boolean.parseBoolean(validateResult.get("result"))) {
            return validateResult;
        }
        this.checkSubscriber(taskDy, validateResult);
        if (!Boolean.parseBoolean(validateResult.get("result"))) {
            return validateResult;
        }
        this.checkPreTask(taskDy, validateResult);
        if (!Boolean.parseBoolean(validateResult.get("result"))) {
            return validateResult;
        }
        return this.getValidateResult(true, null, validateResult);
    }

    private Map<String, String> manualValidate(DynamicObject taskDy, Map<String, String> validateResult) {
        this.checkSystemStatus(taskDy, validateResult);
        if (!Boolean.parseBoolean(validateResult.get("result"))) {
            return validateResult;
        }
        this.checkTaskStatus(taskDy, validateResult);
        if (!Boolean.parseBoolean(validateResult.get("result"))) {
            return validateResult;
        }
        this.checkTaskRetryCount(taskDy, validateResult);
        if (!Boolean.parseBoolean(validateResult.get("result"))) {
            return validateResult;
        }
        this.checkSubscriber(taskDy, validateResult);
        if (!Boolean.parseBoolean(validateResult.get("result"))) {
            return validateResult;
        }
        this.checkPreTask(taskDy, validateResult);
        if (!Boolean.parseBoolean(validateResult.get("result"))) {
            return validateResult;
        }
        return this.getValidateResult(true, null, validateResult);
    }

    private void checkSystemStatus(DynamicObject taskDy, Map<String, String> validateResult) {
        if (HRStringUtils.equals((String)taskDy.getString("status"), (String)"C") && HRStringUtils.equals((String)taskDy.getString("enable"), (String)"1")) {
            this.getValidateResult(true, null, validateResult);
        } else {
            String errorMsg = ResManager.loadKDString((String)"\u4efb\u52a1\u72b6\u6001\u4ec5\u4e3a\u5f85\u6267\u884c\u6216\u5931\u8d25\u65f6\uff0c\u5141\u8bb8\u624b\u52a8\u6267\u884c\u3002", (String)"CoordinationValidatorDomainService_02", (String)"tsc-tsrbs-business", (Object[])new Object[0]);
            this.getValidateResult(false, errorMsg, validateResult);
        }
    }

    private Map<String, String> systemValidate(DynamicObject taskDy, Map<String, String> validateResult) {
        return this.checkPreTask(taskDy, validateResult);
    }

    public Map<String, String> checkSubscriber(DynamicObject taskDy, Map<String, String> validateResult) {
        DynamicObject coordSubscriber = taskDy.getDynamicObject("coordsubscriber");
        if (ObjectUtils.isEmpty((Object)coordSubscriber)) {
            String errMsg = ResManager.loadKDString((String)"\u6821\u9a8c\u5931\u8d25\uff0c\u4efb\u52a1\u7684\u8ba2\u9605\u8005\u4e0d\u5b58\u5728\u3002", (String)"CoordinationValidatorDomainService_04", (String)"tsc-tsrbs-business", (Object[])new Object[0]);
            return this.getValidateResult(false, errMsg, validateResult);
        }
        if (HRStringUtils.isNotEmpty((String)coordSubscriber.getString("status")) && !HRStringUtils.equals((String)coordSubscriber.getString("status"), (String)"C")) {
            String errMsg = ResManager.loadKDString((String)"\u6821\u9a8c\u5931\u8d25\uff0c\u4efb\u52a1\u7684\u8ba2\u9605\u8005\u4e0d\u662f\u5df2\u5ba1\u6838\u72b6\u6001\u3002", (String)"CoordinationValidatorDomainService_05", (String)"tsc-tsrbs-business", (Object[])new Object[0]);
            return this.getValidateResult(false, errMsg, validateResult);
        }
        if (HRStringUtils.isNotEmpty((String)coordSubscriber.getString("enable")) && !HRStringUtils.equals((String)coordSubscriber.getString("enable"), (String)"1")) {
            String errMsg = ResManager.loadKDString((String)"\u6821\u9a8c\u5931\u8d25\uff0c\u4efb\u52a1\u7684\u8ba2\u9605\u8005\u5df2\u88ab\u7981\u7528\u3002", (String)"CoordinationValidatorDomainService_06", (String)"tsc-tsrbs-business", (Object[])new Object[0]);
            return this.getValidateResult(false, errMsg, validateResult);
        }
        if (HRStringUtils.isEmpty((String)coordSubscriber.getString("substatus")) || HRStringUtils.equals((String)coordSubscriber.getString("substatus"), (String)"0")) {
            String errMsg = ResManager.loadKDString((String)"\u6821\u9a8c\u5931\u8d25\uff0c\u4efb\u52a1\u7684\u8ba2\u9605\u8005\u672a\u8ba2\u9605\u3002", (String)"CoordinationValidatorDomainService_07", (String)"tsc-tsrbs-business", (Object[])new Object[0]);
            return this.getValidateResult(false, errMsg, validateResult);
        }
        return this.getValidateResult(true, null, validateResult);
    }

    public Map<String, String> checkTaskRetryCount(DynamicObject taskDy, Map<String, String> validateResult) {
        int retrycount = taskDy.getInt("retrycount");
        if (retrycount < 10) {
            return this.getValidateResult(true, null, validateResult);
        }
        String errMsg = ResManager.loadKDString((String)"\u4efb\u52a1\u91cd\u8bd5\u6b21\u6570\u8d85\u8fc7\u5341\u6b21\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u3002", (String)"CoordinationValidatorDomainService_03", (String)"tsc-tsrbs-business", (Object[])new Object[0]);
        return this.getValidateResult(false, errMsg, validateResult);
    }

    public Map<String, String> checkPreTask(DynamicObject taskDy, Map<String, String> validateResult) {
        if (HRStringUtils.isEmpty((String)taskDy.getString("groupnum"))) {
            return this.getValidateResult(true, null, validateResult);
        }
        if (taskDy.getInt("groupseq") < 2) {
            return this.getValidateResult(true, null, validateResult);
        }
        QFilter groupNumFilter = new QFilter("groupnum", "=", (Object)taskDy.getString("groupnum"));
        QFilter groupSeqFilter = new QFilter("groupseq", "=", (Object)(taskDy.getInt("groupseq") - 1));
        DynamicObject[] dys = REPOSITORY.queryOriginalArray("taskstatus", new QFilter[]{groupNumFilter, groupSeqFilter});
        if (dys.length < 1) {
            return this.getValidateResult(true, null, validateResult);
        }
        long count = Arrays.stream(dys).filter(dy -> HRStringUtils.equals((String)dy.getString("taskstatus"), (String)CoordTaskStatusEnum.TO_BE_EXECUTE.getStatus()) || HRStringUtils.equals((String)dy.getString("taskstatus"), (String)CoordTaskStatusEnum.EXECUTING.getStatus()) || HRStringUtils.equals((String)dy.getString("taskstatus"), (String)CoordTaskStatusEnum.FALSE.getStatus())).count();
        if (count < 1L) {
            return this.getValidateResult(true, null, validateResult);
        }
        String errMsg = ResManager.loadKDString((String)"\u4efb\u52a1\u5b58\u5728\u524d\u7f6e\u4efb\u52a1\uff0c\u8bf7\u5148\u6267\u884c\u524d\u7f6e\u4efb\u52a1\u3002", (String)"CoordinationValidatorDomainService_01", (String)"tsc-tsrbs-business", (Object[])new Object[0]);
        return this.getValidateResult(false, errMsg, validateResult);
    }

    public Map<String, String> checkTaskStatus(DynamicObject taskDy, Map<String, String> validateResult) {
        String taskstatus = taskDy.getString("taskstatus");
        if (HRStringUtils.equals((String)taskstatus, (String)CoordTaskStatusEnum.TO_BE_EXECUTE.getStatus()) || HRStringUtils.equals((String)taskstatus, (String)CoordTaskStatusEnum.FALSE.getStatus())) {
            return this.getValidateResult(true, null, validateResult);
        }
        String errorMsg = ResManager.loadKDString((String)"\u4efb\u52a1\u72b6\u6001\u4ec5\u4e3a\u5f85\u6267\u884c\u6216\u5931\u8d25\u65f6\uff0c\u5141\u8bb8\u624b\u52a8\u6267\u884c\u3002", (String)"CoordinationValidatorDomainService_02", (String)"tsc-tsrbs-business", (Object[])new Object[0]);
        return this.getValidateResult(false, errorMsg, validateResult);
    }

    private Map<String, String> getValidateResult(boolean result, String errorMsg, Map<String, String> validateResult) {
        validateResult.put("result", Boolean.toString(result));
        validateResult.put("errorMsg", errorMsg);
        return validateResult;
    }
}

