/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbs.business.domain.sms.service;

import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.exception.KDBizException;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbs.business.domain.sms.entity.SmsModel;
import kd.tsc.tsrbs.business.domain.sms.service.AbstractSmsService;
import org.apache.commons.lang3.StringUtils;

public class SmsServiceImpl
extends AbstractSmsService {
    private DistributeSessionlessCache redisCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();

    @Override
    public Long sendSms(SmsModel smsModel) {
        if (HRStringUtils.isEmpty((String)smsModel.getPhone())) {
            return 0L;
        }
        if (HRStringUtils.isEmpty((String)smsModel.getContent())) {
            return 0L;
        }
        if (smsModel.getOptUserId() == null) {
            return 0L;
        }
        Long msgId = this.sendMessage(smsModel);
        return msgId;
    }

    @Override
    public Long limitSendSms(SmsModel smsModel) throws KDBizException {
        if (HRStringUtils.isEmpty((String)smsModel.getPhone())) {
            return 0L;
        }
        if (HRStringUtils.isEmpty((String)smsModel.getContent())) {
            return 0L;
        }
        if (smsModel.getOptUserId() == null) {
            return 0L;
        }
        String key = smsModel.getBusKey() + smsModel.getPhone();
        String sendNumer = (String)this.redisCache.get(key);
        if (StringUtils.isNotEmpty((CharSequence)sendNumer) && Long.parseLong(sendNumer) >= (long)smsModel.getMaxSendNumber()) {
            throw new KDBizException("Number of times the maximum limit has been exceeded " + smsModel.getMaxSendNumber());
        }
        if (StringUtils.isEmpty((CharSequence)sendNumer)) {
            this.redisCache.inc(key, smsModel.getTime().intValue(), smsModel.getTimeUnit());
        } else {
            this.setLockTime(smsModel, key, sendNumer);
        }
        Long msgId = this.sendMessage(smsModel);
        return msgId;
    }

    private void setLockTime(SmsModel smsModel, String key, String sendNumer) {
        if (smsModel.getLockTime() == null || smsModel.getLockTimeUnit() == null) {
            this.redisCache.inc(key);
            return;
        }
        if (Long.parseLong(sendNumer) >= (long)(smsModel.getMaxSendNumber() - 1)) {
            this.redisCache.inc(key, smsModel.getLockTime().intValue(), smsModel.getLockTimeUnit());
        } else {
            this.redisCache.inc(key);
        }
    }

    public static enum Singleton {
        INSTANCE;

        private SmsServiceImpl instance = new SmsServiceImpl();

        public SmsServiceImpl getInstance() {
            return this.instance;
        }
    }
}

