/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbs.business.domain.stdrsm.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbs.common.utils.DynamicObjectUtils;
import kd.tsc.tsrbs.common.utils.GenerateFormShowParamUtils;
import kd.tsc.tsrbs.common.utils.PageUtils;

public class StdRsmCommonService {
    private static final Log LOG = LogFactory.getLog(StdRsmCommonService.class);
    private static final String KEY_TALENTPOOLSERVICEAPI = "talentPoolServiceApi";
    private static final String KEY_CANDIDATEIDSWITHRIGHTS = "candidateidswithrights";
    private static final StdRsmCommonService stdRsmCommonService = new StdRsmCommonService();

    public static StdRsmCommonService getInstance() {
        return stdRsmCommonService;
    }

    public void showStandardResumePage(AbstractFormPlugin plugin, Long stdRsmId) {
        FormShowParameter stdResShowParameter = new FormShowParameter();
        String pageId = PageUtils.getPageId((String)String.valueOf(stdRsmId), (String)plugin.getView().getFormShowParameter().getAppId(), (String)"tstpm_candidate_detail", (String)plugin.getView().getFormShowParameter().getRootPageId());
        stdResShowParameter.setPageId(pageId);
        stdResShowParameter.setFormId("tstpm_candidate_detail");
        stdResShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        stdResShowParameter.setCustomParam("id", (Object)stdRsmId);
        plugin.getView().showForm(stdResShowParameter);
    }

    public void selectTalentPool(AbstractFormPlugin plugin, List<Long> listWithoutDuplicates) {
        plugin.getPageCache().put(KEY_CANDIDATEIDSWITHRIGHTS, SerializationUtils.toJsonString(listWithoutDuplicates));
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"tstpm_talentpoolmgt", (boolean)true, (int)0, (boolean)true);
        listShowParameter.setFormId("tstpm_talenttreelistf7");
        listShowParameter.setCaption(ResManager.loadKDString((String)"\u50a8\u5907\u6807\u51c6\u7b80\u5386\u5230\u4eba\u624d\u5e93", (String)"StdRsmCommonService_1", (String)"tsc-tsrbs-bussiness", (Object[])new Object[0]));
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "tstpm_talenttreelistf7"));
        listShowParameter.setCustomParam("pageNumber", (Object)"tstpm_stdrsm");
        listShowParameter.setCustomParam("permissionItem", (Object)"1Y+/5TTR4HPX");
        plugin.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void validateTalentRight(AbstractFormPlugin plugin, List<Long> selectPkIds, String pageNumber, String actionId) {
        String resultStr = (String)DispatchServiceHelper.invokeBizService((String)"tsc", (String)"tstpm", (String)KEY_TALENTPOOLSERVICEAPI, (String)"checkPermission", (Object[])new Object[]{selectPkIds, "savetalent", pageNumber});
        LOG.info("validateTalentRight.params:{},{},{}", new Object[]{selectPkIds, pageNumber, resultStr});
        if (HRStringUtils.isNotEmpty((String)resultStr)) {
            Map result = (Map)SerializationUtils.fromJsonString((String)resultStr, Map.class);
            Boolean isSuccess = (Boolean)result.get("flag");
            String titleMsg = (String)result.get("titleMsg");
            String errorMsgTotal = (String)result.get("errorMsgTotal");
            Integer errorMsgNum = (Integer)result.get("errorMsgNum");
            List<Long> candidateIds = ((List)result.get("candidateIds")).stream().map(obj -> Long.valueOf(obj.toString())).collect(Collectors.toList());
            if (!isSuccess.booleanValue()) {
                String operateName = ResManager.loadKDString((String)"\u50a8\u5907\u5230\u4eba\u624d\u5e93", (String)"", (String)"", (Object[])new Object[0]);
                if (!candidateIds.isEmpty()) {
                    FormShowParameter parameters = new FormShowParameter();
                    parameters.getOpenStyle().setShowType(ShowType.Modal);
                    parameters.setFormId("tspr_appfileopresult");
                    parameters.setShowTitle(false);
                    parameters.setCustomParam("operateName", (Object)operateName);
                    Map<Object, Object> pkNumbers = candidateIds.stream().collect(Collectors.toMap(pkId -> pkId, obj -> obj));
                    parameters.setCustomParam("pkNumbers", pkNumbers);
                    parameters.setCustomParam("successPkIds", candidateIds);
                    parameters.setCustomParam("title", (Object)titleMsg);
                    parameters.setCustomParam("hasMore", (Object)Boolean.FALSE);
                    parameters.setCustomParam("errorMsg", (Object)errorMsgTotal);
                    parameters.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, actionId));
                    plugin.getView().showForm(parameters);
                } else if (errorMsgNum == 1) {
                    plugin.getView().showErrorNotification(titleMsg);
                } else {
                    FormShowParameter formShowParameter = GenerateFormShowParamUtils.generateBosOperationResultFormShowParam((Object)titleMsg, (Object)errorMsgTotal, (boolean)false);
                    plugin.getView().showForm(formShowParameter);
                }
            } else {
                this.selectTalentPool(plugin, candidateIds);
            }
        } else {
            String noRightTip = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8be5\u6807\u51c6\u7b80\u5386\u7684\u67e5\u770b\u6743\u9650", (String)"StdRsmCommonService_0", (String)"tsc-tsrbs-bussiness", (Object[])new Object[0]);
            plugin.getView().showErrorNotification(noRightTip);
        }
    }

    public void saveTalent(AbstractFormPlugin plugin, ListSelectedRowCollection listSelectedRows) {
        List candidateIds = (List)SerializationUtils.fromJsonString((String)plugin.getPageCache().get(KEY_CANDIDATEIDSWITHRIGHTS), List.class);
        ArrayList<Long> talentPoolIds = new ArrayList<Long>(listSelectedRows.size());
        for (ListSelectedRow listSelectedRow : listSelectedRows) {
            Long talentPoolId = (Long)listSelectedRow.getPrimaryKeyValue();
            talentPoolIds.add(talentPoolId);
        }
        String resultStr = (String)DispatchServiceHelper.invokeBizService((String)"tsc", (String)"tstpm", (String)KEY_TALENTPOOLSERVICEAPI, (String)"saveReserveRecord", (Object[])new Object[]{talentPoolIds, candidateIds});
        LOG.info("saveTalent.params:{},{},{}", new Object[]{candidateIds, talentPoolIds, resultStr});
        if (HRStringUtils.isNotEmpty((String)resultStr)) {
            Map result = (Map)SerializationUtils.fromJsonString((String)resultStr, Map.class);
            Boolean isSuccess = (Boolean)result.get("flag");
            String titleMsg = (String)result.get("titleMsg");
            String errorMsgTotal = (String)result.get("errorMsgTotal");
            if (isSuccess.booleanValue()) {
                plugin.getView().showSuccessNotification(titleMsg);
            } else if (HRStringUtils.isNotEmpty((String)errorMsgTotal)) {
                FormShowParameter formShowParameter = GenerateFormShowParamUtils.generateBosOperationResultFormShowParam((Object)titleMsg, (Object)errorMsgTotal, (boolean)false);
                plugin.getView().showForm(formShowParameter);
            } else {
                plugin.getView().showTipNotification(titleMsg);
            }
        }
    }

    public Map<Long, String> getStdRsmDataStatus(Collection<Long> stdRsmIds) {
        HRBaseServiceHelper stdRsmHelper = new HRBaseServiceHelper("tstpm_stdrsm");
        QFilter qFilter = new QFilter("id", "in", stdRsmIds);
        DynamicObjectCollection stdRsms = stdRsmHelper.queryOriginalCollection("id,mid", qFilter.toArray());
        DynamicObjectCollection mainstdRsms = stdRsmHelper.queryOriginalCollection("id,datastatus", new QFilter[]{new QFilter("id", "in", stdRsms.stream().map(dyo -> dyo.getLong("mid")).collect(Collectors.toList()))});
        Map objectDynamicObjectMap = DynamicObjectUtils.dyoCollToMap((Collection)mainstdRsms, (String)"id");
        return stdRsms.stream().collect(Collectors.toMap(dyo -> dyo.getLong("id"), dyo -> {
            DynamicObject dynamicObject = (DynamicObject)objectDynamicObjectMap.get(dyo.getLong("mid"));
            return dynamicObject != null ? dynamicObject.getString("datastatus") : "";
        }));
    }
}

