/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbs.business.domain.synrecord;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.utils.DynamicObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.business.application.external.org.BizOrgUnitService;
import kd.tsc.tsrbd.common.utils.DateUtils;
import kd.tsc.tsrbs.business.domain.foreignadminorg.ForeignAdminOrgHelper;
import kd.tsc.tsrbs.business.domain.foreignadminorg.ForeignSynAdminOrgHelper;
import kd.tsc.tsrbs.business.domain.foreignadminorg.datasync.mk.OperationType;
import kd.tsc.tsrbs.common.enums.foreignadminorg.ForeignOrgSynStatusEnum;

public class SynRecordService {
    private static final HRBaseServiceHelper helper = new HRBaseServiceHelper("tsrbs_synrecordobj");
    private static final ForeignSynAdminOrgHelper SYNADMINORGHELPER = ForeignSynAdminOrgHelper.Singleton.INSTANCE.getInstance();
    private static final Log LOG = LogFactory.getLog(SynRecordService.class);

    public static String getTenantNameById(Long id) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrsc_partner_tenant");
        DynamicObject result = serviceHelper.queryOne("name", new QFilter[]{new QFilter("id", "=", (Object)id)});
        return result == null ? "" : result.getString("name");
    }

    public static String getSystemNameByTenantId(Long id) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrsc_partner_tenant");
        DynamicObject result = serviceHelper.queryOne("partner", new QFilter[]{new QFilter("id", "=", (Object)id)});
        return result == null ? "" : result.getString("partner");
    }

    public static String getTenantNameByRecordId(Long id) {
        DynamicObject recordObj = helper.loadDynamicObject(new QFilter("id", "=", (Object)id));
        return SynRecordService.getTenantNameById(recordObj.getLong("syntenant"));
    }

    public static List<Long> getSynRecordObjIds() {
        DynamicObject[] resules = helper.query("id", null, "opdate desc");
        return Arrays.stream(resules).map(dy -> dy.getLong("id")).collect(Collectors.toList());
    }

    public static List<Long> getSynRecordObjIds(Long id) {
        DynamicObject[] resules = helper.query("id", new QFilter[]{new QFilter("bizobj", "=", (Object)id)}, "opdate desc");
        return Arrays.stream(resules).map(dy -> dy.getLong("id")).collect(Collectors.toList());
    }

    public static Map<Long, DynamicObject> getSynRecordObjByBizId(List<Long> bizIds) {
        Map<Object, Object> groupResults;
        QFilter qFilter = new QFilter("bizobj", "in", bizIds);
        DynamicObject[] results = helper.loadDynamicObjectArray(new QFilter[]{qFilter});
        HashMap<Long, DynamicObject> sortResults = new HashMap<Long, DynamicObject>(bizIds.size());
        if (results == null || results.length == 0) {
            return sortResults;
        }
        if (bizIds.size() == 1) {
            groupResults = new HashMap<Long, List<DynamicObject>>(1);
            groupResults.put(bizIds.get(0), Arrays.asList(results));
        } else {
            groupResults = Arrays.stream(results).collect(Collectors.groupingBy(dyn -> dyn.getDynamicObject("bizobj").getLong("id")));
        }
        groupResults.forEach((key, value) -> {
            List sortResult = value.stream().sorted(Comparator.comparing(dyn -> dyn.getDate("opdate"))).collect(Collectors.toList());
            sortResults.put((Long)key, (DynamicObject)sortResult.get(sortResult.size() - 1));
        });
        return sortResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void afterChangeRootNode(DynamicObject oldValue, Object newValue, Long tenantId) {
        try (TXHandle tx = TX.required();){
            if (null == newValue) {
                SynRecordService.deleteBindData(tenantId);
            } else {
                if (oldValue.getLong("id") == ((DynamicObject)newValue).getLong("id")) {
                    return;
                }
                SynRecordService.updateBindData(tenantId, ((DynamicObject)newValue).getLong("id"));
                SynRecordService.saveSynRecordObjWithNewOp((DynamicObject)newValue, tenantId);
            }
            List<DynamicObject> childNode = SynRecordService.getChildNode(oldValue.getString("longnumber"), false);
            SynRecordService.deleteSynRecord(childNode.stream().map(dyn -> dyn.getLong("id")).collect(Collectors.toList()), tenantId);
            SynRecordService.updateSynRecordListStatus(childNode);
            SynRecordService.deleteSyndAdminOrg(tenantId);
        }
    }

    public static String getSynRecordObjNumById(Long bizId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbs_foreignadminorg");
        DynamicObject result = serviceHelper.loadDynamicObject(new QFilter("id", "=", (Object)bizId));
        if (null != result) {
            return result.getString("number");
        }
        return "";
    }

    public static void saveSynRecordObjWithNewOp(DynamicObject bizObj, Long tenantId) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(16);
        String longnumber = bizObj.getString("longnumber");
        List<DynamicObject> childNode = SynRecordService.getChildNode(longnumber, true);
        for (DynamicObject dyn : childNode) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"tsrbs_synrecordobj");
            dynamicObject.set("bizobj", (Object)dyn);
            dynamicObject.set("optype", (Object)"1");
            dynamicObject.set("operator", (Object)RequestContext.get().getCurrUserId());
            dynamicObject.set("opdate", (Object)DateUtils.nowDateTime());
            dynamicObject.set("status", (Object)"1");
            dynamicObject.set("synstatus", (Object)"1");
            dynamicObject.set("synsystem", (Object)SynRecordService.getSystemNameByTenantId(tenantId));
            dynamicObject.set("syntenant", (Object)tenantId.toString());
            dynamicObject.set("adminorgname", (Object)dyn.getString("name"));
            dynamicObject.set("parentnumber", (Object)dyn.getString("parent.number"));
            list.add(dynamicObject);
        }
        helper.save(list.toArray(new DynamicObject[0]));
        SynRecordService.updateSynRecordListStatus(childNode);
    }

    public static void saveSynRecordObj(List<DynamicObject> bizObj, String opType) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(16);
        List<String> collect = bizObj.stream().map(dyn -> dyn.getString("longnumber")).collect(Collectors.toList());
        List<DynamicObject> dynamicObjects = SynRecordService.judgeRoot(collect);
        for (DynamicObject bizobj : bizObj) {
            if (dynamicObjects.size() == 0) {
                return;
            }
            for (DynamicObject dyn2 : dynamicObjects) {
                if (!SynRecordService.isCreateSynRecord(bizobj, dyn2.getString("partnertenant"), opType)) continue;
                DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"tsrbs_synrecordobj");
                dynamicObject.set("bizobj", (Object)bizobj);
                dynamicObject.set("optype", (Object)opType);
                dynamicObject.set("operator", (Object)RequestContext.get().getCurrUserId());
                dynamicObject.set("opdate", (Object)DateUtils.nowDateTime());
                dynamicObject.set("status", (Object)"1");
                dynamicObject.set("synstatus", (Object)opType);
                dynamicObject.set("synsystem", (Object)SynRecordService.getSystemNameByTenantId(Long.valueOf(dyn2.getString("partnertenant"))));
                dynamicObject.set("syntenant", (Object)dyn2.getString("partnertenant"));
                dynamicObject.set("adminorgname", (Object)bizobj.getString("name"));
                dynamicObject.set("parentnumber", (Object)bizobj.getString("parent.number"));
                list.add(dynamicObject);
            }
        }
        if (list.size() == 0) {
            return;
        }
        helper.save(list.toArray(new DynamicObject[0]));
        if (HRStringUtils.isNotEmpty((String)opType)) {
            if (HRStringUtils.equals((String)OperationType.INSERT.code, (String)opType) || HRStringUtils.equals((String)OperationType.UPDATE.code, (String)opType)) {
                SynRecordService.updateAdminOrgStatus(bizObj);
            } else {
                SynRecordService.updateSynRecordListStatus(bizObj);
            }
        }
    }

    private static boolean isCreateSynRecord(DynamicObject org, String tenantId, String opType) {
        if (org == null || HRStringUtils.isEmpty((String)tenantId) || HRStringUtils.isEmpty((String)opType)) {
            return false;
        }
        if (HRStringUtils.equals((String)"1", (String)org.getString("enable")) || !HRStringUtils.equals((String)OperationType.UPDATE.code, (String)opType)) {
            return true;
        }
        QFilter tenantFilter = new QFilter("syntenant", "=", (Object)tenantId);
        QFilter statusFilter = new QFilter("status", "=", (Object)"1");
        QFilter idFilter = new QFilter("bizobj", "=", (Object)org.getLong("id"));
        return helper.isExists(new QFilter[]{tenantFilter, statusFilter, idFilter});
    }

    public static List<DynamicObject> getChildNode(String number, boolean filterDisable) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbs_foreignadminorg");
        QFilter QFilter2 = new QFilter("longnumber", "like", (Object)(number + "%"));
        if (filterDisable) {
            QFilter2.and(new QFilter("enable", "=", (Object)"1"));
        }
        DynamicObject[] objects = serviceHelper.loadDynamicObjectArray(new QFilter[]{QFilter2});
        List<DynamicObject> dynamicObjects = Arrays.stream(objects).sorted(Comparator.comparing(dynamicObj -> dynamicObj.getString("longnumber"))).collect(Collectors.toList());
        return dynamicObjects;
    }

    public static List<DynamicObject> getAdminOrgByIds(List<Long> ids) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbs_foreignadminorg");
        QFilter qFilter = new QFilter("id", "in", ids);
        DynamicObject[] objects = serviceHelper.loadDynamicObjectArray(new QFilter[]{qFilter});
        return Arrays.asList(objects);
    }

    public static List<DynamicObject> judgeRoot(List<String> number) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbs_bindextternalorg");
        DynamicObject[] result = serviceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("enable", "=", (Object)"1")});
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(16);
        for (String num : number) {
            for (DynamicObject dyn : result) {
                String longnumber = dyn.getDynamicObject("oreignadminorg").getString("longnumber");
                if (!num.startsWith(longnumber) || list.contains(dyn)) continue;
                list.add(dyn);
            }
        }
        return list;
    }

    public static void updateSynRecordListStatus(List<DynamicObject> bizObj) {
        SynRecordService.updateAdminOrgStatus(bizObj);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbs_foreignadminorg");
        serviceHelper.update(bizObj.toArray(new DynamicObject[0]));
    }

    private static void updateAdminOrgStatus(List<DynamicObject> bizObj) {
        Map<Long, DynamicObject> synRecordObjByBizId = SynRecordService.getSynRecordObjByBizId(bizObj.stream().map(obj -> obj.getLong("id")).collect(Collectors.toList()));
        for (DynamicObject bizobj : bizObj) {
            DynamicObject recordObj = synRecordObjByBizId.get(bizobj.getLong("id"));
            if (null == recordObj) {
                bizobj.set("lastestsyncstatus", null);
                continue;
            }
            String synstatus = recordObj.getString("synstatus");
            bizobj.set("lastestsyncstatus", (Object)synstatus);
        }
    }

    public static List<DynamicObject> getNotSynRecordObjList(Long tenantId) {
        DynamicObject[] recordObj = helper.query("id,bizobj,optype,syntenant,synsystem,syndate,synoperator,synstatus,status,opdate,operator,adminorgname,parentnumber", new QFilter[]{new QFilter("syntenant", "=", (Object)tenantId.toString()).and(new QFilter("synstatus", "!=", (Object)ForeignOrgSynStatusEnum.SYN_SUCCESS.code)).and(new QFilter("status", "=", (Object)"1"))}, " opdate asc");
        return Arrays.asList(recordObj);
    }

    public static void updateSynRecordObj(List<DynamicObject> recordObj) {
        helper.update(recordObj.toArray(new DynamicObject[0]));
        List<DynamicObject> collect = recordObj.stream().map(dyn -> dyn.getDynamicObject("bizobj")).collect(Collectors.toList());
        SynRecordService.updateSynRecordListStatus(collect);
    }

    public static void createSynRecordObj(List<DynamicObject> bizObj, String opType) {
        SynRecordService.saveSynRecordObj(bizObj, opType);
    }

    public static DynamicObject[] getBindDataByAdminOrgId(Long id) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbs_bindextternalorg");
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("oreignadminorg", "=", (Object)id)});
    }

    public static String getBingDataSynStatus(Long tenantId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbs_bindextternalorg");
        DynamicObject result = serviceHelper.loadDynamicObject(new QFilter("partnertenant", "=", (Object)tenantId.toString()));
        return result.getString("synchstatus");
    }

    public static DynamicObject getAdminOrgIdByTenantId(Long tenantId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbs_bindextternalorg");
        DynamicObject result = serviceHelper.loadDynamicObject(new QFilter("partnertenant", "=", (Object)tenantId.toString()));
        return result.getDynamicObject("oreignadminorg");
    }

    public static int countSyndAdminOrg(String longNumber, Long id) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbs_synadminorg");
        QFilter QFilter2 = new QFilter("longnumber", "like", (Object)(longNumber + "%"));
        QFilter2.and("tenantid", "=", (Object)id.toString());
        return serviceHelper.query("id", new QFilter[]{QFilter2}).length;
    }

    public static void updateBindData(Long tenantId, Long adminOrgId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbs_bindextternalorg");
        DynamicObject result = serviceHelper.loadDynamicObject(new QFilter("partnertenant", "=", (Object)tenantId.toString()));
        result.set("oreignadminorg", (Object)adminOrgId);
        serviceHelper.updateOne(result);
    }

    public static void deleteBindData(Long tenantId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbs_bindextternalorg");
        serviceHelper.deleteByFilter(new QFilter[]{new QFilter("partnertenant", "=", (Object)tenantId.toString())});
    }

    public static void deleteSynRecord(List<Long> adminOrgId, Long tenantId) {
        DynamicObject[] results;
        ArrayList<String> list = new ArrayList<String>(2);
        list.add(ForeignOrgSynStatusEnum.SYN_SUCCESS.code);
        list.add(ForeignOrgSynStatusEnum.SYN_FAILED.code);
        helper.deleteByFilter(new QFilter[]{new QFilter("bizobj", "in", adminOrgId).and(new QFilter("syntenant", "=", (Object)tenantId.toString())).and(new QFilter("synstatus", "not in", list))});
        for (DynamicObject result : results = helper.loadDynamicObjectArray(new QFilter[]{new QFilter("bizobj", "in", adminOrgId).and(new QFilter("syntenant", "=", (Object)tenantId.toString())).and(new QFilter("synstatus", "in", list))})) {
            result.set("status", (Object)"2");
        }
        helper.update(results);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void synCallbackUpdate(DynamicObject partnerTenantObj, List<DynamicObject> synRecordList, DynamicObject bindTenantOb) {
        boolean exitNewData = false;
        ArrayList<DynamicObject> descSynRecordList = new ArrayList<DynamicObject>(synRecordList.size());
        descSynRecordList.addAll(synRecordList);
        List<DynamicObject> copySynRecordList = descSynRecordList.stream().filter(synRecordObj -> ForeignOrgSynStatusEnum.SYN_SUCCESS.code.equals(synRecordObj.getString("synstatus"))).collect(Collectors.toList());
        DynamicObject[] synAdminOrgLis = SynRecordService.getSynAdminOrgList(partnerTenantObj, copySynRecordList, bindTenantOb);
        List<DynamicObject> buildSynAdminOrgList = SynRecordService.buildSynAdminOrgList(partnerTenantObj, copySynRecordList, synAdminOrgLis);
        try (TXHandle tx = TX.required();){
            SynRecordService.updateSynRecordObj(synRecordList);
            if (synAdminOrgLis.length > 0) {
                SYNADMINORGHELPER.update(synAdminOrgLis);
            }
            if (buildSynAdminOrgList.size() > 0) {
                SYNADMINORGHELPER.save(buildSynAdminOrgList.toArray(new DynamicObject[0]));
                exitNewData = true;
            }
        }
        if (exitNewData) {
            DynamicObject[] alreadySynRecordList = SYNADMINORGHELPER.queryByTenantIdAndFullName(partnerTenantObj, copySynRecordList);
            HashMap maps = Maps.newHashMapWithExpectedSize((int)alreadySynRecordList.length);
            for (DynamicObject dynamicObject2 : alreadySynRecordList) {
                maps.put(dynamicObject2.getString("number"), dynamicObject2.getLong("id"));
            }
            for (DynamicObject dynamicObject3 : buildSynAdminOrgList) {
                Long rootOrgId = maps.get(dynamicObject3.getParent().toString()) == null ? Long.valueOf(BizOrgUnitService.getRootOrgId()) : (Long)maps.get(dynamicObject3.getParent().toString());
                dynamicObject3.set("parent", (Object)rootOrgId);
            }
            SYNADMINORGHELPER.update(buildSynAdminOrgList.toArray(new DynamicObject[0]));
            List<DynamicObject> waitUpdateParentObjList = Arrays.stream(synAdminOrgLis).filter(dynamicObject -> dynamicObject.get("parent") == null).collect(Collectors.toList());
            LOG.info("synCallbackUpdate waitUpdateParentObjList: {}", waitUpdateParentObjList);
            waitUpdateParentObjList.forEach(dynamicObject -> {
                Long parentId = (Long)maps.get(dynamicObject.getParent().toString());
                dynamicObject.set("parent", (Object)parentId);
            });
            if (waitUpdateParentObjList.size() > 0) {
                SYNADMINORGHELPER.update(waitUpdateParentObjList.toArray(new DynamicObject[0]));
            }
        }
    }

    private static List<DynamicObject> buildSynAdminOrgList(DynamicObject partnerTenantObj, List<DynamicObject> copySynRecordList, DynamicObject[] synAdminOrgLis) {
        ArrayList<Object> buildSynAdminList = new ArrayList<DynamicObject>(copySynRecordList.size());
        HashMap synRecordMap = Maps.newHashMapWithExpectedSize((int)copySynRecordList.size());
        DynamicObject[] synRecordList = SYNADMINORGHELPER.queryByTenantIdAndFullName(partnerTenantObj, copySynRecordList);
        Map synAdminNumberMap = Arrays.stream(synRecordList).collect(Collectors.toMap(obj -> obj.getString("number"), Function.identity(), (n1, n2) -> n1));
        List collect = copySynRecordList.stream().map(obj -> obj.getString("parentnumber")).collect(Collectors.toList());
        QFilter filter = new QFilter("number", "in", collect);
        DynamicObject[] query = ForeignAdminOrgHelper.getAdminOrgHelper().query("number,longnumber", new QFilter[]{filter});
        Map adminOrgMap = Arrays.stream(query).collect(Collectors.toMap(obj -> obj.getString("number"), Function.identity(), (n1, n2) -> n1));
        Map synAdminOrgMap = Arrays.stream(synAdminOrgLis).collect(Collectors.toMap(obj -> obj.getString("number"), Function.identity(), (n1, n2) -> n1));
        for (DynamicObject synRecordObj : copySynRecordList) {
            DynamicObject parentInfo;
            DynamicObject bizObj = synRecordObj.getDynamicObject("bizobj");
            DynamicObject synAdminOrgObj = BusinessDataServiceHelper.newDynamicObject((String)"tsrbs_synadminorg");
            if (synRecordMap.containsKey(bizObj.getString("number"))) {
                synAdminOrgObj = (DynamicObject)synRecordMap.get(bizObj.getString("number"));
            } else {
                DynamicObjectUtils.copy((DynamicObject)bizObj, (DynamicObject)synAdminOrgObj);
                synAdminOrgObj.set("id", null);
            }
            synAdminOrgObj.set("parent", null);
            String parentNumber = synRecordObj.getString("parentnumber");
            synAdminOrgObj.setParent((Object)parentNumber);
            synAdminOrgObj.set("name", (Object)synRecordObj.getString("adminorgname"));
            if (synAdminOrgMap.size() > 0 && synAdminOrgMap.containsKey(parentNumber)) {
                synAdminOrgObj.set("longnumber", (Object)(((DynamicObject)synAdminOrgMap.get(parentNumber)).getString("longnumber") + "." + bizObj.getString("number")));
            } else if (synAdminNumberMap.size() > 0 && synAdminNumberMap.containsKey(parentNumber)) {
                synAdminOrgObj.set("longnumber", (Object)(((DynamicObject)synAdminNumberMap.get(parentNumber)).getString("longnumber") + "." + bizObj.getString("number")));
            } else if (adminOrgMap.containsKey(parentNumber) && (parentInfo = (DynamicObject)adminOrgMap.get(parentNumber)) != null) {
                synAdminOrgObj.set("longnumber", (Object)(parentInfo.getString("longnumber") + "." + bizObj.getString("number")));
            }
            synAdminOrgObj.set("tenantid", partnerTenantObj.getPkValue());
            synRecordMap.put(synAdminOrgObj.getString("number"), synAdminOrgObj);
        }
        if (synRecordMap.size() > 0) {
            buildSynAdminList = new ArrayList(synRecordMap.values());
        }
        return buildSynAdminList;
    }

    private static DynamicObject[] getSynAdminOrgList(DynamicObject partnerTenantObj, List<DynamicObject> copySynRecordList, DynamicObject bindTenantOb) {
        DynamicObject[] synRecordList = SYNADMINORGHELPER.queryByTenantIdAndFullName(partnerTenantObj, copySynRecordList);
        if (synRecordList == null || synRecordList.length == 0) {
            return new DynamicObject[0];
        }
        List<DynamicObject> alreadyObjList = SynRecordService.updateSynAdminOrg(copySynRecordList, synRecordList, bindTenantOb);
        SynRecordService.deleteExitSynAdmin(copySynRecordList, alreadyObjList);
        return synRecordList;
    }

    private static List<DynamicObject> updateSynAdminOrg(List<DynamicObject> copySynRecordList, DynamicObject[] synRecordList, DynamicObject bindTenantOb) {
        Map<String, List<Map<String, DynamicObject>>> numberMap = copySynRecordList.stream().collect(Collectors.toMap(synRecordObj -> synRecordObj.getDynamicObject("bizobj").getString("number"), syn -> {
            ArrayList<Map<String, DynamicObject>> list = new ArrayList<Map<String, DynamicObject>>();
            list.add(Collections.singletonMap(syn.getString("optype"), syn));
            return list;
        }, (n1, n2) -> {
            n1.addAll(n2);
            return n1;
        }));
        DynamicObject[] childrenOrgList = ForeignAdminOrgHelper.getChildrenOrgList(bindTenantOb.getDynamicObject("oreignadminorg").getString("longnumber"));
        Map<String, DynamicObject> childrenOrgNumberMap = Arrays.stream(childrenOrgList).collect(Collectors.toMap(synRecordObj -> synRecordObj.getString("number"), Function.identity(), (n1, n2) -> n1));
        Map<String, DynamicObject> synAdminNumberMap = Arrays.stream(synRecordList).collect(Collectors.toMap(synRecordObj -> synRecordObj.getString("number"), Function.identity(), (n1, n2) -> n1));
        ArrayList<DynamicObject> alreadyObjList = new ArrayList<DynamicObject>(copySynRecordList.size());
        for (DynamicObject dynamicObject : copySynRecordList) {
            SynRecordService.setDynamicProperties(numberMap, synAdminNumberMap, dynamicObject, alreadyObjList, childrenOrgNumberMap, synRecordList);
        }
        return alreadyObjList;
    }

    private static void setDynamicProperties(Map<String, List<Map<String, DynamicObject>>> numberMap, Map<String, DynamicObject> synAdminNumberMap, DynamicObject waitDynamicObject, List<DynamicObject> alreadyObjList, Map<String, DynamicObject> childrenOrgNumberMap, DynamicObject[] synRecordList) {
        DynamicObject waitSynObj = waitDynamicObject.getDynamicObject("bizobj");
        DynamicObject alreadyObj = synAdminNumberMap.get(waitSynObj.getString("number"));
        if (alreadyObj == null) {
            return;
        }
        alreadyObjList.add(alreadyObj);
        List<Map<String, DynamicObject>> synRecords = numberMap.get(waitSynObj.getString("number"));
        block5: for (Map<String, DynamicObject> synRecordMap : synRecords) {
            String opType = synRecordMap.entrySet().iterator().next().getKey();
            DynamicObject synRecord = synRecordMap.entrySet().iterator().next().getValue();
            if (OperationType.getOperationType(opType) == null) {
                return;
            }
            switch (OperationType.getOperationType(opType)) {
                case UPDATE: {
                    alreadyObj.set("name", synRecord.get("adminorgname"));
                    alreadyObj.set("establishmentdate", synRecord.getDynamicObject("bizobj").get("establishmentdate"));
                    DynamicObject parentObj = synAdminNumberMap.get(synRecord.getString("parentnumber"));
                    alreadyObj.set("parent", (Object)parentObj);
                    if (parentObj == null) {
                        alreadyObj.setParent((Object)synRecord.getString("parentnumber"));
                        alreadyObj.set("longnumber", synRecord.getDynamicObject("bizobj").get("longnumber"));
                        if (alreadyObj.getString("longnumber").equals(synRecord.getDynamicObject("bizobj").getString("longnumber"))) break;
                        SynRecordService.setChildrenLongNumber(synRecordList, childrenOrgNumberMap, alreadyObj.getString("number"));
                        break;
                    }
                    String newLongNumber = parentObj.getString("longnumber") + "." + alreadyObj.getString("number");
                    if (alreadyObj.getString("longnumber").equals(newLongNumber)) continue block5;
                    alreadyObj.set("longnumber", (Object)newLongNumber);
                    SynRecordService.setChildrenLongNumber(synRecordList, newLongNumber, alreadyObj.getString("number"));
                    break;
                }
                case FORBIDDEN: {
                    alreadyObj.set("enable", (Object)"0");
                    break;
                }
                case START_USING: {
                    alreadyObj.set("enable", (Object)"1");
                }
            }
        }
    }

    public static void setChildrenLongNumber(DynamicObject[] synRecordList, String newLongNumber, String keyLike) {
        LOG.info("setChildrenLongNumber newLongNumber:{}, keyLike:{}", (Object)newLongNumber, (Object)keyLike);
        for (DynamicObject dynamicObject : synRecordList) {
            String longNumber = dynamicObject.getString("longnumber");
            if (longNumber == null || !longNumber.contains(keyLike)) continue;
            LOG.info("setChildrenLongNumber longNumber:{}", (Object)longNumber);
            String beforeSub = longNumber.substring(0, longNumber.indexOf(keyLike));
            String childLongNumber = longNumber.substring(beforeSub.length() + keyLike.length());
            LOG.info("setChildrenLongNumber longNumber:{}, beforeSub:{}, childLongNumber:{}", new Object[]{longNumber, beforeSub, childLongNumber});
            if (!HRStringUtils.isNotEmpty((String)childLongNumber)) continue;
            dynamicObject.set("longnumber", (Object)(newLongNumber + childLongNumber));
        }
    }

    public static void setChildrenLongNumber(DynamicObject[] synRecordList, Map<String, DynamicObject> childrenOrgNumberMap, String keyLike) {
        for (DynamicObject dynamicObject : synRecordList) {
            DynamicObject newOrgAdmin;
            if (!dynamicObject.getString("longnumber").contains(keyLike) || (newOrgAdmin = childrenOrgNumberMap.get(dynamicObject.getString("number"))) == null) continue;
            dynamicObject.set("longnumber", (Object)newOrgAdmin.getString("longnumber"));
        }
    }

    private static void deleteExitSynAdmin(List<DynamicObject> copySynRecordList, List<DynamicObject> synRecordList) {
        Map<String, String> fullNameMap = synRecordList.stream().collect(Collectors.toMap(synRecordObj -> synRecordObj.getString("number"), synRecordObj -> synRecordObj.getString("number"), (n1, n2) -> n1));
        copySynRecordList.removeIf(next -> fullNameMap.containsKey(next.getDynamicObject("bizobj").getString("number")));
    }

    public static void deleteSyndAdminOrg(Long tenantId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("tsrbs_synadminorg");
        helper.deleteByFilter(new QFilter[]{new QFilter("tenantid", "=", (Object)tenantId.toString())});
    }

    public static DynamicObject getTenantById(Long id) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrsc_partner_tenant");
        return serviceHelper.loadDynamicObject(new QFilter("id", "=", (Object)id));
    }

    public static String getTenantStatusById(Long id) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrsc_partner_tenant");
        DynamicObject result = serviceHelper.queryOne("enable", new QFilter("id", "=", (Object)id));
        return result.getString("enable");
    }

    public static boolean getWaitSynDateByTenantId(Long tenantId) {
        QFilter tenantFilter = new QFilter("syntenant", "=", (Object)tenantId.toString());
        QFilter statusFilter = new QFilter("status", "=", (Object)"1");
        QFilter synStatusFilter = new QFilter("synstatus", "in", Arrays.asList(ForeignOrgSynStatusEnum.NEW_ADD_NO_SYN.code, ForeignOrgSynStatusEnum.CHANGE_NO_SYN.code, ForeignOrgSynStatusEnum.START_NO_SYN.code, ForeignOrgSynStatusEnum.FORBIDDEN_NO_SYN.code, ForeignOrgSynStatusEnum.SYN_FAILED.code));
        return helper.isExists(new QFilter[]{tenantFilter, statusFilter, synStatusFilter});
    }

    public static QFilter getNotSynIdsFilter(Long tenantId) {
        QFilter statusFilter;
        if (tenantId == null) {
            return null;
        }
        QFilter tenantFilter = new QFilter("syntenant", "=", (Object)tenantId.toString());
        DynamicObject[] query = helper.query("bizobj", new QFilter[]{tenantFilter, statusFilter = new QFilter("status", "=", (Object)"1")});
        if (query != null && query.length > 0) {
            Set orgIds = Arrays.stream(query).map(dy -> dy.getDynamicObject("bizobj").getLong("id")).collect(Collectors.toSet());
            return new QFilter("id", "in", orgIds);
        }
        return null;
    }
}

