/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbs.business.domain.workflow.service;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import java.util.Map;
import java.util.Optional;
import kd.bos.service.ServiceFactory;
import kd.bos.workflow.api.IWorkflowService;
import kd.bos.workflow.engine.dynprocess.freeflow.WFBillSetting;
import kd.bos.workflow.engine.dynprocess.freeflow.WFParticipantModel;
import kd.bos.workflow.engine.dynprocess.freeflow.WFProcess;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbs.business.domain.workflow.entity.WFAuditInfo;
import kd.tsc.tsrbs.business.domain.workflow.entity.WFUserInfo;
import kd.tsc.tsrbs.business.domain.workflow.service.FreeFlowInterface;
import net.sf.cglib.beans.BeanCopier;
import net.sf.cglib.core.Converter;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FreeFlowAbstract
implements FreeFlowInterface {
    private static final Logger log = LoggerFactory.getLogger(FreeFlowAbstract.class);

    public WFParticipantModel getWfParticipantModel(WFUserInfo wfUser) {
        WFParticipantModel participantModel = new WFParticipantModel();
        BeanCopier.create(WFUserInfo.class, WFParticipantModel.class, (boolean)false).copy((Object)wfUser, (Object)participantModel, (Converter)wfUser);
        return participantModel;
    }

    public WFBillSetting getWfBillSetting(WFAuditInfo wfAudit) {
        WFBillSetting billSetting = new WFBillSetting();
        BeanCopier.create(WFAuditInfo.class, WFBillSetting.class, (boolean)false).copy((Object)wfAudit, (Object)billSetting, (Converter)wfAudit);
        return billSetting;
    }

    @Override
    public void startFreeFlow(String entityName, String businessKey, WFProcess wfProcess, String operation, Map<String, Object> variables) {
        if (HRStringUtils.isEmpty((String)entityName)) {
            return;
        }
        if (HRStringUtils.isEmpty((String)businessKey)) {
            return;
        }
        if (wfProcess == null) {
            return;
        }
        if (HRStringUtils.isEmpty((String)operation)) {
            return;
        }
        try {
            Map variableMap = Optional.ofNullable(variables).orElseGet(() -> Maps.newHashMap());
            IWorkflowService workflowService = (IWorkflowService)ServiceFactory.getService(IWorkflowService.class);
            StopWatch watch = new StopWatch();
            watch.start();
            workflowService.createProcessAndStart(businessKey, operation, entityName, variableMap, wfProcess);
            watch.stop();
            log.info("\u3010FreeFlowAbstract\u3011print start work flow time \"{}\" second", (Object)(watch.getTime() / 1000L));
        }
        catch (Exception e) {
            Gson gson = new Gson();
            log.error("\u542f\u52a8\u81ea\u7531\u6d41\u62a5\u9519-\u539f\u56e0:{}", (Object)gson.toJson((Object)e));
        }
    }
}

