/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbs.business.domain.workflow.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.lang.Lang;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.engine.dynprocess.freeflow.WFAuditTask;
import kd.bos.workflow.engine.dynprocess.freeflow.WFAutoTask;
import kd.bos.workflow.engine.dynprocess.freeflow.WFAutoTaskExtItf;
import kd.bos.workflow.engine.dynprocess.freeflow.WFDecisionOption;
import kd.bos.workflow.engine.dynprocess.freeflow.WFJointAuditTask;
import kd.bos.workflow.engine.dynprocess.freeflow.WFProcess;
import kd.bos.workflow.engine.dynprocess.freeflow.WFUserTask;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbs.business.domain.workflow.entity.WFAuditInfo;
import kd.tsc.tsrbs.business.domain.workflow.entity.WFAutoInfo;
import kd.tsc.tsrbs.business.domain.workflow.entity.WFJointAuditInfo;
import kd.tsc.tsrbs.business.domain.workflow.entity.WFProcessInfo;
import kd.tsc.tsrbs.business.domain.workflow.entity.WFUserInfo;
import kd.tsc.tsrbs.business.domain.workflow.service.FreeFlowAbstract;
import net.sf.cglib.beans.BeanCopier;
import net.sf.cglib.core.Converter;

public final class FreeFlowImpl
extends FreeFlowAbstract {
    public static final FreeFlowImpl freeFlowImpl = new FreeFlowImpl();

    private FreeFlowImpl() {
    }

    @Override
    public WFProcess initProcess(WFProcessInfo processInfo) {
        if (processInfo == null) {
            return new WFProcess();
        }
        WFProcess wfProcess = new WFProcess();
        BeanCopier.create(WFProcessInfo.class, WFProcess.class, (boolean)true).copy((Object)processInfo, (Object)wfProcess, (Converter)processInfo);
        return wfProcess;
    }

    @Override
    public WFUserTask initWFUserTask(WFProcess wfProcess, WFUserInfo wfUser) {
        WFUserTask wfUserTask = new WFUserTask(wfProcess);
        if (wfUser == null) {
            return wfUserTask;
        }
        BeanCopier.create(WFUserInfo.class, WFUserTask.class, (boolean)false).copy((Object)wfUser, (Object)wfUserTask, (Converter)wfUser);
        wfUserTask.setParticipant(this.getWfParticipantModel(wfUser));
        wfUserTask.setDecisionOptions(CollectionUtils.isEmpty(wfUser.getDecisionOptions()) ? this.initUserWFDecisionOptions() : wfUser.getDecisionOptions());
        return wfUserTask;
    }

    @Override
    public WFAuditTask initWFAuditTask(WFProcess wfProcess, WFAuditInfo wfAudit) {
        WFAuditTask wfAuditTask = new WFAuditTask(wfProcess);
        if (wfAudit == null) {
            return wfAuditTask;
        }
        BeanCopier.create(WFAuditInfo.class, WFAuditTask.class, (boolean)false).copy((Object)wfAudit, (Object)wfAuditTask, (Converter)wfAudit);
        wfAuditTask.setParticipant(this.getWfParticipantModel(wfAudit));
        wfAuditTask.setBillSetting(this.getWfBillSetting(wfAudit));
        Optional.ofNullable(wfAudit.getAutoAudit()).ifPresent(wfd -> wfd.getAutoAuditCondition().setElementid(wfAuditTask.getId()));
        Optional.ofNullable(wfAudit.getSkipCondition()).ifPresent(wfConditionalRule -> wfConditionalRule.setElementid(wfAuditTask.getId()));
        return wfAuditTask;
    }

    @Override
    public WFAutoTask initWFAutoTask(WFProcess wfProcess, WFAutoInfo wfAuto) {
        WFAutoTask wfAutoTask = new WFAutoTask(wfProcess);
        if (wfAuto == null) {
            return wfAutoTask;
        }
        wfAutoTask.setName(wfAuto.getName());
        WFAutoTaskExtItf service = new WFAutoTaskExtItf();
        service.setExtItf(wfAuto.getExtItf());
        wfAutoTask.setService(service);
        return wfAutoTask;
    }

    @Override
    public WFJointAuditTask initWFJointAuditTask(WFProcess wfProcess, WFJointAuditInfo wfJointAudit) {
        WFJointAuditTask wfJointTask = new WFJointAuditTask(wfProcess);
        if (wfJointAudit == null) {
            return wfJointTask;
        }
        BeanCopier.create(WFJointAuditInfo.class, WFJointAuditTask.class, (boolean)false).copy((Object)wfJointAudit, (Object)wfJointTask, (Converter)wfJointAudit);
        wfJointTask.setParticipant(this.getWfParticipantModel(wfJointAudit));
        wfJointTask.setBillSetting(this.getWfBillSetting(wfJointAudit));
        return wfJointTask;
    }

    @Override
    public void completeTask(String businessKey, String nodeId, Long userId, String decOptionNumber, String auditMessage, boolean checkUser) {
        if (HRStringUtils.isEmpty((String)businessKey)) {
            return;
        }
        if (HRStringUtils.isEmpty((String)nodeId)) {
            return;
        }
        if (userId == null) {
            return;
        }
        if (HRStringUtils.isEmpty((String)decOptionNumber)) {
            return;
        }
        if (HRStringUtils.isEmpty((String)auditMessage)) {
            return;
        }
        WorkflowServiceHelper.completeTask((String)businessKey, (String)nodeId, (Long)userId, (String)decOptionNumber, (String)auditMessage, (boolean)checkUser);
    }

    private List<WFDecisionOption> initUserWFDecisionOptions() {
        ArrayList<WFDecisionOption> decisionOptions = new ArrayList<WFDecisionOption>();
        WFDecisionOption agreeOption = new WFDecisionOption();
        agreeOption.setAuditType("approve");
        agreeOption.setDefaultDecision(true);
        agreeOption.setNumber("submit");
        LocaleString localeString = new LocaleString();
        localeString.put(Lang.zh_CN.name(), (Object)ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"", (String)"", (Object[])new Object[0]));
        localeString.put(Lang.zh_TW.name(), (Object)ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"", (String)"", (Object[])new Object[0]));
        localeString.put(Lang.zh_TW.name(), (Object)"Agree");
        agreeOption.setName(localeString);
        decisionOptions.add(agreeOption);
        return decisionOptions;
    }
}

