/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbs.formplugin.web.commrec;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Joiner;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tsc.tsrbd.common.utils.DateUtils;
import kd.tsc.tsrbs.business.domain.base.BaseHelper;
import kd.tsc.tsrbs.business.domain.commrec.service.FollowTaskHelper;
import kd.tsc.tsrbs.common.constants.commrec.FollowTaskListConstants;
import kd.tsc.tsrbs.common.entity.commrec.CommRecPageParam;
import kd.tsc.tsrbs.common.entity.commrec.FollowTaskHandleDTO;
import kd.tsc.tsrbs.common.utils.commrec.CommRecUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public class FollowTaskFormPlugin
extends HRDynamicFormBasePlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_save", "labviewmore", "labcancel"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        CommRecPageParam commRecPageParam = (CommRecPageParam)JSON.parseObject((String)customParams.get("paramJson").toString(), CommRecPageParam.class);
        this.setDefaultPersonHandle();
        if (Objects.isNull(commRecPageParam)) {
            return;
        }
        List<DynamicObject> sortFollowTaskList = this.getSortFollowTaskListHandle(commRecPageParam);
        if (CollectionUtils.isEmpty(sortFollowTaskList)) {
            return;
        }
        CardEntry cardEntry = (CardEntry)this.getView().getControl("followtaskentry");
        this.getModel().deleteEntryData("followtaskentry");
        TableValueSetter tableValueSetter = new TableValueSetter(new String[0]);
        for (int count = 0; count < sortFollowTaskList.size(); ++count) {
            this.styleHandle(cardEntry, sortFollowTaskList.get(count), count);
            this.followTaskInfoHandle(tableValueSetter, sortFollowTaskList.get(count), count);
        }
        ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow("followtaskentry", tableValueSetter);
    }

    private void setDefaultPersonHandle() {
        DynamicObjectCollection followPersonList = new DynamicObjectCollection();
        DynamicObject currentUser = BaseHelper.selectById((Long)UserServiceHelper.getCurrentUserId(), (String)"bos_user");
        followPersonList.add((Object)currentUser);
        this.getModel().setValue("selfolper", (Object)followPersonList);
    }

    public List<DynamicObject> getSortFollowTaskListHandle(CommRecPageParam commRecPageParam) {
        List followTaskList;
        String commRecId = commRecPageParam.getCommrecId();
        String followTaskId = commRecPageParam.getFollowTaskId();
        String businessId = commRecPageParam.getBusinessId();
        this.getModel().setValue("pageId", (Object)commRecPageParam.getSysMessagePageId());
        String pageOpenType = commRecPageParam.getPageOpenType();
        String cachePageOpenType = this.getPageCache().get("pageOpenType");
        if (StringUtils.isNotEmpty((CharSequence)cachePageOpenType)) {
            pageOpenType = cachePageOpenType;
        }
        if ("msg".equals(pageOpenType)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"labviewmore"});
            followTaskList = FollowTaskHelper.selectFollowTaskList(null, (Long)(StringUtils.isEmpty((CharSequence)followTaskId) ? null : Long.valueOf(followTaskId)), (Long)(StringUtils.isEmpty((CharSequence)businessId) ? null : Long.valueOf(businessId)));
        } else if ("fol".equals(pageOpenType)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"labviewmore"});
            followTaskList = FollowTaskHelper.selectFollowTaskList((Long)(StringUtils.isEmpty((CharSequence)commRecId) ? null : Long.valueOf(commRecId)), null, (Long)(StringUtils.isEmpty((CharSequence)businessId) ? null : Long.valueOf(businessId)));
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"labviewmore"});
            followTaskList = FollowTaskHelper.selectFollowTaskList(null, null, (Long)(StringUtils.isEmpty((CharSequence)businessId) ? null : Long.valueOf(businessId)));
        }
        if (CollectionUtils.isEmpty((Collection)followTaskList)) {
            return null;
        }
        return followTaskList.stream().sorted(Comparator.comparing(followTask -> followTask.getDate("createtime"))).collect(Collectors.toList());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Date selFolTime;
        super.propertyChanged(e);
        String keyName = e.getProperty().getName();
        if ("selfolper".equals(keyName)) {
            DynamicObjectCollection selectFollowPersonList = (DynamicObjectCollection)this.getModel().getValue("selfolper");
            if ((long)selectFollowPersonList.size() > FollowTaskListConstants.SELECT_FOLLOW_PERSON_COUNT) {
                DynamicObjectCollection newFollowPerson = new DynamicObjectCollection();
                selectFollowPersonList.stream().limit(FollowTaskListConstants.SELECT_FOLLOW_PERSON_COUNT).forEach(arg_0 -> ((DynamicObjectCollection)newFollowPerson).add(arg_0));
                this.getModel().setValue("selfolper", (Object)newFollowPerson);
                String tipStr = ResManager.loadKDString((String)"\u6700\u591a\u9009\u62e95\u4eba", (String)"FollowTaskFormPlugin_0", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(tipStr);
            }
        } else if ("selfoltime".equals(keyName) && Objects.nonNull(selFolTime = (Date)this.getModel().getValue(keyName))) {
            LocalDateTime localDateTimeByDate = DateUtils.getLocalDateTimeByDate((Date)selFolTime);
            if (localDateTimeByDate.isBefore(LocalDateTime.now())) {
                String tips = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u672a\u6765\u65f6\u95f4", (String)"FollowTaskFormPlugin_1", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]);
                this.getView().showFieldTip(CommRecUtils.createFieldTip((String)tips, (String)"tipfoltime"));
                this.getModel().setValue("selfoltime", null);
            } else {
                this.getView().showFieldTip(CommRecUtils.createFieldTip(null, (String)"tipfoltime"));
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if ("btn_save".equals(control.getKey())) {
            if (!this.checkStdRsmDataStatus()) {
                return;
            }
            if (this.isInvalidHandle().booleanValue()) {
                return;
            }
            if (FollowTaskHelper.followTaskHandle((FollowTaskHandleDTO)this.createFollowTaskHandle()).booleanValue()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d1\u5e03\u6210\u529f", (String)"CommRecListFormPlugin_0", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53d1\u5e03\u5931\u8d25", (String)"CommRecListFormPlugin_1", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]));
            }
            this.viewMoreHandle();
            this.getView().invokeOperation("refresh");
        } else if ("labcancel".equals(control.getKey())) {
            this.cancelFollowTaskHandle();
        } else {
            this.viewMoreHandle();
            this.getView().invokeOperation("refresh");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (MessageBoxResult.Yes.equals((Object)result) && StringUtils.isNotEmpty((CharSequence)callBackId)) {
            DynamicObject followTask = BaseHelper.selectById((Long)Long.valueOf(callBackId), (String)"tsrbs_followtask");
            Optional.ofNullable(followTask).ifPresent(folTask -> {
                if ("A".equals(folTask.getString("taskstatus"))) {
                    FollowTaskHelper.cancelFollowTask((Long)folTask.getLong("id"), (Long)folTask.getDynamicObject("creator").getLong("id"), (String)((String)this.getModel().getValue("pageId")), (FollowTaskHandleDTO)this.createFollowTaskHandle());
                } else {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u8bd5", (String)"FollowTaskFormPlugin_2", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]));
                }
            });
        }
        this.getView().invokeOperation("refresh");
    }

    private Boolean isInvalidHandle() {
        Boolean flag = Boolean.FALSE;
        String tips = ResManager.loadKDString((String)"\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"CommRecListFormPlugin_5", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]);
        if (CollectionUtils.isEmpty((Collection)((DynamicObjectCollection)this.getModel().getValue("selfolper")))) {
            this.getView().showFieldTip(CommRecUtils.createFieldTip((String)tips, (String)"selfolper"));
            flag = Boolean.TRUE;
        }
        if (Objects.isNull(this.getModel().getValue("selfoltime"))) {
            this.getView().showFieldTip(CommRecUtils.createFieldTip((String)tips, (String)"tipfoltime"));
            flag = Boolean.TRUE;
        }
        if (Objects.isNull(this.getModel().getValue("selnoticeway"))) {
            this.getView().showFieldTip(CommRecUtils.createFieldTip((String)tips, (String)"selnoticeway"));
            flag = Boolean.TRUE;
        }
        if (StringUtils.isEmpty((CharSequence)((String)this.getModel().getValue("inputfolcontent")))) {
            this.getView().showFieldTip(CommRecUtils.createFieldTip((String)tips, (String)"inputfolcontent"));
            flag = Boolean.TRUE;
        }
        return flag;
    }

    public void styleHandle(CardEntry cardEntry, DynamicObject followTask, int index) {
        if ("A".equals(followTask.getString("taskstatus"))) {
            cardEntry.setChildVisible(false, index, new String[]{"flexendtime", "labaldycnl", "labaldyremind"});
            cardEntry.setChildVisible(true, index, new String[]{"labcancel"});
        } else if ("B".equals(followTask.getString("taskstatus"))) {
            cardEntry.setChildVisible(false, index, new String[]{"flexendtime", "labaldycnl", "labcancel"});
            cardEntry.setChildVisible(true, index, new String[]{"labaldyremind"});
        } else if ("C".equals(followTask.getString("taskstatus"))) {
            cardEntry.setChildVisible(true, index, new String[]{"labaldycnl", "flexendtime"});
            cardEntry.setChildVisible(false, index, new String[]{"labaldyremind", "labcancel"});
        } else {
            cardEntry.setChildVisible(false, index, new String[]{"flexendtime", "labaldycnl", "labaldyremind"});
        }
        if (UserServiceHelper.getCurrentUserId() != followTask.getDynamicObject("creator").getLong("id")) {
            cardEntry.setChildVisible(false, index, new String[]{"labcancel"});
        }
        cardEntry.setChildVisible(Objects.nonNull(this.getCommThemeHandle(followTask)), index, new String[]{"commtheme", "lableftbrackets", "labrightbrackets"});
    }

    private DynamicObject getCommThemeHandle(DynamicObject followTask) {
        DynamicObject commRec = followTask.getDynamicObject("commrec");
        if (Objects.isNull(commRec)) {
            return null;
        }
        return commRec.getDynamicObject("commtheme");
    }

    private void followTaskInfoHandle(TableValueSetter tableValueSetter, DynamicObject followTask, int count) {
        tableValueSetter.set("followTask", (Object)followTask, count);
        String followTime = DateUtils.formatDate((Date)followTask.getDate("followtime"), (String)"yyyy-MM-dd HH:mm");
        String endTime = DateUtils.formatDate((Date)followTask.getDate("endtime"), (String)"yyyy-MM-dd HH:mm");
        String createTime = DateUtils.formatDate((Date)followTask.getDate("createtime"), (String)"yyyy-MM-dd HH:mm");
        tableValueSetter.set("foltaskcontent", followTask.get("foltaskcontent"), count);
        tableValueSetter.set("foltime", (Object)followTime, count);
        tableValueSetter.set("endtime", (Object)endTime, count);
        tableValueSetter.set("creator", (Object)followTask.getDynamicObject("creator").getString("name"), count);
        tableValueSetter.set("createtime", (Object)createTime, count);
        DynamicObjectCollection folPerEntryList = followTask.getDynamicObjectCollection("folperentry");
        List folPerNameList = folPerEntryList.stream().map(folPerEntry -> folPerEntry.getDynamicObject("folper").getString("name")).collect(Collectors.toList());
        tableValueSetter.set("folper", (Object)Joiner.on((String)"\uff0c").join(folPerNameList), count);
        DynamicObject commTheme = this.getCommThemeHandle(followTask);
        String folTaskContent = Objects.isNull(commTheme) ? followTask.getString("foltaskcontent") : "#".concat(commTheme.getString("name")).concat("#").concat(" ").concat(followTask.getString("foltaskcontent"));
        tableValueSetter.set("foltaskcontent", (Object)folTaskContent, count);
    }

    private void cancelFollowTaskHandle() {
        int index = this.getModel().getEntryCurrentRowIndex("followtaskentry");
        DynamicObject followTask = (DynamicObject)this.getModel().getValue("followTask", index);
        DynamicObject newFollowTask = BaseHelper.selectById((Long)followTask.getLong("id"), (String)"tsrbs_followtask");
        if (Objects.nonNull(newFollowTask)) {
            if ("A".equals(newFollowTask.getString("taskstatus"))) {
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(String.valueOf(newFollowTask.getLong("id")), (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u53d6\u6d88\u540e\u5c06\u65e0\u6cd5\u6536\u5230\u8ddf\u76ef\u63d0\u9192\uff0c\u786e\u5b9a\u53d6\u6d88\uff1f", (String)"FollowTaskFormPlugin_3", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u8bd5", (String)"FollowTaskFormPlugin_2", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private FollowTaskHandleDTO createFollowTaskHandle() {
        Map paramMap = this.getView().getFormShowParameter().getCustomParams();
        CommRecPageParam commRecPageParam = (CommRecPageParam)JSON.parseObject((String)paramMap.get("paramJson").toString(), CommRecPageParam.class);
        FollowTaskHandleDTO dto = new FollowTaskHandleDTO();
        dto.setAppId("tsrbs");
        dto.setBusinessId(Long.valueOf(commRecPageParam.getBusinessId()));
        dto.setBusinessType(commRecPageParam.getBusinessType());
        dto.setAppFileId(commRecPageParam.getAppFileId());
        dto.setAppFileName(commRecPageParam.getAppFileName());
        dto.setFollowDateTime((Date)this.getModel().getValue("selfoltime"));
        dto.setPageId(commRecPageParam.getSysMessagePageId());
        dto.setFollowTaskContent((String)this.getModel().getValue("inputfolcontent"));
        DynamicObjectCollection selFolPerList = (DynamicObjectCollection)this.getModel().getValue("selfolper");
        List selFolPerIdList = selFolPerList.stream().map(selFolPer -> selFolPer.getLong("fbasedataid_id")).collect(Collectors.toList());
        dto.setFollowPersonIdList(selFolPerIdList);
        dto.setNoticeWays((String)this.getModel().getValue("selnoticeway"));
        dto.setBusinessAddUrlInfo(commRecPageParam.getBusinessAddUrlInfo());
        return dto;
    }

    private void viewMoreHandle() {
        this.getPageCache().put("pageOpenType", "sys");
    }

    private boolean checkStdRsmDataStatus() {
        IFormView candidateDetailView = Optional.ofNullable(this.getView().getParentView()).map(parentView -> parentView.getParentView()).orElse(null);
        if (candidateDetailView != null && StringUtils.equals((CharSequence)"tstpm_candidate_detail", (CharSequence)candidateDetailView.getFormShowParameter().getFormId())) {
            return (Boolean)DispatchServiceHelper.invokeBizService((String)"tsc", (String)"tstpm", (String)"talentPoolServiceApi", (String)"checkStdRsmDataStatus", (Object[])new Object[]{candidateDetailView, this.getView()});
        }
        return true;
    }
}

