/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbs.formplugin.web.foreignadminorg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tsc.tsrbs.business.domain.foreignadminorg.ForeignAdminOrgHelper;
import kd.tsc.tsrbs.business.domain.foreignadminorg.datasync.mk.OperationType;
import kd.tsc.tsrbs.common.utils.GenerateFormShowParamUtils;

public class ForeignAdminOrgEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    public static final int TREE_MAX_NUM = 20;
    public static final int SECOND_LONG_NUMBER_LENGTH = 17;
    private static Log LOG = LogFactory.getLog(ForeignAdminOrgEdit.class);

    public void preOpenForm(PreOpenFormEventArgs evt) {
        super.preOpenForm(evt);
        OperationStatus status = evt.getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            evt.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u65b0\u589e\u5bf9\u5916\u62db\u8058\u7ec4\u7ec7", (String)"ForeignAdminOrgEdit_5", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]));
        } else {
            DynamicObject dy = ForeignAdminOrgHelper.getAdminOrgHelper().queryOne("name", (Object)Long.valueOf(((BaseShowParameter)evt.getSource()).getPkId().toString()));
            evt.getFormShowParameter().setCaption(dy.getString("name"));
        }
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        long id = (Long)this.getView().getModel().getDataEntity().getPkValue();
        if (OperationStatus.VIEW.equals((Object)status)) {
            FormShowParameter headInfoParam = ForeignAdminOrgHelper.getAdminOrgHeadInfoParam((Long)id);
            this.getView().setVisible(Boolean.TRUE, new String[]{"headinfopanel"});
            this.getView().showForm(headInfoParam);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"headinfopanel"});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (HRStringUtils.equals((String)"save", (String)operateKey) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.getView().setStatus(OperationStatus.VIEW);
            this.getView().updateView();
        }
        if (HRStringUtils.equals((String)"modify", (String)operateKey) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.getView().updateView();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if (HRStringUtils.equals((String)"save", (String)operateKey)) {
            DynamicObject parent = (DynamicObject)this.getModel().getValue("parent");
            if (parent == null) {
                return;
            }
            Long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
            int entryCount = this.getModel().getEntryRowCount("entryentity");
            if (entryCount < 1) {
                args.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u5bf9\u5916\u62db\u8058\u7ec4\u7ec7\u5173\u8054\u7684\u884c\u653f\u7ec4\u7ec7\u6620\u5c04\u5173\u7cfb\u3002", (String)"ForeignAdminOrgEdit_0", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            long count = entryEntity.stream().filter(dy -> dy.getString("isdefaultadminorg").equals("1")).count();
            if (count < 1L) {
                args.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5728\u884c\u653f\u7ec4\u7ec7\u6620\u5c04\u5173\u7cfb\u4e2d\uff0c\u9009\u62e9\u4e00\u4e2a\u884c\u653f\u7ec4\u7ec7\uff0c\u4f5c\u4e3a\u9ed8\u8ba4\u884c\u653f\u7ec4\u7ec7\u3002", (String)"ForeignAdminOrgEdit_1", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]));
                return;
            }
            if (this.verifyParentLevel()) {
                args.setCancel(true);
                return;
            }
            if (this.verifyNameUnique(pkValue, parent)) {
                args.setCancel(true);
                this.getView().showErrorNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u4e0b\u7ea7\u5df2\u5b58\u5728\u540c\u540d\u7684\u5bf9\u5916\u62db\u8058\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539\u5bf9\u5916\u62db\u8058\u7ec4\u7ec7\u540d\u79f0\u3002", (String)"ForeignAdminOrgEdit_6", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]), parent.getString("name")));
                return;
            }
            if (this.verifyAdminOrgUnique(pkValue)) {
                args.setCancel(true);
                return;
            }
            if (this.verifyParentEnable(parent)) {
                args.setCancel(true);
                this.getView().showErrorNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4e0a\u7ea7\u5bf9\u5916\u62db\u8058\u7ec4\u7ec7%s\u5df2\u88ab\u7981\u7528\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58\u542f\u7528\u7684\u4e0b\u7ea7\u5bf9\u5916\u62db\u8058\u7ec4\u7ec7\u3002", (String)"ForeignAdminOrgEdit_7", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]), parent.getString("name")));
                return;
            }
            if (pkValue == 0L) {
                source.getOption().setVariableValue("operationtype", OperationType.INSERT.code);
            } else {
                source.getOption().setVariableValue("operationtype", OperationType.UPDATE.code);
            }
        }
    }

    private boolean verifyParentEnable(DynamicObject parent) {
        String enable = (String)this.getModel().getValue("enable");
        if (HRStringUtils.isNotEmpty((String)enable) && HRStringUtils.equals((String)"1", (String)enable)) {
            String parentEnable = parent.getString("enable");
            return HRStringUtils.isNotEmpty((String)parentEnable) && HRStringUtils.equals((String)"0", (String)parentEnable);
        }
        return false;
    }

    private boolean verifyAdminOrgUnique(Long pkValue) {
        Set<Long> idSet = this.getIdSet();
        QFilter idFilter = new QFilter("id", "not in", (Object)pkValue);
        QFilter orgFilter = new QFilter("entryentity.realadminorg", "in", idSet);
        DynamicObject[] result = ForeignAdminOrgHelper.getAdminOrgHelper().query("id,name,number,entryentity.realadminorg", new QFilter[]{idFilter, orgFilter});
        if (result != null && result.length > 0) {
            int allNum = this.getModel().getEntryRowCount("entryentity");
            ArrayList errorMsgList = new ArrayList(allNum);
            Arrays.stream(result).forEach(dy -> {
                DynamicObjectCollection entry = dy.getDynamicObjectCollection("entryentity");
                if (entry != null && entry.size() > 0) {
                    entry.forEach(info -> {
                        DynamicObject orgInfo = info.getDynamicObject("realadminorg");
                        if (idSet.contains(orgInfo.getLong("id"))) {
                            String errorMsg = String.format(ResManager.loadKDString((String)"%s:\u5df2\u5305\u542b\u5728\u5bf9\u5916\u62db\u8058\u7ec4\u7ec7%s %s\u4e2d\uff0c \u4e0d\u80fd\u91cd\u590d\u9009\u62e9\u3002", (String)"ForeignAdminOrgEdit_2", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]), orgInfo.getString("number"), dy.getString("name"), dy.getString("number"));
                            errorMsgList.add(errorMsg);
                        }
                    });
                }
            });
            if (errorMsgList.size() > 0) {
                String titleMsg = String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u6620\u5c04\u5173\u7cfb\u4e2d\u7684%s\u4e2a\u884c\u653f\u7ec4\u7ec7\u5df2\u5173\u8054\u5728\u5176\u4ed6\u5bf9\u5916\u62db\u8058\u7ec4\u7ec7\u4e2d", (String)"ForeignAdminOrgEdit_3", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]), errorMsgList.size());
                FormShowParameter formShowParam = GenerateFormShowParamUtils.generateBosOperationResultFormShowParam((Object)titleMsg, errorMsgList, (boolean)true);
                this.getView().showForm(formShowParam);
                return true;
            }
        }
        return false;
    }

    private boolean verifyNameUnique(Long pkValue, DynamicObject parent) {
        String name = this.getModel().getValue("name").toString();
        if (HRStringUtils.isNotEmpty((String)name) && !HRObjectUtils.isEmpty((Object)parent)) {
            QFilter filter = new QFilter("name", "=", (Object)name);
            filter.and(new QFilter("parent", "=", (Object)parent.getLong("id")));
            if (pkValue != 0L) {
                filter.and("id", "!=", (Object)pkValue);
            }
            return ForeignAdminOrgHelper.getAdminOrgHelper().isExists(new QFilter[]{filter});
        }
        return false;
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name;
        switch (name = args.getProperty().getName()) {
            case "isdefaultadminorg": {
                this.defaultAdminOrgRule(args);
                break;
            }
            case "parent": {
                this.verifyParentLevel();
                break;
            }
        }
    }

    private boolean verifyParentLevel() {
        DynamicObject parent = (DynamicObject)this.getModel().getValue("parent");
        if (!HRObjectUtils.isEmpty((Object)parent)) {
            String longNumber = parent.getString("longnumber");
            int parentLevel = ForeignAdminOrgHelper.getLevelByLongNumber((String)longNumber);
            LOG.info("verifyParentLevel parentLevel: {}", (Object)parentLevel);
            long id = (Long)this.getView().getModel().getDataEntity().getPkValue();
            if (id != 0L) {
                return this.modifyMaxLevelCheck(parent, parentLevel);
            }
            if (parentLevel >= 20) {
                this.getView().showErrorNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u4e0b\u4e0d\u5141\u8bb8\u518d\u65b0\u589e\u5bf9\u5916\u62db\u8058\u7ec4\u7ec7\uff0c\u7ec4\u7ec7\u5c42\u7ea7\u5c06\u8d85\u8fc720\u5c42\u3002", (String)"ForeignAdminOrgEdit_4", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]), parent.getString("name")));
                this.getView().getModel().setValue("parent", (Object)"");
                return true;
            }
        }
        return false;
    }

    private boolean modifyMaxLevelCheck(DynamicObject parent, int parentLevel) {
        String longNumber = (String)this.getModel().getValue("longnumber");
        int level = ForeignAdminOrgHelper.getLevelByLongNumber((String)longNumber);
        QFilter numberFilter = new QFilter("longnumber", "like", (Object)(longNumber + "%"));
        DynamicObject dy = ForeignAdminOrgHelper.getAdminOrgHelper().queryOne("longnumber", new QFilter[]{numberFilter}, "longnumber desc");
        if (dy != null) {
            LOG.info("modifyMaxLevelCheck dy: {}", (Object)dy);
            String maxLongNumber = dy.getString("longnumber");
            int maxLevel = ForeignAdminOrgHelper.getLevelByLongNumber((String)maxLongNumber);
            LOG.info("modifyMaxLevelCheck maxLevel:{}, level: {}", (Object)maxLevel, (Object)level);
            if (maxLevel - level + parentLevel >= 20) {
                this.getView().showErrorNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u4e0b\u4e0d\u5141\u8bb8\u518d\u65b0\u589e\u5bf9\u5916\u62db\u8058\u7ec4\u7ec7\uff0c\u7ec4\u7ec7\u5c42\u7ea7\u5c06\u8d85\u8fc720\u5c42\u3002", (String)"ForeignAdminOrgEdit_4", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]), parent.getString("name")));
                this.getView().getModel().setValue("parent", (Object)"");
                return true;
            }
        }
        return false;
    }

    private void defaultAdminOrgRule(PropertyChangedArgs args) {
        int rowIndex = args.getChangeSet()[0].getRowIndex();
        String isDeFaultAdminOrg = (String)this.getModel().getValue("isdefaultadminorg", rowIndex);
        if (HRStringUtils.isNotEmpty((String)isDeFaultAdminOrg) && HRStringUtils.equals((String)"1", (String)isDeFaultAdminOrg)) {
            int entryRowCount = this.getModel().getEntryRowCount("entryentity");
            for (int index = 0; index < entryRowCount; ++index) {
                if (index == rowIndex) continue;
                this.getModel().setValue("isdefaultadminorg", (Object)"0", index);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if (HRStringUtils.equals((String)"parent", (String)name)) {
            String longNumber;
            long id = (Long)this.getView().getModel().getDataEntity().getPkValue();
            if (id != 0L && (longNumber = this.getModel().getDataEntity().getString("longnumber")).length() > 17) {
                String secondLongNumber = longNumber.substring(0, 17);
                StringBuilder builder = new StringBuilder();
                builder.append(secondLongNumber);
                builder.append("%");
                QFilter filter = new QFilter("longnumber", "like", (Object)builder.toString());
                StringBuilder lowerBuilder = new StringBuilder();
                lowerBuilder.append(longNumber);
                lowerBuilder.append("%");
                filter.and(new QFilter("longnumber", "not like", (Object)lowerBuilder.toString()));
                beforeF7SelectEvent.getFormShowParameter().setCustomParam("longnumber", (Object)secondLongNumber);
                beforeF7SelectEvent.addCustomQFilter(filter);
            }
            beforeF7SelectEvent.getFormShowParameter().setCustomParam("enable", this.getModel().getValue("enable"));
        } else if (HRStringUtils.equals((String)"realadminorg", (String)name)) {
            this.getSelectedFilter(beforeF7SelectEvent);
            this.getUsedFilter(beforeF7SelectEvent);
        }
    }

    private void getUsedFilter(BeforeF7SelectEvent beforeF7SelectEvent) {
        QFilter filter = new QFilter("id", "!=", (Object)Long.valueOf(this.getModel().getDataEntity().getPkValue().toString()));
        filter.and(new QFilter("parent", "!=", (Object)0L));
        DynamicObject[] result = ForeignAdminOrgHelper.getAdminOrgHelper().query("id,name,entryentity.realadminorg", new QFilter[]{filter});
        HashSet idSet = new HashSet(16);
        if (result != null && result.length > 0) {
            Arrays.stream(result).forEach(dy -> {
                DynamicObjectCollection collection = dy.getDynamicObjectCollection("entryentity");
                if (collection != null && collection.size() > 0) {
                    Set set = collection.stream().map(org -> org.getLong("realadminorg.id")).collect(Collectors.toSet());
                    idSet.addAll(set);
                }
            });
        }
        if (!idSet.isEmpty()) {
            beforeF7SelectEvent.addCustomQFilter(new QFilter("id", "not in", idSet));
        }
    }

    private void getSelectedFilter(BeforeF7SelectEvent beforeF7SelectEvent) {
        Set<Long> idSet = this.getIdSet();
        if (!idSet.isEmpty()) {
            beforeF7SelectEvent.addCustomQFilter(new QFilter("id", "not in", idSet));
        }
    }

    private Set<Long> getIdSet() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        HashSet<Long> idSet = new HashSet<Long>(entryEntity.size());
        entryEntity.forEach(entry -> {
            DynamicObject adminOrg = entry.getDynamicObject("realadminorg");
            if (!HRObjectUtils.isEmpty((Object)adminOrg)) {
                idSet.add(adminOrg.getLong("id"));
            }
        });
        return idSet;
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        BasedataEdit parent = (BasedataEdit)this.getView().getControl("parent");
        parent.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit adminOrg = (BasedataEdit)this.getView().getControl("realadminorg");
        adminOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }
}

