/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbs.formplugin.web.foreignadminorg;

import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FloatingDirection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.TemplateTreePlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ITreeListView;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbs.business.domain.foreignadminorg.ForeignAdminOrgHelper;

public class ForeignAdminOrgTreeList
extends TemplateTreePlugin {
    public void registerListener(EventObject event) {
        super.registerListener(event);
        this.addClickListeners(new String[]{"btntreefilter"});
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        if (HRStringUtils.equals((String)"iscontainlower", (String)args.getProperty().getName()) && this.getTreeListView().getTreeModel() != null) {
            Object currentNodeId = this.getTreeListView().getTreeModel().getCurrentNodeId();
            TreeNode rootNode = this.getTreeListView().getTreeModel().getRoot();
            if (currentNodeId != null && rootNode != null) {
                BillList billList = (BillList)this.getControl("billlistap");
                billList.refresh();
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.hasTreeModel()) {
            this.getTreeModel().setRootVisable(false);
            this.getTreeListView().getTreeView().setRootVisible(false);
        }
    }

    public void initialize() {
        super.initialize();
        IListView listView = (IListView)this.getView();
        listView.setVisible(Boolean.valueOf(true), new String[]{"iscontainlower"});
        if (this.hasTreeModel()) {
            this.getTreeModel().setRootVisable(false);
            this.rebuildTreeListFilter();
        }
    }

    private boolean hasTreeModel() {
        ITreeListView treeListView = this.getTreeListView();
        return treeListView != null;
    }

    public void initializeTree(EventObject event) {
        super.initializeTree(event);
        this.getPageCache().put("isinitialize", "1");
        this.getTreeModel().setRootVisable(false);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if ("btntreefilter".equals(control.getKey().toLowerCase(Locale.ROOT))) {
            this.showDisableFormWindow();
        }
    }

    private void showDisableFormWindow() {
        FormShowParameter formShowParameter = new FormShowParameter();
        OpenStyle openStyle = formShowParameter.getOpenStyle();
        openStyle.setShowType(ShowType.Floating);
        openStyle.setFloatingDirection(FloatingDirection.RightCenter);
        openStyle.setTargetKey("btntreefilter");
        formShowParameter.setFormId("tsrbs_orgtreefiter");
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("140px");
        styleCss.setHeight("50px");
        openStyle.setInlineStyleCss(styleCss);
        boolean isShowDisable = (Boolean)this.getModel().getValue("chkshowdisable");
        formShowParameter.setCustomParam("chkshowdisable", (Object)String.valueOf(isShowDisable));
        this.getView().showForm(formShowParameter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        FormOperate source = (FormOperate)args.getSource();
        switch (operateKey = source.getOperateKey()) {
            case "disable": {
                this.disableAdminOrg(args);
                break;
            }
            case "enable": {
                this.enableAdminOrg(args);
                break;
            }
            case "new": {
                this.orgLevelCheck(args);
                break;
            }
        }
    }

    private void orgLevelCheck(BeforeDoOperationEventArgs args) {
        TreeNode treeNode;
        String currentNodeId = this.getTreeModel().getCurrentNodeId().toString();
        if (HRStringUtils.isNotEmpty((String)currentNodeId) && (treeNode = this.getTreeModel().getRoot().getTreeNode(currentNodeId)) != null && ForeignAdminOrgHelper.getLevelByLongNumber((String)treeNode.getLongNumber()) >= 20) {
            args.setCancel(true);
            this.getView().showErrorNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u4e0b\u4e0d\u5141\u8bb8\u518d\u65b0\u589e\u5bf9\u5916\u62db\u8058\u7ec4\u7ec7\uff0c\u7ec4\u7ec7\u5c42\u7ea7\u5c06\u8d85\u8fc720\u5c42\u3002", (String)"ForeignAdminOrgEdit_4", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]), treeNode.getText()));
        }
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        if (this.hasTreeModel()) {
            ITreeModel treeModel = this.getTreeModel();
            String isInitialize = this.getPageCache().get("isinitialize");
            TreeNode root = treeModel.getRoot();
            String currNodeId = (String)treeModel.getCurrentNodeId();
            if (HRStringUtils.isNotEmpty((String)isInitialize) && HRStringUtils.equals((String)"1", (String)isInitialize) || HRStringUtils.equals((String)root.getId(), (String)currNodeId)) {
                this.setRootNode();
            } else if (!HRStringUtils.equals((String)root.getId(), (String)currNodeId)) {
                TreeNode treeNode = root.getTreeNode(currNodeId);
                treeNode.setIsOpened(true);
            }
            Boolean chkShowDisable = (Boolean)this.getView().getFormShowParameter().getCustomParam("chkshowdisable");
            if (chkShowDisable != null) {
                this.getModel().setValue("chkshowdisable", (Object)chkShowDisable);
            }
        }
    }

    private void setRootNode() {
        List children = this.getTreeModel().getRoot().getChildren();
        if (!HRObjectUtils.isEmpty((Object)children) && children.size() > 0) {
            TreeNode node = (TreeNode)children.get(0);
            TreeView treeView = (TreeView)this.getControl("treeview");
            node.setIsOpened(true);
            treeView.focusNode(node);
            this.getTreeModel().setCurrentNodeId((Object)node.getId());
            this.getPageCache().put("isinitialize", "0");
        }
    }

    private void enableAdminOrg(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
        if (selectedRows != null && selectedRows.size() > 0) {
            List idsList = selectedRows.stream().map(row -> Long.valueOf(row.getPrimaryKeyValue().toString())).collect(Collectors.toList());
            QFilter filter = new QFilter("id", "in", idsList);
            filter.and("parent.enable", "!=", (Object)"1");
            if (ForeignAdminOrgHelper.getAdminOrgHelper().isExists(filter)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b58\u5728\u7981\u7528\u7684\u4e0a\u7ea7\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u6267\u884c\u8be5\u64cd\u4f5c\u3002\u8bf7\u5148\u6309\u5c42\u7ea7\u5355\u72ec\u542f\u7528\u4e0a\u7ea7\u7ec4\u7ec7\uff0c\u518d\u542f\u7528\u4e0b\u7ea7\u7ec4\u7ec7\u3002", (String)"ForeignAdminOrgTreeList_0", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    private void disableAdminOrg(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
        if (selectedRows != null && selectedRows.size() > 0) {
            List idsList = selectedRows.stream().map(row -> Long.valueOf(row.getPrimaryKeyValue().toString())).collect(Collectors.toList());
            QFilter filter = new QFilter("parent", "in", idsList);
            filter.and(new QFilter("enable", "!=", (Object)"0"));
            if (ForeignAdminOrgHelper.getAdminOrgHelper().isExists(filter)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b58\u5728\u542f\u7528\u7684\u4e0b\u7ea7\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u6267\u884c\u8be5\u64cd\u4f5c\u3002\u8bf7\u5148\u6309\u5c42\u7ea7\u5355\u72ec\u7981\u7528\u4e0b\u7ea7\u7ec4\u7ec7\uff0c\u518d\u7981\u7528\u4e0a\u7ea7\u7ec4\u7ec7\u3002", (String)"ForeignAdminOrgTreeList_1", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void setFilter(SetFilterEvent evt) {
        super.setFilter(evt);
        if (this.hasTreeModel()) {
            String enable;
            ListShowParameter showParameter;
            boolean isContainLower = (Boolean)this.getModel().getValue("iscontainlower");
            Object currentNodeId = this.getTreeListView().getTreeModel().getCurrentNodeId();
            if (!isContainLower && currentNodeId != null && !HRStringUtils.equals((String)"8609760E-EF83-4775-A9FF-CCDEC7C0B689", (String)currentNodeId.toString())) {
                long nodeId = Long.parseLong(currentNodeId.toString());
                QFilter filter2 = new QFilter("id", "=", (Object)nodeId);
                filter2.or(new QFilter("parent", "=", (Object)nodeId));
                evt.getQFilters().add(filter2);
            }
            if ((showParameter = (ListShowParameter)this.getView().getFormShowParameter()).isLookUp() && HRStringUtils.isNotEmpty((String)(enable = (String)showParameter.getCustomParam("enable"))) && HRStringUtils.equals((String)"0", (String)enable)) {
                List filters = evt.getQFilters();
                filters.removeIf(filter -> filter.getProperty().equals("enable"));
            }
        }
        evt.setOrderBy("longnumber asc");
    }

    private void addTreeListFilter() {
        List treeFilter = this.getTreeListView().getTreeModel().getTreeFilter();
        treeFilter.add(new QFilter("enable", "=", (Object)"1"));
    }

    public void refreshNode(RefreshNodeEvent evt) {
        super.refreshNode(evt);
        Boolean showDisable = (Boolean)this.getView().getFormShowParameter().getCustomParam("chkshowdisable");
        if (showDisable != null) {
            if (!showDisable.booleanValue()) {
                this.addTreeListFilter();
            }
        } else {
            boolean chkShowDisable = (Boolean)this.getModel().getValue("chkshowdisable");
            if (!chkShowDisable) {
                this.addTreeListFilter();
            }
        }
        if (this.hasTreeModel()) {
            TreeListModel model = (TreeListModel)this.getTreeModel();
            model.getQueryParas().put("order", "longnumber asc");
        }
    }

    private void rebuildTreeListFilter() {
        List treeFilter = this.getTreeListView().getTreeModel().getTreeFilter();
        if (treeFilter != null && treeFilter.size() > 0) {
            treeFilter.removeIf(filter -> HRStringUtils.equals((String)"enable", (String)filter.getProperty()));
        }
    }
}

