/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbs.formplugin.web.foreignadminorg;

import java.util.EventObject;
import java.util.Map;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ITreeListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;

public class OrgTreeListFilterPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final Log logger = LogFactory.getLog(OrgTreeListFilterPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"chkshowdisable"});
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCancel(false);
        e.setCheckDataChange(false);
    }

    public void afterCreateNewData(EventObject e) {
        boolean isShowDisable = false;
        String chkShowDisable = (String)this.getView().getFormShowParameter().getCustomParam("chkshowdisable");
        if (HRStringUtils.isNotEmpty((String)chkShowDisable)) {
            isShowDisable = Boolean.parseBoolean(chkShowDisable);
        }
        this.getModel().setValue("chkshowdisable", (Object)isShowDisable);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (HRStringUtils.equals((String)"chkshowdisable", (String)name)) {
            IListView listView = (IListView)this.getView().getParentView();
            if (listView == null) {
                logger.info("propertyChanged, listView is null");
                return;
            }
            boolean isShowDisable = Boolean.parseBoolean(this.getModel().getValue("chkshowdisable").toString());
            ITreeListView treeListView = listView.getTreeListView();
            Map customParams = this.getView().getParentView().getFormShowParameter().getCustomParams();
            customParams.put("chkshowdisable", isShowDisable);
            treeListView.refresh();
            this.getView().sendFormAction(this.getView().getParentView());
            this.getView().close();
        }
    }
}

