/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbs.formplugin.web.foreignadminorg;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.PageMode;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tsc.tsrbs.business.domain.synrecord.SynRecordService;
import kd.tsc.tsrbs.common.enums.foreignadminorg.ForeignOrgSynStatusEnum;

public class SynedAdminOrgBtnPlugin
extends HRDynamicFormBasePlugin
implements BeforeF7SelectListener {
    private static final String SYNED_ADMIN_ORG = "synedAdminOrg";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Long tenantId = (Long)this.getView().getFormShowParameter().getCustomParam("tenantId");
        if (this.checkTenantEnable()) {
            return;
        }
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if (HRStringUtils.equals((String)"waitsyn", (String)operateKey)) {
            ListShowParameter listShowParameter = new ListShowParameter();
            listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            listShowParameter.setFormId("tsrbs_waitsynorgtreelisf7");
            listShowParameter.setBillFormId("tsrbs_waitsynadminorg");
            listShowParameter.setMultiSelect(false);
            listShowParameter.setShowTitle(false);
            listShowParameter.setPageMode(PageMode.Simplest.getPageMode());
            StyleCss styleCss = new StyleCss();
            styleCss.setWidth("960px");
            styleCss.setHeight("620px");
            listShowParameter.getOpenStyle().setInlineStyleCss(styleCss);
            ListFilterParameter listFilterParameter = this.buildFilter(tenantId);
            listShowParameter.setListFilterParameter(listFilterParameter);
            listShowParameter.setCustomParam("rootadminorg", (Object)this.getModel().getDataEntity().getLong("rootadminorg.id"));
            listShowParameter.setCustomParam("tenantId", (Object)tenantId);
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SYNED_ADMIN_ORG));
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    private ListFilterParameter buildFilter(Long tenantId) {
        DynamicObject rootAdminOrg = (DynamicObject)this.getModel().getValue("rootadminorg");
        ListFilterParameter parameter = new ListFilterParameter();
        String longNumber = rootAdminOrg.getString("longnumber");
        QFilter longNumberFilter = new QFilter("longnumber", "like", (Object)(longNumber + "%"));
        QFilter statusFilter = new QFilter("lastestsyncstatus", "in", Arrays.asList(ForeignOrgSynStatusEnum.NEW_ADD_NO_SYN.code, ForeignOrgSynStatusEnum.CHANGE_NO_SYN.code, ForeignOrgSynStatusEnum.START_NO_SYN.code, ForeignOrgSynStatusEnum.FORBIDDEN_NO_SYN.code, ForeignOrgSynStatusEnum.SYN_FAILED.code));
        QFilter idFilter = SynRecordService.getNotSynIdsFilter((Long)tenantId);
        if (idFilter != null) {
            statusFilter.and(idFilter);
        }
        parameter.setQFilters(Arrays.asList(longNumberFilter, statusFilter));
        return parameter;
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if (HRStringUtils.equals((String)"rootadminorg", (String)name)) {
            OperationResult operationResult = this.getView().invokeOperation("selectorg");
            if (operationResult.isSuccess()) {
                Long id = ((DynamicObject)beforeF7SelectEvent.getOriginalValue()).getLong("id");
                Long tenantId = (Long)this.getView().getFormShowParameter().getCustomParam("tenantId");
                DynamicObject tenant = SynRecordService.getTenantById((Long)tenantId);
                beforeF7SelectEvent.getFormShowParameter().setFormId("bos_listf7");
                beforeF7SelectEvent.addCustomQFilter(new QFilter("createorg", "=", (Object)tenant.getDynamicObject("hrorgfield").getLong("id")));
                beforeF7SelectEvent.addCustomQFilter(new QFilter("id", "!=", (Object)id));
            } else {
                beforeF7SelectEvent.setCancel(true);
                List infoList = operationResult.getAllErrorOrValidateInfo();
                if (infoList != null && infoList.size() > 0) {
                    this.getView().showErrorNotification(((IOperateInfo)infoList.get(0)).getMessage());
                }
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit rootAdminOrg = (BasedataEdit)this.getView().getControl("rootadminorg");
        rootAdminOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (HRStringUtils.equals((String)SYNED_ADMIN_ORG, (String)actionId) && (returnData = closedCallBackEvent.getReturnData()) != null && HRStringUtils.equals((String)"syndata", (String)returnData.toString())) {
            if (this.checkTenantEnable()) {
                return;
            }
            this.getView().invokeOperation("syndata");
        }
    }

    private boolean checkTenantEnable() {
        String enable;
        Long tenantId = (Long)this.getView().getFormShowParameter().getCustomParam("tenantId");
        if (tenantId != null && 0L != tenantId && (enable = SynRecordService.getTenantStatusById((Long)tenantId)).equals("0")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u751f\u6001\u4f19\u4f34\u79df\u6237\u5df2\u7981\u7528\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"SynedAdminOrgViewPlugin_7", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }
}

