/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbs.formplugin.web.foreignadminorg;

import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.list.ITreeListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.business.application.external.org.BizOrgUnitService;
import kd.tsc.tsrbs.formplugin.web.foreignadminorg.ForeignAdminOrgTreeList;

public class SynedAdminOrgTreeListPlugin
extends ForeignAdminOrgTreeList {
    private static Log LOG = LogFactory.getLog(SynedAdminOrgTreeListPlugin.class);

    @Override
    public void initialize() {
        super.initialize();
        ITreeListView treeListView = this.getTreeListView();
        if (treeListView != null) {
            this.setTreeListFilter();
        }
    }

    @Override
    public void refreshNode(RefreshNodeEvent evt) {
        this.getModel().setValue("chkshowdisable", (Object)Boolean.TRUE);
        super.refreshNode(evt);
    }

    private void setTreeListFilter() {
        List treeFilter = this.getTreeListView().getTreeModel().getTreeFilter();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long tenantId = (Long)formShowParameter.getCustomParam("tenantId");
        LOG.info("setTreeListFilter tenantId: {}", (Object)tenantId);
        QFilter filter = new QFilter("tenantid", "=", (Object)String.valueOf(tenantId));
        filter.or(new QFilter("id", "=", (Object)BizOrgUnitService.getRootOrgId()));
        treeFilter.add(filter);
    }

    @Override
    public void beforeBindData(EventObject evt) {
        Boolean chkShowDisable;
        String isInitialize = this.getPageCache().get("isinitialize");
        TreeNode root = this.getTreeModel().getRoot();
        List children = root.getChildren();
        if (children != null && children.size() > 0) {
            LOG.info("beforeBindData root: {}", (Object)root.toString());
            TreeNode firstNode = (TreeNode)children.get(0);
            LOG.info("beforeBindData firstNode: {}", (Object)firstNode);
            if (firstNode != null && firstNode.getChildren() != null && firstNode.getChildren().size() > 0) {
                this.hasLowerHandle(isInitialize, root, firstNode);
            } else if (firstNode != null && HRStringUtils.equals((String)String.valueOf(BizOrgUnitService.getRootOrgId()), (String)firstNode.getId())) {
                LOG.info("firstNode: {}", (Object)firstNode);
                root.setChildren(null);
            }
        }
        if ((chkShowDisable = (Boolean)this.getView().getFormShowParameter().getCustomParam("chkshowdisable")) != null) {
            this.getModel().setValue("chkshowdisable", (Object)chkShowDisable);
        } else {
            this.getModel().setValue("chkshowdisable", (Object)Boolean.TRUE);
        }
    }

    @Override
    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        this.getView().setVisible(Boolean.FALSE, new String[]{"btntreefilter", "toolbarap"});
    }

    private void hasLowerHandle(String isInitialize, TreeNode root, TreeNode firstNode) {
        if (HRStringUtils.equals((String)String.valueOf(BizOrgUnitService.getRootOrgId()), (String)firstNode.getId())) {
            TreeNode treeNode = (TreeNode)firstNode.getChildren().get(0);
            LOG.info("beforeBindData treeNode: {}", (Object)firstNode);
            root.setChildren(Collections.singletonList(treeNode));
            if (HRStringUtils.isNotEmpty((String)isInitialize) && HRStringUtils.equals((String)"1", (String)isInitialize)) {
                TreeView treeView = (TreeView)this.getControl("treeview");
                treeNode.setIsOpened(true);
                treeView.focusNode(treeNode);
                this.getTreeModel().setCurrentNodeId((Object)treeNode.getId());
                this.getPageCache().put("isinitialize", "0");
            }
        }
        String currentNodeId = (String)this.getTreeModel().getCurrentNodeId();
        if (!HRStringUtils.equals((String)String.valueOf(BizOrgUnitService.getRootOrgId()), (String)currentNodeId)) {
            TreeNode currentNode = root.getTreeNode(currentNodeId);
            if (HRStringUtils.equals((String)"8609760E-EF83-4775-A9FF-CCDEC7C0B689", (String)currentNode.getId())) {
                TreeNode node = (TreeNode)root.getChildren().get(0);
                node.setIsOpened(true);
                this.getTreeModel().setCurrentNodeId((Object)node.getId());
                TreeView treeView = (TreeView)this.getControl("treeview");
                treeView.focusNode(node);
            } else {
                currentNode.setIsOpened(true);
            }
        }
    }
}

