/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbs.formplugin.web.synrecord;

import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.mvc.list.ListDataProvider;
import kd.tsc.tsrbs.business.domain.synrecord.SynRecordService;

public class AdminSRListDataProvider
extends ListDataProvider {
    public DynamicObjectCollection getData(int start, int limit) {
        DynamicObjectCollection rows = super.getData(start, limit);
        if (rows.isEmpty()) {
            return rows;
        }
        DynamicProperty date = new DynamicProperty();
        DynamicProperty system = new DynamicProperty();
        DynamicProperty tenant = new DynamicProperty();
        date.setName("syndate");
        system.setName("synsystem");
        tenant.setName("syntenant");
        rows.getDynamicObjectType().addProperty(date);
        rows.getDynamicObjectType().addProperty(system);
        rows.getDynamicObjectType().addProperty(tenant);
        Map synRecordObjByBizId = SynRecordService.getSynRecordObjByBizId(rows.stream().map(dyn -> dyn.getLong("id")).collect(Collectors.toList()));
        for (DynamicObject row : rows) {
            long bizobj = row.getLong("id");
            DynamicObject synRecordObj = (DynamicObject)synRecordObjByBizId.get(bizobj);
            if (null == synRecordObj) continue;
            Date syndate = synRecordObj.getDate("syndate");
            Long syntenantId = synRecordObj.getLong("syntenant");
            String tenantName = SynRecordService.getTenantNameById((Long)syntenantId);
            String sysName = SynRecordService.getSystemNameByTenantId((Long)syntenantId);
            row.set("syndate", (Object)syndate);
            row.set("synsystem", (Object)sysName);
            row.set("syntenant", (Object)tenantName);
        }
        return rows;
    }
}

