/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbs.formplugin.web.test;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.sqlscript.PreInsDataScriptBuilder;
import kd.hr.hbp.common.util.HRStringUtils;

public class PreinsdataExportPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject evt) {
        this.addClickListeners(new String[]{"buttonap"});
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("buttonap".equals(key)) {
            this.exportKsql();
        }
    }

    private void exportKsql() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String pageNum = dataEntity.getString("metadata.number");
        if (HRStringUtils.isEmpty((String)pageNum)) {
            this.getView().showTipNotification("metadata is empty");
            return;
        }
        String whereField = dataEntity.getString("wherefield");
        if (HRStringUtils.isEmpty((String)whereField)) {
            whereField = "1=1";
        }
        StringBuilder ksqltext = new StringBuilder();
        this.genData(pageNum, whereField, ksqltext);
        CodeEdit codeSQLshow = (CodeEdit)this.getView().getControl("ksqltext");
        if (ksqltext.length() > 1000000) {
            codeSQLshow.setText(ResManager.loadKDString((String)"\u811a\u672c\u592a\u5927\uff0c\u5c06\u88ab\u622a\u65ad ...", (String)"KSQLExpPlugin_3", (String)"bos-devportal-plugin", (Object[])new Object[0]) + System.lineSeparator() + ksqltext.substring(0, 1000000));
        } else {
            codeSQLshow.setText(ksqltext.toString());
        }
    }

    private List<Object> genData(String pageNum, String whereField, StringBuilder ksqltext) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)pageNum);
        String fid = mainEntityType.getPrimaryKey().getAlias();
        QFilter filter = QFilter.sqlExpress((String)"id", (String)"in", (String)String.format("(select %s from %s where %s )", fid, mainEntityType.getAlias(), whereField));
        DynamicObject[] idDyos = BusinessDataServiceHelper.load((String)pageNum, (String)"id", (QFilter[])filter.toArray());
        if (idDyos.length == 0) {
            this.getView().showTipNotification("no output");
            return Lists.newArrayList();
        }
        List<Object> idList = Arrays.stream(idDyos).map(dynamicObject -> dynamicObject.get("id")).collect(Collectors.toList());
        String idListStr = idList.stream().map(obj -> obj instanceof Long ? obj.toString() : String.format(Locale.ROOT, "'%s'", obj)).collect(Collectors.joining(","));
        Collection entityTypes = mainEntityType.getAllEntities().values();
        for (EntityType entityType : entityTypes) {
            String tableName = entityType.getAlias();
            if (HRStringUtils.isEmpty((String)tableName)) continue;
            LinkedHashMap tableFileds = Maps.newLinkedHashMap();
            HashSet mulBaseDataSet = Sets.newHashSet();
            this.mainFieldsExport(entityType, tableName, tableFileds, mulBaseDataSet);
            this.mulLangExport(entityType, tableFileds);
            String wField = this.getWhereField(fid, idListStr, entityType);
            for (Map.Entry entry : tableFileds.entrySet()) {
                ksqltext.append(this.genKqlString(((StringBuilder)entry.getValue()).toString(), (String)entry.getKey(), wField, entityType.getDBRouteKey()));
            }
            for (IDataEntityProperty property : mulBaseDataSet) {
                String mulBaseDataFieldStr = String.format(Locale.ROOT, "fpkid,%s,fbasedataid", entityType.getPrimaryKey().getAlias());
                ksqltext.append(this.genKqlString(mulBaseDataFieldStr, ((MulBasedataProp)property).getDynamicCollectionItemPropertyType().getAlias(), wField, entityType.getDBRouteKey()));
            }
        }
        return idList;
    }

    private String getWhereField(String fid, String idListStr, EntityType entityType) {
        String wField;
        if (entityType instanceof SubEntryType) {
            IDataEntityType parent = entityType.getParent();
            String parentTable = parent.getAlias();
            String parentPkField = parent.getPrimaryKey().getAlias();
            String table = entityType.getAlias();
            String pkField = entityType.getPrimaryKey().getAlias();
            wField = String.format("%s in (select %s from %s where %s in (select %s from %s where %s in (%s)))", pkField, pkField, table, parentPkField, parentPkField, parentTable, fid, idListStr);
        } else if (entityType instanceof EntryType) {
            String table = entityType.getAlias();
            String pkField = entityType.getPrimaryKey().getAlias();
            wField = String.format(" %s in (select %s from %s where %s in (%s))", pkField, pkField, table, fid, idListStr);
        } else {
            wField = String.format("%s in (%s)", fid, idListStr);
        }
        return wField;
    }

    private void mulLangExport(EntityType entityType, Map<String, StringBuilder> tableFileds) {
        DynamicObjectType localObjectType;
        if (entityType.getLocaleProperty() != null && HRStringUtils.isNotEmpty((String)(localObjectType = entityType.getLocaleProperty().getDynamicCollectionItemPropertyType()).getAlias())) {
            StringBuilder fieldSb = new StringBuilder(entityType.getPrimaryKey().getAlias());
            for (IDataEntityProperty property : localObjectType.getProperties()) {
                String field = property.getAlias();
                if (!HRStringUtils.isNotEmpty((String)field) || property.isDbIgnore() || localObjectType.getPrimaryKey() == property) continue;
                if (fieldSb.length() != 0) {
                    fieldSb.append(",");
                }
                fieldSb.append(field);
            }
            tableFileds.put(localObjectType.getAlias(), fieldSb);
        }
    }

    private void mainFieldsExport(EntityType entityType, String tableName, Map<String, StringBuilder> tableFileds, Set<IDataEntityProperty> mulBaseDataSet) {
        for (IDataEntityProperty property : entityType.getProperties()) {
            String field = property.getAlias();
            if (!HRStringUtils.isNotEmpty((String)field) || property.isDbIgnore() || entityType.getPrimaryKey() == property) continue;
            if (property instanceof MulBasedataProp) {
                mulBaseDataSet.add(property);
                continue;
            }
            String tableGroup = property.getTableGroup();
            String tbName = tableGroup == null ? tableName : tableName + "_" + tableGroup;
            StringBuilder fieldSb = tableFileds.get(tbName);
            if (fieldSb == null) {
                String refId = entityType.getParent() == null ? "" : entityType.getParent().getPrimaryKey().getAlias();
                fieldSb = new StringBuilder(refId);
                tableFileds.put(tbName, fieldSb);
            }
            if (fieldSb.length() != 0) {
                fieldSb.append(',');
            }
            fieldSb.append(field);
            if (!(property instanceof ISimpleProperty) || !((ISimpleProperty)property).isEncrypt()) continue;
            fieldSb.append("_enp");
        }
    }

    private String genKqlString(String selectField, String fromfield, String wherefield, String routefield) {
        Map map;
        PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
        try {
            map = builder.genInsertSQLScript(DBRoute.of((String)routefield), fromfield, selectField, wherefield, "", "");
        }
        catch (Exception var48) {
            throw new KDBizException((Throwable)var48, BosErrorCode.bOS, new Object[]{String.format("ErrorFormField:%s,KSQLExpPlugin Error:%s.", fromfield, var48.getMessage())});
        }
        return map.get("sql").toString();
    }
}

