/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrbs.formplugin.web.test;

import java.util.EventObject;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.sqlscript.PreInsDataScriptBuilder;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class ScriptExportPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(ScriptExportPlugin.class);

    public void registerListener(EventObject evt) {
        this.addClickListeners(new String[]{"buttonap"});
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("buttonap".equals(key)) {
            this.execScript();
        }
    }

    private void execScript() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String pageNumStr = dataEntity.getString("inputcontent");
        if (HRStringUtils.isEmpty((String)pageNumStr)) {
            this.getView().showTipNotification("input is not Empty");
            return;
        }
        String exptype = dataEntity.getString("exptype");
        String[] pageNums = pageNumStr.split(",");
        logger.info("pages:{},expType:{}", (Object)pageNums, (Object)exptype);
        StringBuilder ksqltext = new StringBuilder();
        block8: for (String pageNum : pageNums) {
            switch (exptype) {
                case "1": {
                    ksqltext.append(this.genCodeRuleKSql(pageNum));
                    continue block8;
                }
                case "2": {
                    ksqltext.append(this.genDeleteSql(pageNum));
                    continue block8;
                }
            }
        }
        CodeEdit codeSQLshow = (CodeEdit)this.getView().getControl("ksqltext");
        if (ksqltext.length() > 1000000) {
            codeSQLshow.setText(ResManager.loadKDString((String)"\u811a\u672c\u592a\u5927\uff0c\u5c06\u88ab\u622a\u65ad ...", (String)"KSQLExpPlugin_3", (String)"bos-devportal-plugin", (Object[])new Object[0]) + System.lineSeparator() + ksqltext.substring(0, 1000000));
        } else {
            codeSQLshow.setText(ksqltext.toString());
        }
    }

    private String genCodeRuleKSql(String pageNum) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("bos_coderule");
        DynamicObject dynamicObject = helper.queryOne(new QFilter("bizobjectid", "=", (Object)pageNum).toArray());
        if (dynamicObject == null) {
            this.getView().showTipNotification(String.format(Locale.ROOT, "coderule of %s is Empty", pageNum));
            return "";
        }
        String routefield = "sys";
        String selectField = "FID, FNUMBER, FRULETYPE, FBIZOBJECTID, FSPLITSIGN, FCTRLMODE, FAPPMODE, FEXAMPLE, FEXAMPLELENGTH, FENABLE, FSTATUS, FCREATORID, FCREATETIME, FMODIFIERID, FMODIFYTIME, FDISABLERID, FDISABLEDATE, FMASTERID, FISUPDATERECOVER, FISNONBREAK, FISCHECKCODE, FISAPPCONDITION, FISAPPORG, FISLOG, FISSERIALNUMBER, FISUNIQUE, FISMODIFIABLE, FISADDVIEW, FISFAST";
        String fromfield = "T_CR_CODERULE";
        String id = dynamicObject.getString("id");
        String wherefield = "FID = '" + id + "'";
        StringBuilder sqlsb = new StringBuilder();
        sqlsb.append("/**").append(pageNum).append(" coderule preinsdata export**/\n");
        sqlsb.append(this.genKqlString(selectField, fromfield, wherefield, routefield));
        selectField = "FPKID, FID, FLOCALEID, FNAME";
        fromfield = "T_CR_CODERULE_L";
        sqlsb.append(this.genKqlString(selectField, fromfield, wherefield, routefield));
        selectField = "FENTRYID, FID, FSEQ, FATTRIBUTETYPE, FATTUSINGMODE, FVALUEATRIBUTE, FFORMAT, FSETTINGVALUE, FLENGTH, FINITIAL, FSTEP, FADDCHAR, FISSPLITSIGN, FADDSTYLE, FCUTSTYLE, FISSORTITEM, FSPLITSIGN, FISVISABLE";
        fromfield = "t_cr_coderuleentry";
        sqlsb.append(this.genKqlString(selectField, fromfield, wherefield, routefield));
        selectField = "fentryid, fid, fseq, fproperty, fpropertyvalue";
        fromfield = "t_cr_appcondition";
        sqlsb.append(this.genKqlString(selectField, fromfield, wherefield, routefield));
        selectField = "fentryid, fid, fseq, forgid, fisincludesuborg";
        fromfield = "t_cr_apporg";
        sqlsb.append(this.genKqlString(selectField, fromfield, wherefield, routefield));
        selectField = "fid, fbizobjectid, fnumber";
        fromfield = "t_cr_appcondpro";
        wherefield = String.format(Locale.ROOT, "fid in(select FPROPERTY from t_cr_appcondition where fid = '%s')", id);
        sqlsb.append(this.genKqlString(selectField, fromfield, wherefield, routefield));
        selectField = "fpkid, fid, flocaleid, fname, fdescription";
        fromfield = "t_cr_appcondpro_l";
        sqlsb.append(this.genKqlString(selectField, fromfield, wherefield, routefield));
        selectField = "fid, fappcondproid, fvalue";
        fromfield = "t_cr_appcondprovalue";
        wherefield = String.format(Locale.ROOT, "fid in(select FPROPERTYVALUE from t_cr_appcondition where fid = '%s')", id);
        sqlsb.append(this.genKqlString(selectField, fromfield, wherefield, routefield));
        selectField = "fpkid, fid, flocaleid, fname, fdescription";
        fromfield = "t_cr_appcondprovalue_l";
        sqlsb.append(this.genKqlString(selectField, fromfield, wherefield, routefield));
        selectField = "fid, fcoderuleid, fseqsegmententryid, fsortitemvalue, fserial, fcreatorid, fcreatetime, fmodifierid, fmodifytime";
        fromfield = "t_cr_intermitno";
        wherefield = "FCODERULEID = '" + id + "'";
        sqlsb.append(this.genKqlString(selectField, fromfield, wherefield, routefield));
        selectField = "fid, fcoderuleid, fseqsegmententryid, fsortitemvalue, fmaxserial, finitserial, fcreatorid, fcreatetime, fmodifierid, fmodifytime";
        fromfield = "t_cr_maxserial";
        sqlsb.append(this.genKqlString(selectField, fromfield, wherefield, routefield));
        selectField = "fid, fcoderuleid, fattrnumber";
        fromfield = "t_cr_seqsegment";
        sqlsb.append(this.genKqlString(selectField, fromfield, wherefield, routefield));
        selectField = "fentryid, fid, fseq, fattributeid, fbeginnum, fendnum";
        fromfield = "t_cr_seqsegmententry";
        wherefield = String.format(Locale.ROOT, "fid in(select fid from t_cr_seqsegment where FCODERULEID = '%s')", id);
        sqlsb.append(this.genKqlString(selectField, fromfield, wherefield, routefield));
        sqlsb.append('\n');
        return sqlsb.toString();
    }

    private String genKqlString(String selectField, String fromfield, String wherefield, String routefield) {
        Map map;
        PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
        try {
            map = builder.genInsertSQLScript(DBRoute.of((String)routefield), fromfield, selectField, wherefield, "", "");
        }
        catch (Exception var48) {
            throw new KDBizException((Throwable)var48, BosErrorCode.bOS, new Object[]{String.format(Locale.ROOT, "KSQLExpPlugin Error:%s.", var48.getMessage())});
        }
        return map.get("sql").toString();
    }

    private String genDeleteSql(String pageNum) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("bos_formmeta");
        DynamicObject dynamicObject = helper.queryOne(new QFilter("number", "=", (Object)pageNum).toArray());
        if (dynamicObject == null) {
            this.getView().showTipNotification(String.format(Locale.ROOT, "metadata of %s is Empty", pageNum));
            return "";
        }
        StringBuilder deleteSql = new StringBuilder();
        String fid = dynamicObject.getString("id");
        deleteSql.append(ResManager.loadKDString((String)"/* \u9875\u9762\u5143\u6570\u636e ", (String)"", (String)"", (Object[])new Object[0])).append(pageNum).append(ResManager.loadKDString((String)"\u7684\u5220\u9664\u811a\u672c */", (String)"", (String)"", (Object[])new Object[0])).append("\n ");
        String endEOFStr = "';\n ";
        deleteSql.append("DELETE FROM T_META_BIZUNITRELFORM where FFORMID = '").append(fid).append(endEOFStr);
        deleteSql.append("DELETE FROM T_META_FORMDESIGN where FID = '").append(fid).append(endEOFStr);
        deleteSql.append("DELETE FROM T_META_FORMDESIGN_L where FID = '").append(fid).append(endEOFStr);
        deleteSql.append("DELETE FROM T_META_ENTITYDESIGN where FID = '").append(fid).append(endEOFStr);
        deleteSql.append("DELETE FROM T_META_ENTITYDESIGN_L where FID = '").append(fid).append(endEOFStr);
        deleteSql.append("DELETE FROM T_META_FORM where FID = '").append(fid).append(endEOFStr);
        deleteSql.append("DELETE FROM T_META_ENTITY where FID = '").append(fid).append(endEOFStr);
        deleteSql.append("DELETE FROM T_META_ENTITYINFO where FID = '").append(pageNum).append(endEOFStr);
        deleteSql.append("DELETE FROM T_META_MAINENTITYINFO where FID = '").append(pageNum).append(endEOFStr);
        deleteSql.append("DELETE FROM T_META_MAINENTITYINFO_L where FID = '").append(pageNum).append("';\n\n ");
        deleteSql.append('\n');
        return deleteSql.toString();
    }
}

