/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrsc.formplugin.web.appfile;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.AutoReleaseLock;
import kd.bos.mutex.impl.MutexLockInfo;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tsc.tso.common.enums.offer.status.OfferStatus;
import kd.tsc.tspr.business.domain.appfile.AppFileDataHelper;
import kd.tsc.tspr.business.domain.appfile.AppFileHelper;
import kd.tsc.tspr.business.domain.appfile.AppFileResManagerHelper;
import kd.tsc.tspr.business.domain.appfile.form.AppFileFormHelper;
import kd.tsc.tspr.business.domain.appfile.form.AppFileTabHelper;
import kd.tsc.tsrbd.business.domain.rsmmetadata.service.ResumeMetadataService;
import kd.tsc.tsrbs.common.enums.DeleteEnum;

public class AppFileEdit
extends HRDataBaseEdit {
    private static final Log LOG = LogFactory.getLog(AppFileEdit.class);
    public static final String KEY_TABORIGINRSM = "taboriginrsm";
    private static final String KEY_ORIGINRESFLEX = "originresflex";
    private static final String KEY_FLEXAPPRSM = "flexapprsm";
    private static final String KEY_FLEXARFRSM = "flexarfrsm";
    private static final String KEY_APPRES_PAGE = "apprespageid";
    private static final String KEY_TABOFFER = "taboffer";
    private Boolean isInProcess = Boolean.FALSE;
    private String fileStatus = null;
    private OperationStatus subViewStatus = OperationStatus.VIEW;
    private static final String KEY_APPLYOFFER = "applyoffer";
    private static final String KEY_APPLYEMP = "applyemp";

    public void preOpenForm(PreOpenFormEventArgs args) {
        String name;
        DynamicObject appFile;
        Long pkId;
        BillShowParameter showParameter = (BillShowParameter)args.getFormShowParameter();
        if (showParameter.getPkId() == null && showParameter.getCustomParam("id") != null) {
            pkId = Long.valueOf((String)showParameter.getCustomParam("id"));
            showParameter.setPkId((Object)pkId);
        }
        if (showParameter.getPkId() != null && (appFile = AppFileDataHelper.queryAppFileById((Object)(pkId = Long.valueOf(showParameter.getPkId().toString())))) != null && HRStringUtils.isNotEmpty((String)(name = appFile.getString("name")))) {
            if (name.length() > 8) {
                name = name.substring(0, 8) + "...";
            }
            showParameter.setCaption(String.format(Locale.ROOT, AppFileResManagerHelper.getAppFileTabName(), name));
        }
    }

    public void beforeBindData(EventObject evt) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        this.fileStatus = dataEntity.getString("filestatus");
        this.isInProcess = AppFileHelper.isInProcess((String)this.fileStatus);
        String parentKey = (String)this.getView().getFormShowParameter().getCustomParam("parent_key");
        if (parentKey != null) {
            this.getView().getPageCache().put("parent_key", parentKey);
        } else {
            this.getView().getPageCache().put("parent_key", this.getView().getParentView().getFormShowParameter().getFormId());
        }
        if (this.isInProcess.booleanValue()) {
            Object isOnlyView = this.getView().getFormShowParameter().getCustomParam("isOnlyView");
            if (null != isOnlyView) {
                this.subViewStatus = OperationStatus.VIEW;
                this.getView().getPageCache().put("parent_key", "tsrbs_commrec");
            } else {
                this.subViewStatus = this.getView().getFormShowParameter().getStatus();
            }
        }
    }

    public void afterBindData(EventObject evt) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        this.initPanel(dataEntity);
        this.initTab();
    }

    public void afterLoadData(EventObject evt) {
        super.afterLoadData(evt);
        this.handleBtn();
    }

    private void handleBtn() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String fromPage = (String)customParams.get("fromPage");
        if (HRStringUtils.equals((String)fromPage, (String)"createOfferPage") || HRStringUtils.equals((String)fromPage, (String)"createInducInfoPage")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_applyoffer", "btn_applyemp"});
            return;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrsc_appfile_viewmabr");
        DynamicObject appfileDy = serviceHelper.queryOne((Object)this.getModel().getDataEntity().getLong("id"));
        if (HRObjectUtils.isEmpty((Object)appfileDy)) {
            return;
        }
        long offerStatusId = appfileDy.getLong("offer.status.id");
        String inductionStatus = appfileDy.getString("inductioninfo.inductionstatus");
        if (offerStatusId != 0L && offerStatusId != 1010040L && offerStatusId != 1010050L) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_applyoffer"});
        } else if (!HRStringUtils.isEmpty((String)inductionStatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_applyoffer"});
        }
        long offerLetterStatusId = appfileDy.getLong("offerletter.datastatus.id");
        long offerReplyStatusId = appfileDy.getLong("offerletter.replystatus.id");
        if (!(offerStatusId == 0L && HRStringUtils.isEmpty((String)inductionStatus) || offerLetterStatusId == 1030020L && offerReplyStatusId == 1040030L && HRStringUtils.isEmpty((String)inductionStatus))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_applyemp"});
        }
    }

    private void initPanel(DynamicObject dataEntity) {
        AppFileFormHelper.showAppFileHeaderForm((IFormView)this.getView(), (long)dataEntity.getLong("id"), (String)"flex_head", (String)"5", null);
    }

    private void initTab() {
        DynamicObject arf;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Long appFileId = dataEntity.getLong("id");
        DynamicObject appRes = dataEntity.getDynamicObject("appres");
        if (!HRObjectUtils.isEmpty((Object)appRes)) {
            AppFileTabHelper.previewOriginalResume((Object)dataEntity.getPkValue(), (String)KEY_TABORIGINRSM, (DynamicObject)appRes, (String)KEY_ORIGINRESFLEX, (IFormView)this.getView(), (boolean)false);
            Long recrutyp = Optional.ofNullable(dataEntity.getDynamicObject("recrutyp")).map(dynamicObject -> dynamicObject.getLong("id")).orElse(0L);
            String mainEntityKey = ResumeMetadataService.getMainEntityKey((String)"5", (Long)recrutyp, (String)dataEntity.getString("tpsys"), (boolean)true);
            if (HRStringUtils.isNotEmpty((String)mainEntityKey)) {
                AppFileTabHelper.showAppResPage((String)KEY_FLEXAPPRSM, (String)KEY_APPRES_PAGE, (AbstractFormPlugin)this, (DynamicObject)appRes, (OperationStatus)OperationStatus.VIEW, (String)mainEntityKey);
            }
        }
        if (!HRObjectUtils.isEmpty((Object)(arf = dataEntity.getDynamicObject("arfrsm")))) {
            BaseShowParameter arfShowParameter = new BaseShowParameter();
            arfShowParameter.setPkId(arf.getPkValue());
            arfShowParameter.setFormId("tstpm_srscarfmrsm");
            arfShowParameter.setStatus(this.subViewStatus);
            arfShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
            arfShowParameter.setSendToClient(true);
            arfShowParameter.getOpenStyle().setTargetKey(KEY_FLEXARFRSM);
            this.getView().showForm((FormShowParameter)arfShowParameter);
        }
        AppFileTabHelper.initInterviewAssessTab((String)"panel_interview", (long)appFileId, (IFormView)this.getView(), (boolean)false);
        AppFileEdit.initOfferTab(KEY_TABOFFER, dataEntity, this.getView());
    }

    public static void initOfferTab(String targetKey, DynamicObject dataEntity, IFormView view) {
        Boolean isShowOffer = Boolean.FALSE;
        try {
            isShowOffer = (Boolean)DispatchServiceHelper.invokeBizService((String)"tsc", (String)"tso", (String)"offerBaseServiceApi", (String)"hasOfferData", (Object[])new Object[]{dataEntity.getLong("id")});
        }
        catch (Exception ex) {
            LOG.error("offerBaseServiceApi.hasOfferData.error:", (Throwable)ex);
            view.showErrorNotification("offerBaseServiceApi.hasOfferData.error");
        }
        if (isShowOffer.booleanValue()) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("tso_somk_offerinfonoact");
            showParameter.setCustomParam("appfile", (Object)dataEntity.getLong("id"));
            showParameter.getOpenStyle().setShowType(ShowType.InContainer);
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.getOpenStyle().setTargetKey(targetKey);
            showParameter.setSendToClient(true);
            view.showForm(showParameter);
        }
        view.setVisible(isShowOffer, new String[]{targetKey});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tspr_appfile");
        DynamicObject appFileDy = serviceHelper.queryOne("id,isdelete", this.getModel().getDataEntity().getPkValue());
        if ((HRStringUtils.equals((String)operateKey, (String)KEY_APPLYOFFER) || HRStringUtils.equals((String)operateKey, (String)KEY_APPLYEMP)) && !HRObjectUtils.isEmpty((Object)appFileDy) && appFileDy.getBoolean("isdelete")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5019\u9009\u4eba\u6570\u636e\u5df2\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u6570\u636e\u3002", (String)"AppFileEdit_0", (String)"tsc-tsrsc-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (HRStringUtils.equals((String)operateKey, (String)KEY_APPLYOFFER) || HRStringUtils.equals((String)operateKey, (String)KEY_APPLYEMP)) {
            this.updateOfferId();
        }
    }

    private void updateOfferId() {
        if (this.getModel().getDataEntity().getLong("offer.id") != 0L) {
            return;
        }
        HRBaseServiceHelper offerServiceHelper = new HRBaseServiceHelper("tso_somk_offerbase");
        ArrayList<Long> statusIds = new ArrayList<Long>(4);
        statusIds.add(OfferStatus.PRE_APPLY.getCode());
        statusIds.add(OfferStatus.APPLYING.getCode());
        statusIds.add(OfferStatus.APPLY_PASS.getCode());
        statusIds.add(OfferStatus.APPLY_TERM.getCode());
        QFilter offerStatusQfilter = new QFilter("status.id", "in", statusIds);
        QFilter appfileIdsQfilter = new QFilter("appfile.id", "=", (Object)this.getModel().getDataEntity().getLong("id"));
        QFilter deleteQfilter = new QFilter("isdelete", "=", (Object)DeleteEnum.NO_DELETE.getCode());
        DynamicObject offerDy = offerServiceHelper.queryOne("id,status.id,appfile.id,offerletter.id,isdelete", new QFilter[]{offerStatusQfilter, appfileIdsQfilter, deleteQfilter});
        if (HRObjectUtils.isEmpty((Object)offerDy)) {
            return;
        }
        this.getModel().getDataEntity().set("offer", offerDy.get("id"));
        this.getModel().getDataEntity().set("offerletter", offerDy.get("offerletter.id"));
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrsc_appfile_viewmabr");
        serviceHelper.updateOne(this.getModel().getDataEntity());
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)KEY_APPLYOFFER) && args.getOperationResult().isSuccess()) {
            if (!this.validateMutex("tso_somk_waitofferbase", operateKey)) {
                return;
            }
            BaseShowParameter formShowParameter = new BaseShowParameter();
            this.cacheParentView(formShowParameter, operateKey);
            formShowParameter.setFormId("tso_somk_waitofferbase");
            formShowParameter.setStatus(OperationStatus.ADDNEW);
            formShowParameter.setCustomParam("fromPage", (Object)"appFilePage");
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tspr_appfile");
            DynamicObject appFileDy = serviceHelper.queryOne("id,createorg.id,createorg.name,name", this.getModel().getDataEntity().getPkValue());
            if (!HRObjectUtils.isEmpty((Object)appFileDy)) {
                formShowParameter.setCustomParam("busunit.name", (Object)appFileDy.getString("createorg.name"));
                formShowParameter.setCustomParam("name", (Object)appFileDy.getString("name"));
            }
            formShowParameter.setCustomParam("appfile", this.getModel().getDataEntity().getPkValue());
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)formShowParameter);
        } else if (HRStringUtils.equals((String)operateKey, (String)KEY_APPLYEMP) && args.getOperationResult().isSuccess()) {
            if (!this.validateMutex("tso_inductioninfo", operateKey)) {
                return;
            }
            BaseShowParameter formShowParameter = new BaseShowParameter();
            this.cacheParentView(formShowParameter, operateKey);
            formShowParameter.setFormId("tso_inductioninfo");
            formShowParameter.setStatus(OperationStatus.ADDNEW);
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.setCustomParam("appfile", this.getModel().getDataEntity().getPkValue());
            formShowParameter.setCustomParam("fromPage", (Object)"appFilePage");
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrsc_appfile_viewmabr");
            DynamicObject appFileDy = serviceHelper.queryOne("id,createorg.id,createorg.name,name,offer", this.getModel().getDataEntity().getPkValue());
            if (!HRObjectUtils.isEmpty((Object)appFileDy)) {
                formShowParameter.setCustomParam("busunit.name", (Object)appFileDy.getString("createorg.name"));
                formShowParameter.setCustomParam("name", (Object)appFileDy.getString("name"));
                DynamicObject offerDy = appFileDy.getDynamicObject("offer");
                if (!HRObjectUtils.isEmpty((Object)offerDy)) {
                    formShowParameter.setCustomParam("offerId", (Object)offerDy.getLong("id"));
                }
            }
            this.getView().showForm((FormShowParameter)formShowParameter);
        }
    }

    private void cacheParentView(BaseShowParameter formShowParameter, String operateKey) {
        if (this.getView().getParentView() == null) {
            return;
        }
        if (this.getView().getParentView().getParentView() == null) {
            return;
        }
        if (this.getView().getParentView().getParentView().getFormShowParameter().getFormId().contains("apphome")) {
            Object pageId = this.getView().getParentView().getParentView().getFormShowParameter().getCustomParam(operateKey + "-" + this.getModel().getDataEntity().getPkValue());
            if (pageId != null) {
                IFormView view = SessionManager.getCurrent().getView(pageId.toString());
                if (view == null) {
                    this.getView().getParentView().getParentView().getFormShowParameter().setCustomParam(operateKey + "-" + this.getModel().getDataEntity().getPkValue(), (Object)formShowParameter.getPageId());
                    this.getView().getParentView().getParentView().cacheFormShowParameter();
                    return;
                }
                if (view.getFormShowParameter().getStatus() == OperationStatus.ADDNEW) {
                    formShowParameter.setPageId(pageId.toString());
                } else {
                    this.getView().getParentView().getParentView().getFormShowParameter().setCustomParam(operateKey + "-" + this.getModel().getDataEntity().getPkValue(), (Object)formShowParameter.getPageId());
                    this.getView().getParentView().getParentView().cacheFormShowParameter();
                }
            } else {
                this.getView().getParentView().getParentView().getFormShowParameter().setCustomParam(operateKey + "-" + this.getModel().getDataEntity().getPkValue(), (Object)formShowParameter.getPageId());
                this.getView().getParentView().getParentView().cacheFormShowParameter();
            }
        }
    }

    private boolean validateMutex(String formId, String operateKey) {
        StringBuilder stringBuilder = new StringBuilder();
        MutexLockInfo lockInfo = new MutexLockInfo();
        lockInfo.setEntityNumber(formId);
        lockInfo.setDataObjId(this.getModel().getDataEntity().getString("id"));
        lockInfo.setOperationKey(operateKey);
        lockInfo.setStrict(false);
        boolean isMutex = MutexHelper.require((MutexLockInfo)lockInfo, (StringBuilder)stringBuilder);
        if (!isMutex) {
            this.getView().showTipNotification(stringBuilder.toString());
            return false;
        }
        AutoReleaseLock.create().register(lockInfo.getDataObjId(), lockInfo.getEntityNumber(), lockInfo.getOperationKey());
        return true;
    }
}

