/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrsc.formplugin.web.appfile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.list.IListView;
import kd.bos.mutex.AutoReleaseLock;
import kd.bos.mutex.impl.MutexLockInfo;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.business.domain.offer.service.OfferSalaryService;
import kd.tsc.tso.business.domain.offer.service.paramconfig.OfferParamConfigService;
import kd.tsc.tso.common.enums.offer.status.OfferLetterReplyStatus;
import kd.tsc.tso.common.enums.offer.status.OfferLetterStatus;
import kd.tsc.tso.common.enums.offer.status.OfferStatus;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeAnalysisHelper;
import kd.tsc.tsrbs.common.enums.DeleteEnum;

public class AppFileList
extends HRDataBaseList {
    private static final String KEY_APPLYOFFER = "applyoffer";
    private static final String KEY_APPLYEMP = "applyemp";
    private static final String FIELD_OFFER_NUMBER = "offer_number";
    private static final String FIELD_INDUCTIONINFO_NUMBER = "inductioninfo_number";

    public void setFilter(SetFilterEvent evt) {
        super.setFilter(evt);
        evt.getQFilters().add(new QFilter("isdelete", "=", (Object)DeleteEnum.NO_DELETE.getCode()));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)KEY_APPLYOFFER)) {
            IFormView view = this.getView();
            if (view instanceof IListView) {
                IListView listView = (IListView)view;
                ListSelectedRowCollection selectedRows = listView.getSelectedRows();
                if (selectedRows.size() > 1) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u4e2a\u5019\u9009\u4eba\u7533\u8bf7Offer\u3002", (String)"AppFileList_0", (String)"tsc-tsrsc-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                String salaryDetType = OfferParamConfigService.getInstance().getSalaryDetType();
                String message = new OfferSalaryService().verifyHasPerm(Long.valueOf(0L), "tso_somk_waitofferbase");
                if (!HRStringUtils.isEmpty((String)message) && "2".equals(salaryDetType)) {
                    this.getView().showErrorNotification(message);
                    args.setCancel(true);
                    return;
                }
                if (this.validateAppFileIsDelete(args)) {
                    return;
                }
                this.updateOfferId();
            }
        } else if (HRStringUtils.equals((String)operateKey, (String)KEY_APPLYEMP)) {
            IFormView view = this.getView();
            if (view instanceof IListView) {
                IListView listView = (IListView)view;
                ListSelectedRowCollection selectedRows = listView.getSelectedRows();
                if (selectedRows.size() > 1) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u4e2a\u5019\u9009\u4eba\u7533\u8bf7\u5165\u804c\u3002", (String)"AppFileList_1", (String)"tsc-tsrsc-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (this.validateAppFileIsDelete(args)) {
                    return;
                }
                this.updateOfferId();
            }
        } else if (HRStringUtils.equals((String)operateKey, (String)"delete")) {
            if (this.getSelectedRows().size() > 20) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ef\u6279\u91cf\u5220\u9664\u6700\u591a20\u6761\u6570\u636e\u3002", (String)"AppFileList_5", (String)"tsc-tsrsc-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (this.validateAppFileIsDelete(args)) {
                return;
            }
            this.updateOfferIdByDeleteOp();
        }
    }

    private void updateOfferIdByDeleteOp() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrsc_appfile_viewmabr");
        Object[] appFileDys = serviceHelper.loadDynamicObjectArray(this.getSelectedRows().getPrimaryKeyValues());
        if (HRArrayUtils.isEmpty((Object[])appFileDys)) {
            return;
        }
        List appFileIds = Arrays.stream(appFileDys).filter(dy -> !dy.getBoolean("isdelete") && dy.getLong("offer.id") == 0L).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        if (HRCollUtil.isEmpty(appFileIds)) {
            return;
        }
        HRBaseServiceHelper offerServiceHelper = new HRBaseServiceHelper("tso_somk_offerbase");
        ArrayList<Long> statusIds = new ArrayList<Long>(4);
        statusIds.add(OfferStatus.PRE_APPLY.getCode());
        statusIds.add(OfferStatus.APPLYING.getCode());
        statusIds.add(OfferStatus.APPLY_PASS.getCode());
        statusIds.add(OfferStatus.APPLY_TERM.getCode());
        QFilter offerStatusQfilter = new QFilter("status.id", "in", statusIds);
        QFilter appfileIdsQfilter = new QFilter("appfile.id", "in", appFileIds);
        QFilter deleteQfilter = new QFilter("isdelete", "=", (Object)DeleteEnum.NO_DELETE.getCode());
        Object[] offerDys = offerServiceHelper.query("id,status.id,appfile.id,offerletter.id,isdelete", new QFilter[]{offerStatusQfilter, appfileIdsQfilter, deleteQfilter});
        if (HRArrayUtils.isEmpty((Object[])offerDys)) {
            return;
        }
        Map idToAppfileDyMaps = Arrays.stream(appFileDys).filter(dy -> !dy.getBoolean("isdelete") && dy.getLong("offer.id") == 0L).collect(Collectors.toMap(dy -> dy.getLong("id"), Function.identity()));
        DynamicObjectCollection newAppFileCol = new DynamicObjectCollection();
        Arrays.stream(offerDys).forEach(offerDy -> {
            long appfileId = offerDy.getLong("appfile.id");
            DynamicObject appFileDy = (DynamicObject)idToAppfileDyMaps.get(appfileId);
            if (HRObjectUtils.isEmpty((Object)appFileDy)) {
                return;
            }
            appFileDy.set("offer", offerDy.get("id"));
            appFileDy.set("offerletter", offerDy.get("offerletter.id"));
            newAppFileCol.add((Object)appFileDy);
        });
        serviceHelper.update((DynamicObject[])newAppFileCol.toArray((Object[])new DynamicObject[0]));
    }

    private boolean validateAppFileIsDelete(BeforeDoOperationEventArgs args) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tspr_appfile");
        DynamicObject appFileDy = serviceHelper.queryOne("id,isdelete", this.getFocusRowPkId());
        if (!HRObjectUtils.isEmpty((Object)appFileDy) && appFileDy.getBoolean("isdelete")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5019\u9009\u4eba\u6570\u636e\u5df2\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u6570\u636e\u3002", (String)"AppFileList_6", (String)"tsc-tsrsc-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return true;
        }
        return false;
    }

    private void updateOfferId() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrsc_appfile_viewmabr");
        DynamicObject appFileDy = serviceHelper.queryOne(this.getFocusRowPkId());
        if (appFileDy.getLong("offer.id") != 0L) {
            return;
        }
        HRBaseServiceHelper offerServiceHelper = new HRBaseServiceHelper("tso_somk_offerbase");
        ArrayList<Long> statusIds = new ArrayList<Long>(4);
        statusIds.add(OfferStatus.PRE_APPLY.getCode());
        statusIds.add(OfferStatus.APPLYING.getCode());
        statusIds.add(OfferStatus.APPLY_PASS.getCode());
        statusIds.add(OfferStatus.APPLY_TERM.getCode());
        QFilter offerStatusQfilter = new QFilter("status.id", "in", statusIds);
        QFilter appfileIdsQfilter = new QFilter("appfile.id", "=", this.getFocusRowPkId());
        QFilter deleteQfilter = new QFilter("isdelete", "=", (Object)DeleteEnum.NO_DELETE.getCode());
        DynamicObject offerDy = offerServiceHelper.queryOne("id,status.id,appfile.id,offerletter.id,isdelete", new QFilter[]{offerStatusQfilter, appfileIdsQfilter, deleteQfilter});
        if (HRObjectUtils.isEmpty((Object)offerDy)) {
            return;
        }
        appFileDy.set("offer", offerDy.get("id"));
        appFileDy.set("offerletter", offerDy.get("offerletter.id"));
        serviceHelper.updateOne(appFileDy);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ((HRStringUtils.equals((String)operateKey, (String)KEY_APPLYOFFER) || HRStringUtils.equals((String)operateKey, (String)KEY_APPLYEMP) || HRStringUtils.equals((String)operateKey, (String)"delete")) && !args.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("refresh");
            return;
        }
        if (HRStringUtils.equals((String)operateKey, (String)KEY_APPLYOFFER) && args.getOperationResult().isSuccess()) {
            if (!this.validateMutex("tso_somk_waitofferbase", operateKey)) {
                return;
            }
            BaseShowParameter formShowParameter = new BaseShowParameter();
            this.cacheParentView(formShowParameter, operateKey);
            formShowParameter.setFormId("tso_somk_waitofferbase");
            formShowParameter.setStatus(OperationStatus.ADDNEW);
            formShowParameter.setCustomParam("fromPage", (Object)"appFilePage");
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tspr_appfile");
            DynamicObject appFileDy = serviceHelper.queryOne("id,createorg.id,createorg.name,name", this.getFocusRowPkId());
            if (!HRObjectUtils.isEmpty((Object)appFileDy)) {
                formShowParameter.setCustomParam("busunit.name", (Object)appFileDy.getString("createorg.name"));
                formShowParameter.setCustomParam("name", (Object)appFileDy.getString("name"));
            }
            formShowParameter.setCustomParam("appfile", this.getFocusRowPkId());
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)formShowParameter);
        } else if (HRStringUtils.equals((String)operateKey, (String)KEY_APPLYEMP) && args.getOperationResult().isSuccess()) {
            if (!this.validateMutex("tso_inductioninfo", operateKey)) {
                return;
            }
            BaseShowParameter formShowParameter = new BaseShowParameter();
            this.cacheParentView(formShowParameter, operateKey);
            formShowParameter.setFormId("tso_inductioninfo");
            formShowParameter.setStatus(OperationStatus.ADDNEW);
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.setCustomParam("appfile", this.getFocusRowPkId());
            formShowParameter.setCustomParam("fromPage", (Object)"appFilePage");
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrsc_appfile_viewmabr");
            DynamicObject appFileDy = serviceHelper.queryOne("id,createorg.id,createorg.name,name,offer", this.getFocusRowPkId());
            if (!HRObjectUtils.isEmpty((Object)appFileDy)) {
                long statusId;
                formShowParameter.setCustomParam("busunit.name", (Object)appFileDy.getString("createorg.name"));
                formShowParameter.setCustomParam("name", (Object)appFileDy.getString("name"));
                DynamicObject offerDy = appFileDy.getDynamicObject("offer");
                if (!HRObjectUtils.isEmpty((Object)offerDy) && (statusId = offerDy.getLong("status.id")) != 0L && statusId != OfferStatus.ALR_DISCARD.getCode()) {
                    formShowParameter.setCustomParam("offerId", (Object)offerDy.getLong("id"));
                }
            }
            this.getView().showForm((FormShowParameter)formShowParameter);
        } else if (HRStringUtils.equals((String)operateKey, (String)"delete")) {
            this.getView().invokeOperation("refresh");
            if (args.getOperationResult().isSuccess()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"AppFileList_4", (String)"tsc-tsrsc-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void beforePackageData(BeforePackageDataEvent evt) {
        super.beforePackageData(evt);
        DynamicObjectCollection pageData = evt.getPageData();
        Map<String, Long> idToOfferIdMaps = pageData.stream().collect(Collectors.toMap(dy -> dy.getString("id"), dy -> dy.getLong("offer.id")));
        this.getView().getPageCache().put("idToOfferIdMapsCache", SerializationUtils.toJsonString(idToOfferIdMaps));
        Map<String, Long> idToInductinInfoMaps = pageData.stream().collect(Collectors.toMap(dy -> dy.getString("id"), dy -> dy.getLong("inductioninfo.id")));
        this.getView().getPageCache().put("idToInductinInfoMapsCache", SerializationUtils.toJsonString(idToInductinInfoMaps));
    }

    public void packageData(PackageDataEvent evt) {
        super.packageData(evt);
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)evt.getSource();
        String fieldKey = columnDesc.getFieldKey();
        if (HRStringUtils.equals((String)fieldKey, (String)"workage")) {
            DynamicObject rowData = evt.getRowData();
            if (HRObjectUtils.isEmpty((Object)rowData)) {
                return;
            }
            int workAge = rowData.getInt("appres.workingyears");
            String workYearShow = ResumeAnalysisHelper.getWorkYearShow((int)workAge);
            evt.setFormatValue((Object)workYearShow);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fieldName = args.getFieldName();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrsc_appfile_viewmabr");
        DynamicObject appfileDy = serviceHelper.queryOne("id,offer,inductioninfo,isdelete", this.getFocusRowPkId());
        if (HRStringUtils.equals((String)fieldName, (String)FIELD_OFFER_NUMBER)) {
            args.setCancel(true);
            if (this.validataOffer(appfileDy)) {
                return;
            }
            this.showOfferPage(appfileDy);
        } else if (HRStringUtils.equals((String)fieldName, (String)FIELD_INDUCTIONINFO_NUMBER)) {
            args.setCancel(true);
            if (this.validateInductinInfo(appfileDy)) {
                return;
            }
            this.showInductinInfoPage(appfileDy);
        } else if (HRStringUtils.equals((String)fieldName, (String)"number") && appfileDy.getBoolean("isdelete")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5019\u9009\u4eba\u6570\u636e\u5df2\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u6570\u636e\u3002", (String)"AppFileList_6", (String)"tsc-tsrsc-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private boolean validataOffer(DynamicObject appfileDy) {
        Long oldOfferId;
        if (HRObjectUtils.isEmpty((Object)appfileDy)) {
            return true;
        }
        if (appfileDy.getLong("offer.id") == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"Offer\u5df2\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u6570\u636e\u3002", (String)"AppFileList_2", (String)"tsc-tsrsc-formplugin", (Object[])new Object[0]));
            return true;
        }
        DynamicObject offerDy = OfferServiceHelper.getInstance().queryOne((Object)appfileDy.getLong("offer.id"));
        if (HRObjectUtils.isEmpty((Object)offerDy)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"Offer\u5df2\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u6570\u636e\u3002", (String)"AppFileList_2", (String)"tsc-tsrsc-formplugin", (Object[])new Object[0]));
            return true;
        }
        Map idToOfferIdMaps = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("idToOfferIdMapsCache"), Map.class);
        Long l = oldOfferId = idToOfferIdMaps.get(appfileDy.getString("id")) == null ? Long.valueOf(0L) : (Long)idToOfferIdMaps.get(appfileDy.getString("id"));
        if (offerDy.getLong("id") != oldOfferId.longValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"Offer\u5df2\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u6570\u636e\u3002", (String)"AppFileList_2", (String)"tsc-tsrsc-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean validateInductinInfo(DynamicObject appfileDy) {
        if (HRObjectUtils.isEmpty((Object)appfileDy)) {
            return true;
        }
        if (appfileDy.getLong("inductioninfo.id") == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5165\u804c\u534f\u540c\u5df2\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u6570\u636e\u3002", (String)"AppFileList_3", (String)"tsc-tsrsc-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void showOfferPage(DynamicObject appfileDy) {
        if (HRObjectUtils.isEmpty((Object)appfileDy)) {
            return;
        }
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setPkId(appfileDy.get("offer.id"));
        baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        baseShowParameter.setStatus(OperationStatus.VIEW);
        long offerStatusId = appfileDy.getLong("offer.status.id");
        String offerAuditNumber = appfileDy.getString("offer.offerauditno");
        String offerBillStatus = appfileDy.getString("offer.billstatus");
        if (offerStatusId == OfferStatus.PRE_APPLY.getCode()) {
            if (HRStringUtils.isNotEmpty((String)offerAuditNumber) && !HRStringUtils.equals((String)offerBillStatus, (String)"F")) {
                baseShowParameter.setFormId("tso_somk_offerbaseinfo");
            } else if (HRStringUtils.isEmpty((String)offerAuditNumber) || HRStringUtils.isNotEmpty((String)offerAuditNumber) && HRStringUtils.equals((String)offerBillStatus, (String)"F")) {
                baseShowParameter.setFormId("tso_somk_waitofferbase");
            }
        } else {
            baseShowParameter.setFormId("tso_somk_offerbaseinfo");
        }
        this.getView().showForm((FormShowParameter)baseShowParameter);
    }

    private void showInductinInfoPage(DynamicObject appfileDy) {
        if (HRObjectUtils.isEmpty((Object)appfileDy)) {
            return;
        }
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setFormId("tso_inductioninfo");
        baseShowParameter.setStatus(OperationStatus.VIEW);
        baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        baseShowParameter.setPkId(appfileDy.get("inductioninfo.id"));
        this.getView().showForm((FormShowParameter)baseShowParameter);
    }

    private void cacheParentView(BaseShowParameter formShowParameter, String operateKey) {
        if (this.getView().getParentView() != null && this.getView().getParentView().getFormShowParameter().getFormId().contains("apphome")) {
            Object pageId = this.getView().getParentView().getFormShowParameter().getCustomParam(operateKey + "-" + this.getFocusRowPkId());
            if (pageId != null) {
                IFormView view = SessionManager.getCurrent().getView(pageId.toString());
                if (view == null) {
                    this.getView().getParentView().getFormShowParameter().setCustomParam(operateKey + "-" + this.getFocusRowPkId(), (Object)formShowParameter.getPageId());
                    this.getView().getParentView().cacheFormShowParameter();
                    return;
                }
                if (view.getFormShowParameter().getStatus() == OperationStatus.ADDNEW) {
                    formShowParameter.setPageId(pageId.toString());
                } else {
                    this.getView().getParentView().getFormShowParameter().setCustomParam(operateKey + "-" + this.getFocusRowPkId(), (Object)formShowParameter.getPageId());
                    this.getView().getParentView().cacheFormShowParameter();
                }
            } else {
                this.getView().getParentView().getFormShowParameter().setCustomParam(operateKey + "-" + this.getFocusRowPkId(), (Object)formShowParameter.getPageId());
                this.getView().getParentView().cacheFormShowParameter();
            }
        }
    }

    private boolean validateMutex(String formId, String operateKey) {
        StringBuilder stringBuilder = new StringBuilder();
        MutexLockInfo lockInfo = new MutexLockInfo();
        lockInfo.setEntityNumber(formId);
        lockInfo.setDataObjId(this.getFocusRowPkId().toString());
        lockInfo.setOperationKey(operateKey);
        lockInfo.setStrict(false);
        boolean isMutex = MutexHelper.require((MutexLockInfo)lockInfo, (StringBuilder)stringBuilder);
        if (!isMutex) {
            this.getView().showTipNotification(stringBuilder.toString());
            return false;
        }
        AutoReleaseLock.create().register(lockInfo.getDataObjId(), lockInfo.getEntityNumber(), lockInfo.getOperationKey());
        return true;
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if (HRStringUtils.equals((String)fieldName, (String)"offer.status.name")) {
            args.addCustomQFilter(new QFilter("id", "in", (Object)new Long[]{OfferStatus.PRE_APPLY.getCode(), OfferStatus.APPLYING.getCode(), OfferStatus.APPLY_PASS.getCode(), OfferStatus.APPLY_TERM.getCode(), OfferStatus.ALR_DISCARD.getCode()}));
        } else if (HRStringUtils.equals((String)fieldName, (String)"offerletter.letterstatus.name")) {
            args.addCustomQFilter(new QFilter("id", "in", (Object)new Long[]{OfferLetterStatus.PRE_SEND.getCode(), OfferLetterStatus.ALR_SEND.getCode(), OfferLetterStatus.PRE_GENERATE.getCode(), OfferLetterStatus.NOSEND_OUTTIME.getCode(), OfferLetterStatus.ALR_DISCARD.getCode()}));
            Map customParams = args.getCustomParams();
            customParams.put("fromF7", "offerletter.letterstatus.name");
        } else if (HRStringUtils.equals((String)fieldName, (String)"offerletter.replystatus.name")) {
            args.addCustomQFilter(new QFilter("id", "in", (Object)new Long[]{OfferLetterReplyStatus.PRE_REPLY.getCode(), OfferLetterReplyStatus.ALR_ACCEPT.getCode(), OfferLetterReplyStatus.ALR_OUTTIME.getCode(), OfferLetterReplyStatus.ALR_REFUSE.getCode()}));
            Map customParams = args.getCustomParams();
            customParams.put("fromF7", "offerletter.replystatus.name");
        }
    }
}

